/* -*-C++-*- */
/* GTK+-based objects for Hyperplay
   Copyright (C) 1997, 2000 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef _HYPERPLAY_GTK_H
#define _HYPERPLAY_GTK_H 1

#include <hyperplay/player.h>
#include <gtk/gtkwidget.h>
#include <vector>

namespace hyperplay
{
  using namespace std;

  namespace gtk
  {
    /* GTK+ frame.  The current implementation uses GdkRgb, which must
       be initialized in advance.  */
    class gtk_frame
      : public virtual frame
    {
    public:
      typedef GtkWidget *widget_type;

    private:
      view *_view;
      int width;
      int height;
      guchar *rgb_buf;
      vector<GtkWidget *> widgets;
      guint timeout_handler_id;

    public:
      gtk_frame(view *, int, int);
      ~gtk_frame();

    public:
      void set_size(int, int);

      void draw_rgb(int, int, unsigned char *, size_t, int, int);
      void draw_rgba(int, int, unsigned char *, size_t, int, int);

      /* Updates all the widgets using the current image.  */
      void update_area(int x, int y, int width, int height) const;

    public:
      /* Handles a timeout.  */
      bool handle_timeout();

      /* Creates a widget.  */
      GtkWidget *create_widget();

      /* Handles a destroy on widget W.  */
      void handle_destroy(GtkWidget *w);

      /* Handles expose event E on widget W.  */
      bool handle_expose_event(GtkWidget *w, GdkEventExpose *e) const;

      /* Handles button press event E on widget W.  */
      bool handle_button_press_event(GtkWidget *w, GdkEventButton *e);

      /* Handles motion notify event E on widget W.  */
      bool handle_motion_notify_event(GtkWidget *w, GdkEventMotion *e);
    };
  } // gtk
} // hyperplay

#endif /* not _HYPERPLAY_GTK_H */

