/* Document objects for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef _HYPERPLAY_DOCUMENT_H
#define _HYPERPLAY_DOCUMENT_H 1

#include <hyperplay/world.h>
#include <hyperplay/file.h>
#include <string>

namespace hyperplay
{
  using namespace std;

#ifdef HPLAY_API
  class HPLAY_API document;
#endif

  // Class `document'

  // A `document' provides methods to access a document of
  // Hyperplay stored in a file.  A document contains several contexts.

  class document
  {
  public:				// Information.
    string script_name () const;

  public:				// Data management.
    data_file::iterator world_chunk (unsigned int);
    data_file::iterator world_end ();

  protected:
    data_file file;
  public:
    void open (const string &n);
    void close ();

  public:
    document ();
    document (const string &);
    ~document ();
  };

} // hyperplay

#endif /* not _HYPERPLAY_DOCUMENT_H */

