/* -*-C++-*- */
/* Color object for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef _HYPERPLAY_COLOR_H
#define _HYPERPLAY_COLOR_H 1

#ifdef __GNUC__
# pragma interface "hyperplay/color.h"
#endif

#include <hyperplay/defs.h>

#if __WATCOMC__ > 1000
# pragma pack (push, 4)
#else
# pragma pack (4)
#endif

namespace hyperplay
{
  using namespace std;

  // Value type of a color element.
  typedef unsigned char color_component_type;

  // Color type.
  struct color
  {
    typedef color_component_type value_type;
    value_type red;
    value_type green;
    value_type blue;

    static value_type max_value() {return 0xff;}

    // Equality.
    friend bool
    operator== (const color &x, const color &y)
      {
	return (x.red      == y.red
		&& x.green == y.green
		&& x.blue  == y.blue);
      }

    // Constructors.
    color () {}
    color (value_type r, value_type g, value_type b)
      : red (r), green (g), blue (b) {}
  };				// struct hplay_color

  // Color inequality.
  inline bool
    operator!= (const color &x, const color &y)
  {
    return !(x == y);
  }

  color fade (const color &, int/* , int */);

  // Color type with an alpha channel.
  struct transparent_color
    : color
  {
    value_type alpha;

    // Equality.
    friend bool
    operator== (const transparent_color &x, const transparent_color &y)
      {
	return ((const color &) x == y
		&& x.alpha == y.alpha);
      }

    // Constructors.
    transparent_color () {}
    transparent_color (const color &c, value_type a)
      : color (c), alpha (a) {}
    transparent_color (value_type r, value_type g, value_type b, value_type a)
      : color (r, g, b), alpha (a) {}
  };				// struct transparent_color

  // Color inequality.
  inline bool
    operator!= (const transparent_color &x, const transparent_color &y)
  {
    return !(x == y);
  }

} // hyperplay

#if __WATCOMC__ > 1000
# pragma pack (pop)
#else
# pragma pack ()
#endif

#endif /* not __HYPERPLAY_COLOR_H */
