/* Hyperplay - multimedia authoring engine
   Copyright (C) 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#undef const
#undef inline

#include <gnome-xml/parser.h>
#include <string>
#include <cstdio>
#include <cstdlib>

using namespace std;

namespace
{
  /* Compiler.  */
  class compiler
  {
  protected:
    /* Compiles a document.  */
    void compile(xmlDoc *doc);

  public:
    /* Compiles a file.  */
    void compile(const char *file_name);
  };
} // (unnamed namespace)

void
compiler::compile(xmlDoc *doc)
{
  static const CHAR script[] = "script";
  if (doc->root == NULL || xmlStrcmp(doc->root->name, script) != 0)
    abort();

  static const CHAR name[] = "name";
  const CHAR *script_name = xmlGetProp(doc->root, name);
  string n(script_name, script_name + xmlStrlen(script_name));
  printf("name: %s\n", n.c_str());
}

void
compiler::compile(const char *file_name)
{
  xmlDoc *doc = xmlParseFile(file_name);
  if (doc == NULL)
    abort();

  compile(doc);

  xmlFreeDoc(doc);
}

/* Main function.  */
int
main(int argc, char **argv)
{
  compiler c;

  for (char **i = argv + 1; i != argv + argc; ++i)
    {
      c.compile(*i);
    }

  return EXIT_SUCCESS;
}

