/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : score.c                                          */
/* contenu       : calcul et affichage des scores                   */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <string.h>
#include <stdio.h>

#include "army.h"
#include "back.h"
#include "base.h"
#include "config.h"
#include "cursor.h"
#include "decal.h"
#include "dialog.h"
#include "disk.h"
#include "help.h"
#include "menu.h"
#include "score.h"
#include "sound.h"
#include "ticker.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static int get_cursor (int classement)
{
 int i,j,indice_curseur=-1;

 for (i=0;i<NB_TEAMS;++i)
     if (CURRENT_CURSOR[i].active
        && CURRENT_CURSOR[i].loose_time<0)
        {
         CURRENT_CURSOR[i].score_order=1;

         for (j=0;j<i;++j)
              if (CURRENT_CURSOR[j].active &&
                  ACTIVE_FIGHTERS[CURRENT_CURSOR[i].team]
                <=ACTIVE_FIGHTERS[CURRENT_CURSOR[j].team])
                 CURRENT_CURSOR[i].score_order++;
         for (j=i+1;j<NB_TEAMS;++j)
              if (CURRENT_CURSOR[j].active &&
                  ACTIVE_FIGHTERS[CURRENT_CURSOR[i].team]
                 <ACTIVE_FIGHTERS[CURRENT_CURSOR[j].team])
                 CURRENT_CURSOR[i].score_order++;
        }

 for (i=0;i<NB_TEAMS;++i)
     if (CURRENT_CURSOR[i].score_order==classement
        && CONFIG_TEAM_COLOR[i])
        indice_curseur=i;

 return indice_curseur;
}

/*------------------------------------------------------------------*/
static void write_score (int indice, char *buffer)
{
 int time,min,sec,pourmille,pourcent,decimale,l;

 if (indice>=0)
 {
  if (CURRENT_CURSOR[indice].score_order==1
     && PLAYING_TEAMS==1)
     strcpy (buffer,"Winner");
  else
  {
   if (CURRENT_CURSOR[indice].loose_time<=0)
    {
     pourmille= (ACTIVE_FIGHTERS[CURRENT_CURSOR[indice].team]*1000)
                /CURRENT_ARMY_SIZE;
     pourcent=pourmille/10;
     decimale=pourmille%10;
     sprintf (buffer,"%d",pourcent);
     l=strlen (buffer);
     buffer [l]='.';
     buffer [l+1]='0'+decimale;
     buffer [l+2]='%';
     buffer [l+3]=0;
    }
   else
     {
      time=CURRENT_CURSOR[indice].loose_time;
      min=time/60;
      sec=time%60;
      buffer[0]='0'+min/10;
      buffer[1]='0'+min%10;
      buffer[2]=':';
      buffer[3]='0'+sec/10;
      buffer[4]='0'+sec%10;
      buffer[5]=0;
     }
  }
 }
  else
      buffer[0]=0;
}

/*------------------------------------------------------------------*/
static int draw_score_bitmap (BITMAP *bitmap, int cursor,
                                               int ellipse_h,
                                               int fill_level)
{
 int w,h;
 int color1=0,color2=0;
 int y_rect1,y_rect2,x_mid;
 int to_be_filled,to_be_drawn;

 w=bitmap->w;
 if (!(w&1))
    w-=1;
 h=bitmap->h;
 y_rect1=ellipse_h/2;
 y_rect2=h-y_rect1-1;
 x_mid=w/2;
 if (cursor<0)
    fill_level=0;
 else
     {
      color1 =CURRENT_CURSOR[cursor].color_entry
             +COLORS_PER_TEAM/2;
      color2 =CURRENT_CURSOR[cursor].color_entry
             +COLORS_PER_TEAM-1;
     }
 if (fill_level<0)
    fill_level=0;
 to_be_filled=fill_level ? 1 : 0;
 to_be_drawn=fill_level>1000 ? 0 : 1;

 if (to_be_drawn)
 {
 fill_level=1000-fill_level;
 fill_level*=h-3*y_rect1;
 fill_level/=1000;
 fill_level+=2*y_rect1;

 rectfill (bitmap,0,0,w,h,0);

 if (to_be_filled)
    ellipsefill (bitmap,x_mid,y_rect2,x_mid,ellipse_h/2,color1);
 ellipse (bitmap,x_mid,y_rect2,x_mid,ellipse_h/2,MENU_FG);
 if (to_be_filled)
    {
     rectfill (bitmap, 1,fill_level, x_mid*2-1, y_rect2-1,color1);
     ellipsefill (bitmap,  x_mid,fill_level,
                           x_mid-1,ellipse_h/2-1,color2);
    }

 vline (bitmap, 0, y_rect1, y_rect2, MENU_FG);
 vline (bitmap, x_mid*2, y_rect1, y_rect2, MENU_FG);

 ellipse (bitmap,x_mid,y_rect1,x_mid,ellipse_h/2,MENU_FG);
 }
 return to_be_drawn;
}

/*------------------------------------------------------------------*/
int display_scores (void)
 {
  int last_draw_done=0;
  int first_ticker,diff_ticker;
  int retour=0,choix=MENU_QUICK_MAIN;
  DIALOG d[8];
  DIALOG_PLAYER *dp;
  char buf1[33],buf2[33],buf3[33];
  int x[3];
  int h[3];
  int w,y;
  int ellipse_h;
  int i;
  int cursor[3];
  BITMAP *eprouvette[3];
  int time_delay[3]={500,2500,1500};

  quick_buttons(d);
  for (i=0; i<3; ++i)
      {
       standard_small_button (d+i+4,i,10,3,11);
       d[i+4].proc=my_textbox_proc;
      }

  d[4].dp=buf2;
  d[5].dp=buf1;
  d[6].dp=buf3;
  d[7].proc=NULL;

  ellipse_h=d[4].h;
  y=d[4].y-menu_real_y(MENU_H_SPACE);
  h[1]=2*y-SCREEN_H;
  h[0]=h[1]/2;
  h[2]=(3*h[1])/4;
  w=d[4].w;
  x[0]=d[4].x;
  x[1]=d[5].x;
  x[2]=d[6].x;

  cursor[0]=get_cursor(3);
  cursor[1]=get_cursor(1);
  cursor[2]=get_cursor(2);

  for (i=0;i<3;++i)
      {
       write_score (cursor[i], d[4+i].dp);
       eprouvette[i]=my_create_bitmap (w,h[i]);
      }

  d[MENU_QUICK_QUIT].flags=D_HIDDEN;
  d[MENU_QUICK_HELP].flags=D_HIDDEN;

  display_back_image ();
  dp=init_dialog (d,0);
  update_dialog (dp);
  shutdown_dialog (dp);

  my_fade_in();
  play_win();
  first_ticker=get_ticker();

  while (retour==0)
         {
         if (!last_draw_done)
         {
         dp=init_dialog (d,choix);
         while (update_dialog (dp) && !last_draw_done)
               {
                diff_ticker=get_ticker()-first_ticker;
                if (cursor[0]<0)
                   diff_ticker+=1000;

                for (i=0;i<3;++i)
                    {
                     if (draw_score_bitmap
                        (eprouvette[i],
                        cursor[i],
                        ellipse_h,
                        diff_ticker-time_delay[i]))
                     draw_sprite (screen, eprouvette[i],
                                 x[i],y-h[i]);
                     else
                         if (i==1)
                            last_draw_done=1;
                    }
               }
         choix=shutdown_dialog (dp);
         }
         if (last_draw_done)
            {
             for (i=0;i<3;++i)
                 draw_sprite (screen, eprouvette[i],
                             x[i],y-h[i]);
             d[MENU_QUICK_QUIT].flags=D_EXIT;
             d[MENU_QUICK_HELP].flags=D_EXIT;
             choix= my_do_dialog_no_clear(d,
                    last_draw_done==1 ? MENU_QUICK_MAIN
                                      : choix);
             last_draw_done=2;
            }

         switch (choix)
            {
             case -1:
             case MENU_QUICK_BACK:
                  retour=1;
                  break;
             case MENU_QUICK_MAIN:
                  retour=MENU_TOP;
                  break;
             case MENU_QUICK_QUIT:
                  if (confirm_quit())
                    retour=MENU_EXIT;
                  else
                    display_back_image();
                  break;
             case MENU_QUICK_HELP:
                  retour=display_help (HELP_TEXT_SCORE);
                  display_back_image ();
                  break;
             }
        }

 for (i=0;i<3;++i)
     destroy_bitmap(eprouvette[i]);
 if (retour>0)
    retour--;

 return retour;
}


