/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : move.c                                           */
/* contenu       : deplacement des curseurs                         */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "area.h"
#include "autoplay.h"
#include "config.h"
#include "cursor.h"
#include "joystick.h"
#include "keyboard.h"
#include "mesh.h"
#include "mouse.h"
#include "move.h"
#include "time.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
/*
 * moves a cursor in a given direction if the place is free
 * one just has to give the x & y values of the cursors as params
 */
static int move_if_free (int *x, int *y, int dir)
{
 int moved=0;

 /*
  * we check if the direction is between 1 and 8
  * if not force it into this range
  */
 while (dir>8)
    dir-=8;
 while (dir<1)
    dir+=8;

 /*
  * switch between all dirs
  * in all the cases, the method is the same, we check if
  * there's a mesh pointer defined for the target position
  * if yes, this implies there are no walls. check area.c and mesh.c
  * to understand while testing the mesh attribute is OK.
  * then we keep track of the result of the move, for later
  * we'll need to know if the cursor has really been moved
  * this result is stored in the moved value
  */
 switch (dir)
  {
   /*
    * trying to go NORTH
    */
   case 1: if (CURRENT_AREA[((*y)-1)*CURRENT_AREA_W+(*x)].mesh)
              {
               (*y)--;
               moved=1;
              }
           break;
   /*
    * trying to go NORTH EAST
    */
   case 2: if (CURRENT_AREA[((*y)-1)*CURRENT_AREA_W+(*x)+1].mesh)
              {
               (*y)--;
               (*x)++;
                moved=1;
              }
           break;
   /*
    * trying to go EAST
    */
   case 3: if (CURRENT_AREA[(*y)*CURRENT_AREA_W+(*x)+1].mesh)
              {
               (*x)++;
               moved=1;
              }
           break;
   /*
    * trying to go SOUTH EAST
    */
   case 4: if (CURRENT_AREA[((*y)+1)*CURRENT_AREA_W+(*x)+1].mesh)
              {
               (*x)++;
               (*y)++;
                moved=1;
              }
           break;
   /*
    * trying to go SOUTH
    */
   case 5: if (CURRENT_AREA[((*y)+1)*CURRENT_AREA_W+(*x)].mesh)
              {
               (*y)++;
               moved=1;
              }
           break;
   /*
    * trying to go SOUTH WEST
    */
   case 6: if (CURRENT_AREA[((*y)+1)*CURRENT_AREA_W+(*x)-1].mesh)
              {
               (*y)++;
               (*x)--;
                moved=1;
              }
           break;
   /*
    * trying to go WEST
    */
   case 7: if (CURRENT_AREA[(*y)*CURRENT_AREA_W+(*x)-1].mesh)
              {
               (*x)--;
               moved=1;
              }
           break;
   /*
    * trying to go NORTH WEST
    */
   case 8: if (CURRENT_AREA[((*y)-1)*CURRENT_AREA_W+(*x)-1].mesh)
              {
               (*x)--;
               (*y)--;
               moved=1;
              }
  }
 return moved;
}

/*------------------------------------------------------------------*/
/*
 * moves a cursor
 * in fact it interprets the key_state value , calculates the
 * direction to use and then calls move_if_free
 */
static void move_cursor (int indice)
{
 int dir=0,up,down,right,left,horiz=0,vert=0,moved=0,team;
 char key_state;
 MESH *mesh;

 /*
  * we get the team associated to the cursor
  */
 team=CURRENT_CURSOR[indice].team;
 /*
  * we get the mesh item associated to the current position of the cursor
  */
 mesh=CURRENT_AREA [CURRENT_CURSOR[indice].y*CURRENT_AREA_W
                   +CURRENT_CURSOR[indice].x].mesh;
 /*
  * we tell the mesh that the info won't be up to date anymore concerning
  * this position
  */
 mesh->info[team].update.time=-1;

 /*
  * the key_state value gives the state of all pressed/unpressed keys
  */
 key_state=CURRENT_CURSOR[indice].key_state;

 /*
  * we interpret the content of the key_state value with binary masks
  */
 up=key_state&CURSOR_KEY_UP;
 right=key_state&CURSOR_KEY_RIGHT;
 down=key_state&CURSOR_KEY_DOWN;
 left=key_state&CURSOR_KEY_LEFT;

 /*
  * if both left and right keys are pressed, no horizontal move!
  */
 if ((right&&left) || ((!right)&&(!left)))
    horiz=0;
 /*
  * if right key is pressed but not left key, let's go right
  */
 if (right&&(!left))
    horiz=1;
 /*
  * if left key is pressed but not right key, let's go left
  */
 if ((!right)&&left)
    horiz=-1;

 /*
  * if both up and down keys are pressed, no verical move!
  */
 if ((up&&down) || ((!up)&&(!down)))
    vert=0;
 /*
  * if up key is pressed but not down key, let's go up
  */
 if (up&&(!down))
    vert=-1;
 /*
  * if down key is pressed but not up key, let's go down
  */
 if ((!up)&&down)
    vert=1;

 /*
  * the cursor does not move at all
  */
 if (horiz==0 && vert==0)
    dir=0;
 /*
  * the cursor heads NORTH
  */
 if (horiz==0 && vert==-1)
    dir=1;
 /*
  * the cursor heads NORTH EAST
  */
 if (horiz==1 && vert==-1)
    dir=2;
 /*
  * the cursor heads EAST
  */
 if (horiz==1 && vert==0)
    dir=3;
 /*
  * the cursor heads SOUTH EAST
  */
 if (horiz==1 && vert==1)
    dir=4;
 /*
  * the cursor heads SOUTH
  */
 if (horiz==0 && vert==1)
    dir=5;
 /*
  * the cursor heads SOUTH WEST
  */
 if (horiz==-1 && vert==1)
    dir=6;
 /*
  * the cursor heads WEST
  */
 if (horiz==-1 && vert==0)
    dir=7;
 /*
  * the cursor heads NORTH WEST
  */
 if (horiz==-1 && vert==-1)
    dir=8;

 /*
  * if no direction has been found, we do nothing
  */
 if (dir)
    {
    /*
     * we first try to move in the direction we have calculated
     */
    moved=move_if_free (&(CURRENT_CURSOR[indice]).x,
                        &(CURRENT_CURSOR[indice]).y,
                        dir);
    /*
     * if it did not work, we try another direction
     * for instance if the direction was NORTH WEST we try WEST
     */
    if (!moved)
        moved=move_if_free (&(CURRENT_CURSOR[indice]).x,
                            &(CURRENT_CURSOR[indice]).y,
                            dir-1);
    /*
     * if it did not work, we try another direction
     * for instance if the direction was NORTH WEST we try NORTH
     */
    if (!moved)
        moved=move_if_free (&(CURRENT_CURSOR[indice]).x,
                            &(CURRENT_CURSOR[indice]).y,
                            dir+1);
    }
 /*
  * now this is quite a subtle line
  * we decrement the value of the cursor when
  * - the cursor has moved, this is required since it means
  *   that the cursor is now 1 pixel farer from all the fighters
  *   as long as the gradient spreading has proven the contrary
  * or
  * - a condition base on the global clock is filled.
  *   this avoids cyclic behaviors and some "lost" fighters which
  *   might otherwise start looping in a corner of the map
  */
 if (moved || !(GLOBAL_CLOCK%(NB_DIRS+1)))
    {
     CURRENT_CURSOR[indice].val--;
    }

 /*
  * we retrieve the new mesh item associated to the new position
  */
 mesh=CURRENT_AREA [CURRENT_CURSOR[indice].y*CURRENT_AREA_W
                   +CURRENT_CURSOR[indice].x].mesh;
 /*
  * we tell the mesh where the cursor is
  * this information is redundant but it avoids complex things such as 
  * my_struct->....->...   ...->...->my_attribute;
  */
 mesh->info[team].update.cursor.x=CURRENT_CURSOR[indice].x;
 mesh->info[team].update.cursor.y=CURRENT_CURSOR[indice].y;
}

/*------------------------------------------------------------------*/
/*
 * updates the key_state value for a local player, ie polls the keys
 * it might also poll the joystick but this is transparent
 */
static void update_key_local_cursor (int indice)
{
 /*
  * the following code is pretty much the same for each key.
  * the is_touched_key will automatically poll the right device,
  * keyboard, mouse or joystick and return true if the logical
  * is in a "pressed" state
  */
 CURRENT_CURSOR[indice].key_state
  =is_touched_key (CONFIG_KEY_UP[indice]) ? CURSOR_KEY_UP : 0;
 CURRENT_CURSOR[indice].key_state
 +=is_touched_key (CONFIG_KEY_RIGHT[indice]) ? CURSOR_KEY_RIGHT : 0;
 CURRENT_CURSOR[indice].key_state
 +=is_touched_key (CONFIG_KEY_DOWN[indice]) ? CURSOR_KEY_DOWN : 0;
 CURRENT_CURSOR[indice].key_state
 +=is_touched_key (CONFIG_KEY_LEFT[indice]) ? CURSOR_KEY_LEFT : 0;
}

/*------------------------------------------------------------------*/
/*
 * polls the key_state for a cursor associated to a remote player
 */
static void update_key_network_cursor (int indice)
{
 /*
  * there should be a call to a function located in a "network.c"
  * file or something approaching 8-)
  */
 CURRENT_CURSOR[indice].key_state=0;
}

/*------------------------------------------------------------------*/
/*
 * updates the key_state for a cursor which is AI driven
 */
static void update_key_cpu_cursor (int indice)
{
 /*
  * get_computer_next_move is the main AI function
  */
 CURRENT_CURSOR[indice].key_state
 =get_computer_next_move(indice);
}

/*------------------------------------------------------------------*/
/*
 * moves all the cursors, (logical, eh?)
 * the kind of function one might wish to use in the main game loop
 */
void move_all_cursors (void)
{
 int i,j;

 /*
  * polls the module which wraps mouse moves to virtual keys
  */
 update_mouse_control();
 /*
  * polls the joystick
  */
 my_poll_joystick();
 /*
  * one might wish to poll network stuff here but I'm not sure it's
  * the right place because of performance issues
  */

 /*
  * loop for all the teams, the cursor of which is active
  */
 for (i=0;i<NB_TEAMS;++i)
   if (CURRENT_CURSOR[i].active)
      {
      if (CURRENT_CURSOR[i].cpu_or_human)
          /*
           * the cursor is CPU driven
           * we move of as much pixels as specified in the config
           * this way one can have fast moving cursors
           * it's important to note that in this case the loop embraces
           * both update and move functions. this is because for
           * an AI controlled cursor, one might wish to have different
           * directions for each move, even if the moves are done at
           * almost the very same moment
           */
          for (j=0; j<=CONFIG_CURSOR_INCREASE_SPEED; ++j)
             {
              if (CURRENT_CURSOR[i].from_network)
                 /*
                  * the cursor is CPU driven but is controlled by
                  * a remote CPU, so we poll info from network
                  */
                 update_key_network_cursor(i);
              else
                  /*
                   * we ask the AI module to tell the cursor what to do
                   */
                  update_key_cpu_cursor(i);
              /*
               * moves the cursor, following the instructions given
               * by the update_?_cursor function
               */
              move_cursor (i);
             }
      else
          {
           /*
            * the cursor is a human player (plays better 8-)
            */
           if (CURRENT_CURSOR[i].from_network)
              /*
               * remote player, let's get info from the network
               */
              update_key_network_cursor(i);
           else
               /*
                * local player, poll keys
                */
               update_key_local_cursor(i);
           /*
            * we move of as much pixels as specified in the config
            * this way one can have fast moving cursors.
            * note that in this case, we use the same direction
            * for all the moves. indeed, there are little chances
            * that the keyboard state changes in 1/100000 sec ;)
            */
           for (j=0; j<=CONFIG_CURSOR_INCREASE_SPEED; ++j)
               move_cursor (i);
          }
      }
}




