/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : map.c                                            */
/* contenu       : decryptage des tableaux en memoire               */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "alleg2.h"
#include "bigdata.h"
#include "disk.h"
#include "map.h"
#include "texture.h"

/*==================================================================*/
/* constantes                                                       */
/*==================================================================*/

#define LIGHT_OR_DARK_TRESHOLD 315
#define CONSIDERED_AS_DARK 0
#define CONSIDERED_AS_LIGHT 2
#define PLAYABLE_AREA 1
#define MINI_SIDE_SIZE 4
#define MINI_PLAYABLE_AREA 1024

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static void sort_light_and_dark (BITMAP *bmp, PALETTE pal)
{
 char table[256];
 int i,x,y;

 for (i=0;i<256;++i)
    {
     if (6*pal[i].r+3*pal[i].g+pal[i].b > LIGHT_OR_DARK_TRESHOLD)
        table[i]=CONSIDERED_AS_LIGHT;
     else
         table[i]=CONSIDERED_AS_DARK;
    }

 for (y=0;y<bmp->h;++y)
     for (x=0;x<bmp->w;++x)
         putpixel (bmp, x, y, table[getpixel (bmp, x, y)]);
}

/*------------------------------------------------------------------*/
static BITMAP *extract_significant_part (BITMAP *src)
{
 int min_x=src->w;
 int min_y=src->h;
 int max_x=-1;
 int max_y=-1;
 int dst_x,dst_y,dst_w,dst_h;
 int x,y;
 BITMAP *result;

 for (y=0;y<src->h;++y)
     for (x=0;x<src->w;++x)
         if (getpixel (src,x,y)==CONSIDERED_AS_DARK)
            {
             if (min_x>x)
                min_x=x;
             if (min_y>y)
                min_y=y;
             if (max_x<x)
                max_x=x;
             if (max_y<y)
                max_y=y;
            }
 dst_x=min_x;
 dst_y=min_y;
 dst_w=max_x-min_x+1;
 dst_h=max_y-min_y+1;

 if (dst_w<MINI_SIDE_SIZE || dst_h<MINI_SIDE_SIZE)
     result=NULL;
 else
     {
      result=create_bitmap (dst_w, dst_h);
      if (result)
         blit (src, result, dst_x, dst_y, 0, 0, dst_w, dst_h);
     }

 return result;
}

/*-----------------------------------------------------------------*/
static int spread_color_down (BITMAP *bmp, int color1, int color2)
{
 int x,y,x1,y1,x2,y2,found=0;

 for (y=0;y<bmp->h;++y)
     for (x=0;x<bmp->w;++x)
         if (getpixel (bmp,x,y)==color2)
            {
             x1=x-1;
             if (x1<0)
                x1=0;
             x2=x+1;
             if (x2>bmp->w-1)
                x2=bmp->w-1;
             y1=y-1;
             if (y1<0)
                y1=0;
             y2=y+1;
             if (y2>bmp->h-1)
                y2=bmp->h-1;

             if (getpixel (bmp,x2,y)==color1)
               {
                putpixel (bmp,x2,y,color2);
                found++;
               }
             if (getpixel (bmp,x2,y2)==color1)
               {
                putpixel (bmp,x2,y2,color2);
                found++;
               }
             if (getpixel (bmp,x,y2)==color1)
               {
                putpixel (bmp,x,y2,color2);
                found++;
               }
             if (getpixel (bmp,x1,y2)==color1)
               {
                putpixel (bmp,x1,y2,color2);
                found++;
               }
            }

 return found;
}

/*-----------------------------------------------------------------*/
static int spread_color_up (BITMAP *bmp, int color1, int color2)
{
 int x,y,x1,y1,x2,y2,found=0;

 for (y=bmp->h-1;y>=0;--y)
     for (x=bmp->w-1;x>=0;--x)
         if (getpixel (bmp,x,y)==color2)
            {
             x1=x-1;
             if (x1<0)
                x1=0;
             x2=x+1;
             if (x2>bmp->w-1)
                x2=bmp->w-1;
             y1=y-1;
             if (y1<0)
                y1=0;
             y2=y+1;
             if (y2>bmp->h-1)
                y2=bmp->h-1;

             if (getpixel (bmp,x1,y)==color1)
               {
                putpixel (bmp,x1,y,color2);
                found++;
               }
             if (getpixel (bmp,x1,y1)==color1)
               {
                putpixel (bmp,x1,y1,color2);
                found++;
               }
             if (getpixel (bmp,x,y1)==color1)
               {
                putpixel (bmp,x,y1,color2);
                found++;
               }
             if (getpixel (bmp,x2,y1)==color1)
               {
                putpixel (bmp,x2,y1,color2);
                found++;
               }
            }

 return found;
}


/*-----------------------------------------------------------------*/
static int check_if_playable (BITMAP *bmp)
{
 int x,y,x0,y0;
 int unplayable=0;
 int playable_place=0;

 for (x=0;x<bmp->w;++x)
     {
      putpixel (bmp,x,0,CONSIDERED_AS_DARK);
      putpixel (bmp,x,bmp->h-1,CONSIDERED_AS_DARK);
     }
 for (y=0;y<bmp->h;++y)
     {
      putpixel (bmp,0,y,CONSIDERED_AS_DARK);
      putpixel (bmp,bmp->w-1,y,CONSIDERED_AS_DARK);
     }

 x0=y0=-1;
 for (y=0;y<bmp->h && y0<0;++y)
     for (x=0;x<bmp->w && x0<0;++x)
         if (getpixel(bmp,x,y)==CONSIDERED_AS_LIGHT)
            {
             x0=x;
             y0=y;
            }

 if (x0>0 && y0>0)
    {
     putpixel (bmp,x,y,PLAYABLE_AREA);
     while (  spread_color_down(bmp, CONSIDERED_AS_LIGHT,
                                     PLAYABLE_AREA)
           +  spread_color_up (bmp, CONSIDERED_AS_LIGHT,
                                    PLAYABLE_AREA));
    }
 else
     unplayable|=1;

 for (y=0;y<bmp->h;++y)
     for (x=0;x<bmp->w;++x)
         if (getpixel (bmp,x,y)==PLAYABLE_AREA)
            ++playable_place;

 unplayable|=(playable_place<MINI_PLAYABLE_AREA);

 return (!unplayable);
}

/*-----------------------------------------------------------------*/
static void convert_to_buffer (BITMAP *bmp, char *buffer,
                               int *size, int *bg_size)
{
 int pos_src,l,wh;
 char *data;

 wh=bmp->h*bmp->w;
 data=bmp->dat;
 pos_src=0;
 (*size)=0;
 (*bg_size)=0;

 while (pos_src<wh)
   {
   l=0;
   if (data[pos_src]!=PLAYABLE_AREA)
      {
       while (pos_src<wh &&(data[pos_src]!=
                         PLAYABLE_AREA) && l<127)
         {
          l++;
          pos_src++;
         }
       buffer[(*size)++]=l;
      }
   else
      {
       while (pos_src<wh && (data[pos_src]==
                            PLAYABLE_AREA) && l<127)
         {
          l++;
          pos_src++;
         }
       buffer[(*size)++]=-l;
       (*bg_size)+=l;
      }
   }
 buffer[(*size)++]=0;
}

/*------------------------------------------------------------------*/
void *archive_raw_map (const char *filename)
{
 int i,w=0,h=0,size,bg_size;
 BITMAP *bmp,*sub_bmp;
 PALETTE pal;
 char *temp=NULL,*result=NULL;
 short *ptr_wh;
 int *ptr_bg;

 bmp=load_bitmap (filename,pal);
 if (bmp)
    {
     sort_light_and_dark (bmp,pal);
     sub_bmp=extract_significant_part (bmp);
     if (sub_bmp)
        {
         w=sub_bmp->w;
         h=sub_bmp->h;
         if (check_if_playable (sub_bmp))
            {
             temp=malloc_in_big_data_bottom (w*h+1);
             if (temp)
                convert_to_buffer (sub_bmp,temp,&size,&bg_size);
            }
         destroy_bitmap (sub_bmp);
        }
     destroy_bitmap (bmp);
    }

 if (temp)
    {
     result=malloc (size+8);
     if (result)
        {
         ptr_bg=(void *) ptr_wh=(void *) result;
         ptr_bg[0]=bg_size;
         ptr_wh[2]=w;
         ptr_wh[3]=h;
         for (i=0;i<size;++i)
             result[i+8]=temp[i];
        }
     free_last_big_data_bottom ();
    }

 return result;
}

/*------------------------------------------------------------------*/
BITMAP *create_bicolor_map (int num, int fg, int bg)
{
 int   pos_dst,pos_src,w,h,i,l,color;
 signed char *data_dst,*data_src;
 short *data2;
 BITMAP *result;

 if (num>RAW_MAP_NUMBER-1)
    num=RAW_MAP_NUMBER-1;

 data_src=RAW_MAP_ORDERED[num];
 data2=RAW_MAP_ORDERED[num];
 data_src+=8;
 w=data2[2];
 h=data2[3];

 pos_src=pos_dst=0;
 result=my_create_bitmap (w,h);

 if (result)
  {
   data_dst=result->dat;
   while ((l=data_src[pos_src++])!=0)
         {
          if (l>0)
             color=fg;
          else
              {
               l=-l;
               color=bg;
              }
          for (i=0;i<l;++i)
               data_dst[pos_dst++]=color;
         }
  }
 return result;
}

/*------------------------------------------------------------------*/
BITMAP *create_textured_map (int num, int fg, int bg)
{
 int   x,y,w,h,color;
 BITMAP *result=NULL,*bg_tex,*fg_tex;
 int   fg_w,fg_h;
 int   bg_w,bg_h;


 bg_tex=create_bg_texture (bg);
 fg_tex=create_fg_texture (fg);
 if (bg_tex && fg_tex)
 {
 bg_w=bg_tex->w;
 bg_h=bg_tex->h;
 fg_w=fg_tex->w;
 fg_h=fg_tex->h;

 result=create_bicolor_map (num,1,0);
 if (result)
  {
  w=result->w;
  h=result->h;
  for (y=0;y<h;++y)
     for (x=0;x<w;++x)
         {
          if (getpixel (result,x,y))
             color=getpixel (fg_tex,x%fg_w,y%fg_h);
          else
             color=getpixel (bg_tex,x%bg_w,y%bg_h);
          putpixel (result,x,y,color);
          }
  }
 }

 if (bg_tex)
    destroy_bitmap (bg_tex);

 if (fg_tex)
    destroy_bitmap (fg_tex);

 return result;
}


