/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : disp.c                                           */
/* contenu       : affichage de l'aire de jeu                       */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "area.h"
#include "config.h"
#include "disp.h"
#include "grad.h"
#include "viewport.h"
#include "wave.h"
#include "distor.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static void disp_stretch_area (void)
{
    stretch_blit (CURRENT_AREA_DISP,NEXT_SCREEN, 0,0,
                 CURRENT_AREA_W, CURRENT_AREA_H,
                 0,0,NEXT_SCREEN->w,NEXT_SCREEN->h);
}

/*------------------------------------------------------------------*/
void display_area (void)
{
 if ((CONFIG_WAVE_AMPLI[0]
    ||CONFIG_WAVE_AMPLI[1]
    ||CONFIG_WAVE_AMPLI[2]
    ||CONFIG_WAVE_AMPLI[3])
    &&CONFIG_WAVE_ON)
    disp_distorted_area();
 else
     disp_stretch_area();
}

/*------------------------------------------------------------------*/
void display_gradient (int i)
{
 BITMAP *bmp;

 bmp=create_gradient_bitmap (i);
 if (bmp)
    {
     stretch_blit (bmp,NEXT_SCREEN, 0,0,bmp->w, bmp->h,
                   0,0,NEXT_SCREEN->w,NEXT_SCREEN->h);
                 destroy_bitmap (bmp);
    }
}

/*------------------------------------------------------------------*/
void display_mesh (int i)
{
 BITMAP *bmp;

 bmp=create_mesh_bitmap (i);
 if (bmp)
    {
     stretch_blit (bmp,NEXT_SCREEN, 0,0,bmp->w, bmp->h,
                   0,0,NEXT_SCREEN->w,NEXT_SCREEN->h);
                 destroy_bitmap (bmp);
    }
}


