/*
 * glChess - A 3D chess interface
 *
 * Copyright (C) 2001  Robert Ancell <bob27@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <GL/gl.h>

typedef struct _FileEntry {
  struct _PlayerPage *page;

  GtkWidget *entry, *elipse_button;
  gchar *filesel_title;
  GtkWidget *filesel;
} FileEntry;

typedef struct _ColourEntry {
  struct _PlayerPage *page;

  GtkWidget *cpanel, *colour_selection;
  GLfloat **colours;
} ColourEntry;

typedef struct _PlayerPage {
  struct _PreferenceDialog *pdialog;
  Player *player;

  GtkWidget *table;
  /*
   * Name entry 
   */
  GtkWidget *name_entry;
  /*
   * Colour entry 
   */
  ColourEntry *pcolour_entry, *scolour_entry, *bcolour_entry;
  /*
   * Texture file entries 
   */
  FileEntry *tfile_entry, *ptfile_entry, *sptfile_entry, *btfile_entry;
  GtkWidget *thumbnail;		/*
				 * gtkglarea widget for thumbnail/preview 
				 */
} PlayerPage;

typedef struct _PreferenceDialog {
  glChessWidget *glcwidget;
  Game *game_copy;

  GtkWidget *dialog;

  /*
   * The buttons 
   */
  GtkWidget *ok_button, *apply_button, *cancel_button;

  /*
   * The notebook 
   */
  GtkWidget *notebook;
  /*
   * The pages 
   */
  PlayerPage *white_page, *black_page;
} PreferenceDialog;

GtkWidget *add_text_entry(GtkWidget *, gchar *, gchar *, gint);
void toggle_value(GtkWidget *, int *);
GtkWidget *add_check_button(PreferenceDialog *, GtkWidget *, gchar *,
			    int *, gint);

void store_file_name(GtkWidget *, char **);
void set_file_name(GtkWidget *, FileEntry *);
void get_file_name(GtkWidget *, FileEntry *);
FileEntry *add_file_entry(PlayerPage *, gchar *, gchar *, gint);
void reload_thumbnail_textures(GtkWidget *, PlayerPage *);
FileEntry *add_texture_file_entry(PlayerPage *, gchar *, gchar **, gint);

void draw_thumbnail(PlayerPage *);
void reshape_thumbnail(int, int);
gint thumbnail_expose_view(GtkWidget *, GdkEventExpose *, PlayerPage *);
gint thumbnail_reshape_view(GtkWidget *, GdkEventConfigure *,
			    PlayerPage *);
gint thumbnail_init_view(GtkWidget *, PlayerPage *);
void add_piece_thumbnail(PlayerPage *, guint);

void set_cpanel_colour(GtkWidget *, ColourEntry *);
void set_colour(GtkWidget *, ColourEntry **);
void edit_colour(GtkWidget *, GdkEvent *, ColourEntry *);
GtkWidget *add_colour_entry(GtkWidget *, gchar *, gint);
ColourEntry *add_player_colour_entry(PlayerPage *, gchar *, GLfloat **,
				     gint);

void change_player_name(GtkWidget *, Player *);

PlayerPage *add_player_page(PreferenceDialog *, Player *, char *);

void set_cecp_mode(GtkWidget *, PreferenceDialog *);
void set_cecp_searchd(GtkAdjustment *, PreferenceDialog *);
void set_cecp_ai_player(GtkWidget *, PreferenceDialog *);
void add_cecp_page(PreferenceDialog *);

void apply_preferences(GtkWidget * widget, PreferenceDialog *);
void display_new_preferences(GtkWidget *, PreferenceDialog *);
void preferences(glChessWidget *, guint, GtkWidget *);
