/*
 * glChess - A 3D chess interface
 *
 * Copyright (C) 2001  Robert Ancell <bob27@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * This file contains all the player creation and modification functions 
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "global.h"
#include "player.h"

/*
 * Creates a new player 
 */
Player *new_player(char *name)
{
  Player *player = malloc(sizeof(Player));
  int i;

  if (player == NULL)
  {
    fprintf(stderr, "Unable to allocate space for new player\n");
    return NULL;
  }

  player->name = NULL;
  set_player_name(player, name);

  /*
   * Reset the colour/texture data 
   */
  player->piece_colour = malloc(sizeof(GLfloat) * 4);
  player->selected_colour = malloc(sizeof(GLfloat) * 4);
  player->board_colour = malloc(sizeof(GLfloat) * 4);
  for (i = 0; i < 4; i++)
  {
    player->piece_colour[i] = 1.0;
    player->selected_colour[i] = 1.0;
    player->board_colour[i] = 1.0;
  }
  player->texture_dir = NULL;
  player->piece_texture_file = NULL;
  player->piece_texture = 0;
  player->selected_piece_texture_file = NULL;
  player->selected_piece_texture = 0;
  player->board_texture_file = NULL;
  player->piece_texture = 0;

  return player;
}

/*
 * Resets a players properties, ie for a new game 
 */
void reset_player(Player * player)
{
  player->pieces = 0;
  player->score = 0;
  player->time = 0.0;
}

/*
 * Changes the players name 
 */
void set_player_name(Player * player, char *name)
{
  free(player->name);
  player->name = malloc((strlen(name) + 1) * sizeof(char));
  strcpy(player->name, name);
}

/*
 * Copies an existing player 
 */
Player *copy_player(Player * player)
{
  Player *player_copy = new_player(player->name);
  int i;

  if (player_copy == NULL)
  {
    fprintf(stderr, "Unable to allocate space for player copy\n");
    return NULL;
  }

  /*
   * Copy the score/time data 
   */
  player_copy->pieces = player->pieces;
  player_copy->score = player->score;
  player_copy->time = player->time;

  /*
   * Copy the colour/texture data 
   */
  for (i = 0; i < 4; i++)
  {
    player_copy->piece_colour[i] = player->piece_colour[i];
    player_copy->selected_colour[i] = player->selected_colour[i];
    player_copy->board_colour[i] = player->board_colour[i];
  }
  player_copy->texture_dir = strdup(player->texture_dir);
  player_copy->piece_texture_file = strdup(player->piece_texture_file);
  player_copy->piece_texture = player->piece_texture;
  player_copy->selected_piece_texture_file =
      strdup(player->selected_piece_texture_file);
  player_copy->selected_piece_texture = player->selected_piece_texture;
  player_copy->board_texture_file = strdup(player->board_texture_file);
  player_copy->board_texture = player->board_texture;

  return player_copy;
}

/*
 * Remove a player 
 */
void free_player(Player * player)
{
  free(player->name);
  free(player->piece_colour);
  free(player->selected_colour);
  free(player->board_colour);
  free(player);
}
