/*
 * glChess - A 3D chess interface
 *
 * Copyright (C) 2001  Robert Ancell <bob27@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include "global.h"
#include "main.h"
#include "config.h"
#include "models.h"
#include "texture.h"
#include "game.h"
#include "draw.h"
#include "interface.h"
#include "splash.h"

/*
 * Set up openGL 
 */
void init_gl(Game * game)
{
  float light0_diffuse[4] = { 1.0, 1.0, 1.0, 1.0 };
  float light0_ambient[4] = { 0.125, 0.125, 0.125, 0.0 };
  float fog_colour[4] = { 0.0, 0.0, 0.0, 1.0 };

  /*
   * Background colour 
   */
  glClearColor(0.0, 0.0, 0.0, 0.0);

  /*
   * Stuff you can't do without 
   */
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_CULL_FACE);

  /*
   * The lighting 
   */
  if (game->is_light)
    glEnable(GL_LIGHTING);
  glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, 1);
  if (game->is_smooth)
    glShadeModel(GL_SMOOTH);
  else
    glShadeModel(GL_FLAT);

  /*
   * The main light 
   */
  glEnable(GL_LIGHT0);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, light0_diffuse);
  glLightfv(GL_LIGHT0, GL_AMBIENT, light0_ambient);

  /*
   * Fog 
   */
  if (game->is_fog)
    glEnable(GL_FOG);
  /*
   * glFogi(GL_FOG_MODE, GL_LINEAR); 
   */
  glFogf(GL_FOG_END, 50.0);
  glFogf(GL_FOG_DENSITY, 0.0025);
  glFogfv(GL_FOG_COLOR, fog_colour);

  glMatrixMode(GL_MODELVIEW);
}

/*
 * Loads the config file 
 */
void init_config(Game * game)
{
  char rc_name[50] = "";

  /*
   * Load the rc file 
   */
  snprintf(rc_name, 50, "%s/.glchessrc", getenv("HOME"));
  open_rc(game, rc_name);
}

/*
 * Generate the piece lists and the textures 
 */
void init_data(Game * game)
{
  /*
   * Load pieces 
   */
  gen_model_lists();

  /*
   * Load the textures 
   */
  load_textures(game);
}

/*
 * You have to start somewhere 
 */
int main(int argc, char **argv)
{
  glChessWidget *glcwidget;
  Game *game = new_game();

  /*
   * Load the config file 
   */
  init_config(game);
  /*
   * Get the (gtk/glut) interface going 
   */
  if ((glcwidget = init_interface(argc, argv, game)) == NULL)
  {
    g_print("You really need OpenGL support. Try and find out"
	    "how you can do that!\n");
    exit(-1);
  }

  glcwidget->game = game;
  /*
   * Initialize openGL settings 
   */
  init_gl(game);
  /*
   * Load the default settings and models 
   */
  init_data(game);
  /*
   * Turn on the splash screen by default 
   */
  init_splash(glcwidget);

  gtk_main();

  return 0;
}
