/*
 * glChess - A 3D chess interface
 *
 * Copyright (C) 2001  Robert Ancell <bob27@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * This file contains the global structs, typedefs, and variables 
 */

#include <GL/gl.h>
#include <gtk/gtk.h>

#if 0
#define NVIDIAS_DRIVERS_ARE_CRAP TRUE
#endif

#define GLCHESS_VERSION_STRING "0.3.0"

enum { PLAYER = 0, KING, QUEEN, BISHOP, KNIGHT, ROOK, PAWN };
#define WHITE 0+
#define BLACK 10+

/* Engines */
#define CRAFTY		1
#define GNUCHESS	2
#define HUMAN		3

typedef struct _Player {
  char *name;
  unsigned int pieces;
  int score;
  float time;

  /*
   * The colours 
   */
  GLfloat *piece_colour;
  GLfloat *selected_colour;
  GLfloat *board_colour;

  /*
   * The textures 
   */
  char *texture_dir;
  char *piece_texture_file;
  GLuint piece_texture;
  char *selected_piece_texture_file;
  GLuint selected_piece_texture;
  char *board_texture_file;
  GLuint board_texture;
} Player;

enum _CameraMode {
  MODE_UNKNOWN = 0,
  MODE_FREE = 1,
  MODE_ROTATING = 2,
  MODE_ORTHO = 3,
  MODE_TRACKBALL = 4
};

typedef struct _Camera {
  enum _CameraMode mode;
  GLfloat free_pos[3], free_rot[3];
  GLfloat rotating_rad,
      rotating_height, rotating_rot, rotating_pitch, rotating_t;
  GLfloat track_rot[3], track_rad;

  int oldx, oldy, button;
} Camera;

enum _CECP_Mode {
  CECP_MODE_UNKNOWN = 0,
  CECP_MODE_EASY,
  CECP_MODE_HARD
} CECP_Mode;

/*
 * The options for Engine/CECP 
 */
typedef struct _CECP_Options {
  enum _CECP_Mode mode;
  unsigned int search_depth;
  int ai_player;
  int beep_signal;
} CECP_Options;

/*
 * All the data for a game 
 */
typedef struct _Game {
  Player *white_player;
  Player *black_player;
  Player *current_player;

  int board[8][8];
  int selected[2];

  struct _Camera *camera;

  int redisplay;
  float min_dt;

  int is_light, is_smooth, is_reflect, is_texture, is_fog, is_coord;

  int is_paused;
  int turn;
  float elapsed_time;

  char *texture_dir;
  GLfloat *number_colour, *letter_colour;
  GLuint number_textures[8], letter_textures[8];

  /*
   * Engine/CECP options 
   */
  struct _CECP_Options cecp;
} Game;

/*
 * The view window and its widgets 
 */
/*
 * FIXME: make this a new widget 
 */
typedef struct _glChessWidget {
  Game *game;

  GtkWidget *window, *vbox, *menu_handle_box, *menubar, *glarea;
  GtkItemFactory *item_factory;
  GtkWidget *status_handle_box, *statusbar;
  GtkWidget *player_label, *piece_pixmaps[16], *fps_label, *time_label;
  GdkPixmap *piece_gdk_pixmaps[16];
  GSList *radio_list;
  GtkWidget *view_radio[4], *fps_radio[9];
} glChessWidget;
