/*
 * glChess - A 3D chess interface
 *
 * Copyright (C) 2001  Robert  Ancell <bob27@users.sourceforge.net>
 *                     Michael Duelli <duelli@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Prepares the pipes, starts the engine */
void init_communication(char *);

/* Inits the CEC Protocol interface */
void init_cecp_interface(Game *);

/* Tells if the interface is up */
int cecp_interface_up(void);

/* Read a char without reading for ever */
int read_char(char *);

/* Clears the startup message of the engine */
void clear_startup_msg(void);

/* Closes the CEC Protocol interface */
void close_cecp_interface(void);

/* Engine might print some useless messages, get rid of these */
void clear_engine_msg(void);

/* Writes text to the engine */
void write_to_engine(char *);

/* Reads text from the engine */
char *read_from_engine(void);

/* This converts glchess' intern notation to coordinated notation */
char *convert_notation(int *, int *);

/* Checks whether move is in albegraic or SAN notation */
int check_notation_format(char *);

/* Parses the engine's move */
int parse_move_from_engine(Game *, char *, int *, int *);

/* Makes the speaker beep on illegal move */
void beep(void);

/* Just for simplifying debug output */
void debug_output(char *, ...);

/* This shows a dialog with a msg */
void engine_dialog(char *);

/* Extracts the promotion piece */
int get_promotion_piece(char *);
