/*
 * glChess - A 3D chess interface
 *
 * Copyright (C) 2001  Robert Ancell <bob27@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <math.h>

#include "global.h"
#include "animation.h"
#include "draw.h"

void animate(Game * game, double in_dt)
{
  static double dt = 0.0;
  int redraw = FALSE;
  Camera *camera = game->camera;

  game->current_player->time += in_dt;	/*
					 * Increase time for current
					 * player 
					 */

  dt += in_dt;
  if (dt < game->min_dt)
    return;

  /*
   * Orbit Camera 
   */
  if (camera->mode == MODE_ROTATING)
  {
    if (game->current_player == game->white_player)
    {
      if (camera->rotating_rot != 0.0)
      {
	camera->rotating_t += dt;
	camera->rotating_rot =
	    180 +
	    90 *
	    (sin
	     ((camera->rotating_t * M_PI / ROT_CAM_PERIOD) - M_PI_2) + 1);
	if (camera->rotating_t >= ROT_CAM_PERIOD)
	{
	  camera->rotating_t = 0.0;
	  camera->rotating_rot = 0.0;
	}

	redraw = TRUE;
      }
    } else
    {				/*
				 * black player 
				 */

      if (camera->rotating_rot != 180.0)
      {
	camera->rotating_t += dt;
	camera->rotating_rot =
	    90 *
	    (sin(camera->rotating_t * M_PI / ROT_CAM_PERIOD - M_PI_2) + 1);
	if (camera->rotating_t >= ROT_CAM_PERIOD)
	{
	  camera->rotating_t = 0.0;
	  camera->rotating_rot = 180.0;
	}

	redraw = TRUE;
      }
    }
  }

  dt = 0.0;

  /*
   * Update the view 
   */
  if (redraw)
    post_redisplay(game);
}
