#include <SDL/SDL_mixer.h>
#include "globals.h"

static int initd = 0;
static Mix_Music *current_music = (Mix_Music*)NULL;
static struct {
	int id;
	Mix_Chunk *chunk;
	int used;
	int loop;
} soundsamples[128];

void load_song(FILE *fp, signed int len)
{
	FILE *tmp;
	
	if(initd == 0) 
		initsound();
	if(initd != 1)
		return;
	
	if(Mix_PlayingMusic()) 
		Mix_FadeOutMusic(1500);

	if(current_music) {
		Mix_FreeMusic(current_music);
		current_music = NULL;
	}
	
	tmp = fopen("/tmp/jnb.tmpmusic.mod", "wb");
	for(; len>0; len--) 
		fputc(fgetc(fp), tmp);
	fflush(tmp);
	fclose(tmp);
	fclose(fp);
		
	current_music = Mix_LoadMUS("/tmp/jnb.tmpmusic.mod");
	if(current_music == NULL) {
		fprintf(stderr, "Couldn't load music: %s\n", SDL_GetError());
		initd = 2;
		return;
	}
	
	/* .. */
}

void play_song()
{
	if(initd != 1)
		return;
		
	Mix_FadeInMusic(current_music, -1, 2000);
}

void songquit()
{
//	int i;
	
	Mix_FadeOutMusic(1500);
	SDL_Delay(1500);
	Mix_HaltMusic();
	if(current_music)
		Mix_FreeMusic(current_music);
	current_music = NULL;

/*	for(i = 0; i < 128; i++) {
		if(soundsamples[i].used && soundsamples[i].chunk)
			Mix_FreeChunk(soundsamples[i].chunk);
	}*/
	
	if(initd == 1)
		Mix_CloseAudio();
		
	initd = 0;
}

void update_song()
{
	return;
}

void initsound()
{
	int audio_rate = 22050;
	Uint16 audio_format = AUDIO_U16;
	int audio_channels = 2;
	int audio_buffers = 4096;
	
	if(initd == 2)
		return;
		
	if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers) < 0) {
		fprintf(stderr, "Couldn't open audio: %s\n", SDL_GetError());
		initd = 2;
		return;
	}
	
	Mix_QuerySpec(&audio_rate, &audio_format, &audio_channels);
	printf("Opened audio at %dHz %dbit %s, %d bytes audio buffer\n", 
		audio_rate, (audio_format&0xFF),
		(audio_channels > 1) ? "stereo" : "mono",
		audio_buffers);
	
	Mix_SetMusicCMD(getenv("MUSIC_CMD"));
	
	memset(soundsamples, 0, sizeof(soundsamples));
	initd = 1;
}



int load_sample(FILE *fp, int length, int id, int loop)
{
	int i;
	char *buffer;
	
	for(i = 0; (i < 128) && soundsamples[i].used; i++)
		;
	if(i == 128) 
		return -1;
	
	if(initd == 0)
		initsound();
	if(initd == 2)
		return -1;
	
	buffer = (char *)malloc(sizeof(char) * (length + 12 + 4 + 4));
	memset(buffer, 0, sizeof(char) * (length + 12 + 4 + 4));
	fread(&buffer[12+4+4], length, 1, fp);
	*((int *)&buffer[12+4]) = length;
	strncpy(&buffer[12], "data", 4);
	
	soundsamples[i].chunk = Mix_QuickLoad_WAV(buffer);
	soundsamples[i].chunk->allocated = 1;
	soundsamples[i].used = 1;
	soundsamples[i].id = id;
	soundsamples[i].loop = (loop) ? -1 : 0;
	
	return 0;	
}

void play_sample(int smp, int channel)
{
	int i;
	
	for(i = 0; i < 128; i++) {
		if(soundsamples[i].id == smp)
			break;
	}
	if(i == 128)
		return;
	else if(!soundsamples[i].used)
		return;
	else if(!soundsamples[i].chunk)
		return;

/* broken sound */
return;

	Mix_PlayChannel(channel, soundsamples[i].chunk, soundsamples[i].loop);
}

void free_sample(int smp)
{
	if(smp >= 128 || !soundsamples[smp].used)
		return;
	
	Mix_FreeChunk(soundsamples[smp].chunk);
	soundsamples[smp].chunk = (Mix_Chunk *) NULL;
	soundsamples[smp].used = 0;
}
