#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include "globals.h"


struct {
	char enabled;
} keyb_handler_info;

volatile char keyb[256];
char last_keys[50];

unsigned char scancode2ascii[256] = {
	0, 0, 49, 50, 51, 52, 53, 54, 55, 56,		/* 0-9 */
	57, 48, 45, 0, 0, 0, 113, 119, 101, 114,	/* 10-19 */
	116, 121, 117, 105, 111, 112, 0, 0, 0, 0,	/* 20-29 */
	97, 115, 100, 102, 103, 104, 106, 107, 108, 0,	/* 30-39 */
	0, 0, 0, 0, 122, 120, 99, 118, 98, 110,		/* 40-49 */
	109, 44, 46, 47, 0, 0, 0, 32, 0, 0,		/* 50-59 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0
};

#ifndef LINUX
_go32_dpmi_seginfo old_keyb_handler_seginfo, new_keyb_handler_seginfo;
#endif

void keyb_handler()
{
	unsigned char key;
	static char extended;
	int c1;

	key = 0;
#ifndef LINUX
	key = inportb(0x60);
#endif

	if (key == 0xe0)
		extended = 1;
	else {
		if (extended == 0) {
			if ((key & 0x80) == 0) {
				keyb[key & 0x7f] = 1;
				for (c1 = 48; c1 > 0; c1--)
					last_keys[c1] = last_keys[c1 - 1];
				last_keys[0] = scancode2ascii[key & 0x7f];
			} else
				keyb[key & 0x7f] = 0;
		} else {
			if ((key & 0x80) == 0) {
				keyb[(key & 0x7f) + 0x80] = 1;
				for (c1 = 48; c1 > 0; c1--)
					last_keys[c1] = last_keys[c1 - 1];
				last_keys[0] =
				    scancode2ascii[(key & 0x7f) + 0x80];
			} else
				keyb[(key & 0x7f) + 0x80] = 0;
		}
		if (extended == 1)
			extended = 0;
	}
#ifndef LINUX
	outportb(0x20, 0x20);
#endif

}

void keyb_handler_end()
{
}


char hook_keyb_handler(void)
{
#ifndef LINUX
	if (keyb_handler_info.enabled == 0) {
		_go32_dpmi_lock_data((char *) &keyb, sizeof(keyb));
		_go32_dpmi_lock_code(keyb_handler,
				     (unsigned long) keyb_handler_end -
				     (unsigned long) keyb_handler);
		_go32_dpmi_get_protected_mode_interrupt_vector(9,
							       &old_keyb_handler_seginfo);
		new_keyb_handler_seginfo.pm_offset = (int) keyb_handler;
		if (_go32_dpmi_allocate_iret_wrapper
		    (&new_keyb_handler_seginfo) != 0)
			return 1;
		if (_go32_dpmi_set_protected_mode_interrupt_vector
		    (9, &new_keyb_handler_seginfo) != 0) {
			_go32_dpmi_free_iret_wrapper
			    (&new_keyb_handler_seginfo);
			return 1;
		}
		keyb_handler_info.enabled = 1;
		memset(last_keys, 0, sizeof(last_keys));
	}
#endif
	SDL_EnableUNICODE(1);
	memset((void *)last_keys, 0, sizeof(last_keys));
	return 0;

}


void remove_keyb_handler(void)
{
#ifndef LINUX
	if (keyb_handler_info.enabled == 1) {
		_go32_dpmi_set_protected_mode_interrupt_vector(9,
							       &old_keyb_handler_seginfo);
		_go32_dpmi_free_iret_wrapper(&new_keyb_handler_seginfo);
		keyb_handler_info.enabled = 0;
	}
#endif
}


char key_pressed(unsigned char key)
{
	return keyb[key];
}

int addkey(unsigned int key)
{
	int c1;

	if(!(key & 0x8000)) {
		keyb[key & 0x7fff] = 1;
		for (c1 = 48; c1 > 0; c1--) 
			last_keys[c1] = last_keys[c1 - 1];
		last_keys[0] = key & 0x7fff;
	} else
		keyb[key & 0x7fff] = 0;
	return 0;
}

char intr_sysupdate()
{
	SDL_Event e;
	int i = 0;
	static Uint32 now,then=0;

	while(SDL_PollEvent(&e)) {
		switch(e.type) {
		case SDL_MOUSEBUTTONDOWN:
			break;
		case SDL_KEYDOWN:
		case SDL_KEYUP:
			switch(e.key.keysym.sym) {
			case SDLK_F12:
				if(e.type == SDL_KEYDOWN) {
					SDL_Quit();
					exit(1);
				}
				break;
			case SDLK_F10:
				if(e.type == SDL_KEYDOWN) {
					fs_toggle();
				}
				break;
			case SDLK_ESCAPE:
				if(e.type == SDL_KEYUP)
					addkey(1 | 0x8000);
				else
					addkey(1 & 0x7f);
				break;
			default:
				e.key.keysym.sym &= 0x7f;
				if(e.type == SDL_KEYUP)
					e.key.keysym.sym |= 0x8000;
				addkey(e.key.keysym.sym);
				
				break;
			}
			break;
		default:
			break;
		}
		i++;
	}
	//SDL_Delay(4);
	now=SDL_GetTicks();
	if(!then)
	    SDL_Delay(1);
	else {
	    then=(1000/60)-(now-then);
	    if (then>0 && then<1000)
	       SDL_Delay(then);
	}
	then=now;
	
	return i;
}
