/* ANSI-C code produced by gperf version 2.7.1 (19981006 egcs) */
/* Command-line: gperf -t -L ANSI-C -G -N in_channel_set -W channel_set -k 1,3,$ ./debughash.gperf  */
/*				 -*- buffer-read-only: t -*- vi: set ro:
** 
** DO NOT EDIT THIS FILE   (src/debughash.gperf)
** 
** It has been AutoGen-ed  Monday May  7, 2001 at 08:47:05 AM CEST
** From the definitions    src/debugchn.def
** and the template file   debugchn
*/

/*
** Heroes is free software.
** 
** You may redistribute it and/or modify it under the terms of the
** GNU General Public License, as published by the Free Software
** Foundation; either version 2, or (at your option) any later version.
** 
** Heroes is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with Heroes.  See the file "COPYING".  If not,
** write to:  The Free Software Foundation, Inc.,
**            59 Temple Place - Suite 330,
**            Boston,  MA  02111-1307, USA.
*/

#include "system.h"
#include "debughash.h"
#include "errors.h"
#include "fstrcmp.h"

/* prototype in_channel_set as static */
static struct debug_channel_s *
in_channel_set (register const char *str, register unsigned int len);
struct debug_channel_s {
  const char *name;
  const char *doc;
  enum debug_lvl number;
};

#define TOTAL_KEYWORDS 14
#define MIN_WORD_LENGTH 3
#define MAX_WORD_LENGTH 12
#define MIN_HASH_VALUE 3
#define MAX_HASH_VALUE 25
/* maximum key range = 23, duplicates = 0 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static unsigned char asso_values[] =
    {
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26,  0,  5,  5,
      15,  0,  0, 26, 26, 26,  5,  0,  0,  0,
       0,  5, 26, 26,  0,  0, 10,  0,  0, 26,
      26,  0, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26
    };
  return len + asso_values[(unsigned char)str[2]] + asso_values[(unsigned char)str[0]] + asso_values[(unsigned char)str[len - 1]];
}

static struct debug_channel_s channel_set[] =
  {
    {"",0,0}, {"",0,0}, {"",0,0},
    {"all",              N_("all messages"),                          -1},
    {"file",             N_("files and directories handling"),        D_FILE},
    {"level",            N_("levels handling"),                       D_LEVEL},
    {"system",           N_("system related messages"),               D_SYSTEM},
    {"",0,0},
    {"resource",         N_("filename resources handling"),           D_RESOURCE},
    {"misc",             N_("miscellaneous events"),                  D_MISC},
    {"bonus",            N_("bonus"),                                 D_BONUS},
    {"sound_track",      N_("sound track events"),                    D_SOUND_TRACK},
    {"section",          N_("different parts of the game"),           D_SECTION},
    {"joystick",         N_("joystick initialization"),               D_JOYSTICK},
    {"",0,0},
    {"timer",            N_("timer handling"),                        D_TIMER},
    {"",0,0}, {"",0,0}, {"",0,0}, {"",0,0},
    {"fader",            N_("palette fade events"),                   D_FADER},
    {"",0,0},
    {"sound_effect",     N_("sound effects events"),                  D_SOUND_EFFECT},
    {"",0,0}, {"",0,0},
    {"video",            N_("communication with the display driver"), D_VIDEO}
  };

#ifdef __GNUC__
__inline
#endif
struct debug_channel_s *
in_channel_set (register const char *str, register unsigned int len)
{
  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = channel_set[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &channel_set[key];
        }
    }
  return 0;
}
static const struct debug_channel_s *
get_channel_approx (const char *name)
{
  int i;
  const struct debug_channel_s *res = 0;
  double best_weight = 0.7;

  for (i = MIN_HASH_VALUE; i <= MAX_HASH_VALUE; ++i) {
    if (channel_set[i].name[0]) {
      double weight = fstrcmp (name, channel_set[i].name);
      if (weight > best_weight) {
        best_weight = weight;
        res = &(channel_set[i]);
      }
    }
  }
  return res;
}

enum debug_lvl
get_channel_number (const char *name)
{
  const struct debug_channel_s *res = in_channel_set (name, strlen (name));
  if (!res) {
    /* try to find a channel which name is close to the given name */
    res = get_channel_approx (name);
    if (res)
      wmsg (_("%s: no such channel, assuming you meant '%s'."),
            name, res->name);
    else
      emsg (_("%s: no such channel (--list=debug will list "
              "all known channels)"), name);
  }
  return res->number;
}

void
print_debug_channels (void)
{
  int i;
  for (i = MIN_HASH_VALUE; i <= MAX_HASH_VALUE; ++i) {
    if (channel_set[i].name[0]) {
      printf ("%-16s %s\n", channel_set[i].name, _(channel_set[i].doc));
    }
  }
}

