/*-------------------------------------------------------------------.
| Copyright 2001  Alexandre Duret-Lutz <duret_g@epita.fr>            |
|                                                                    |
| This program is free software; you can redistribute it and/or      |
| modify it under the terms of the GNU General Public License as     |
| published by the Free Software Foundation; either version 2 of the |
| License, or (at your option) any later version.                    |
|                                                                    |
| This program is distributed in the hope that it will be useful,    |
| but WITHOUT ANY WARRANTY; without even the implied warranty of     |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  |
| General Public License for more details.                           |
|                                                                    |
| You should have received a copy of the GNU General Public License  |
| along with this program; if not, write to the Free Software        |
| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA           |
| 02111-1307 USA                                                     |
`-------------------------------------------------------------------*/

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <unistd.h>
#include <stdio.h>

#if HAVE_FCNTL_H
# include <fcntl.h>
#endif

#include "fopenlock.h"


/*
 * Open and lock a file (block if the file is already locked).
 */
FILE *
fopenlock (const char *path, const char *mode)
{
  FILE *f;
  f = fopen (path, mode);
  if (f == 0)
    return 0;

  /* FIXME: implement other kind of locking for system
     which doesn't have fcntl locking.  */
#ifdef F_SETLKW
  {
    struct flock lock;
    lock.l_type = (*mode == 'r' && mode[1] != '+' ? F_RDLCK : F_WRLCK);
    lock.l_whence = SEEK_SET;
    lock.l_start = 0;
    lock.l_len = 0;		/* Lock the whole file.  */
    fcntl (fileno (f), F_SETLKW, &lock);
  }
#endif
  return f;
}
