#! /bin/sh

# Utility taken from the Allegro games programming library.
# Convert files from CR/LF to LF format.

echo "Converting files to Unix format..."

find . -type f "(" \
   -name "*.c" -o -name "*.h" -o \
   -name "*.txt" -o \
   -name "*.xml" -o \
   -name "*.tex.in" -o -name "*.html.in" -o -name "*.man.in" -o \
   -name "*.py" -o \
   -name "makefile.in" \
   ")" \
   -exec sh -c "echo {};
		mv {} _tmpfile;
		tr -d \\\r < _tmpfile > {};
		touch -r _tmpfile {}; 
		rm _tmpfile" \;

# Now we set files mode to sensible values, since using shared samba drives,
# which I do to compile under Microsoft platforms, can mess things up.

echo "Setting up file permissions..."

find . -type f | xargs chmod 644
find . -name "*.sh" -o \
   -name "liquidwar" -o \
   -name "liquidwar-server" -o \
   -name "config.status" -o \
   -name "configure" | xargs chmod 755
