#include "arenaball.h"

// This file reads in the script information
// will document later
void scriptreader (GAME * game)
{

	SDL_Color * colors;
	SDL_Surface * image;
	SDL_Rect src;
	int ncolors;
	int i;
	int ctr;
	
	FILE * scriptfile;
	char scriptline[200];
	char scriptline2[200];
	char newline[3];
	char item[40];
	int itemnum;
	int playerctr;
	int defaultx[6];
	int defaulty[6];
	int offensex1[6];
	int offensey1[6];
	int offensex2[6];
	int offensey2[6];
	int defensex[6];
	int defensey[6];
	
	AREA ozone[6];
		
	playerctr = 0;
	printf("Reading arenaballscript file...\n");
	scriptfile = fopen("arenaballscript", "r");
	
	while(!feof(scriptfile))
	{
		fgets(scriptline, 200, scriptfile);
		if(scriptline[0] != '#')
		{
			if(strcmp(scriptline, "PLAYER\n") == 0)
			{
				printf("Accepting values for player %d\n", playerctr);
				fscanf(scriptfile, "%s", item);
				//printf("%s\n", item);
				loadanimation(&game->player[playerctr].stander, item);
				fscanf(scriptfile, "%s", item);
				//printf("%s\n", item);
				loadanimation(&game->player[playerctr].runner, item);
				fscanf(scriptfile, "%s", item);
				//printf("%s\n", item);
				loadanimation(&game->player[playerctr].thrower, item);
				fscanf(scriptfile, "%s", item);
				//printf("%s\n", item);
				loadanimation(&game->player[playerctr].faller, item);
				fscanf(scriptfile, "%d", &itemnum);
				game->player[playerctr].number = itemnum;
				//printf("%d\n", game->player[playerctr].number);
				fscanf(scriptfile, "%s", item);
				if(strcmp(item, "HOME") == 0)
					game->player[playerctr].team = BLUE;
				else
					game->player[playerctr].team = RED;
				//printf("%d\n", game->player[playerctr].team);
				fscanf(scriptfile, "%d", &itemnum);
				game->player[playerctr].pwr = itemnum;		
				//printf("%d\n", game->player[playerctr].pwr);				
				fscanf(scriptfile, "%d", &itemnum);
				game->player[playerctr].spd = itemnum;		
				//printf("%d\n", game->player[playerctr].spd);
				fscanf(scriptfile, "%d", &itemnum);
				game->player[playerctr].end = itemnum;		
				//printf("%d\n", game->player[playerctr].end);
				fscanf(scriptfile, "%d", &itemnum);
				game->player[playerctr].agg = itemnum;		
				//printf("%d\n", game->player[playerctr].agg);
				fscanf(scriptfile, "%s", item);
				if(strcmp(item, "GK") == 0)
					game->player[playerctr].pos = GOALKEEPER;
				else if(strcmp(item, "LG") == 0)
					game->player[playerctr].pos = LEFTGUARD;
				else if(strcmp(item, "RG") == 0)
					game->player[playerctr].pos = RIGHTGUARD;
				else if(strcmp(item, "LS") == 0)
					game->player[playerctr].pos = LEFTSTRIKER;
				else if(strcmp(item, "RS") == 0)
					game->player[playerctr].pos = RIGHTSTRIKER;
				else
					game->player[playerctr].pos = POINTMAN;
					
				for(ctr=0; ctr<6; ctr++)
				{
					game->player[playerctr].movelist[ctr].x = 0;
					game->player[playerctr].movelist[ctr].y = 0;
					game->player[playerctr].movelist[ctr].action = NIL;
					game->player[playerctr].movelist[ctr].t = 0;
					game->player[playerctr].movelist[ctr].d = UNKNOWN;
				}
					
				if(game->player[playerctr].team == BLUE)
				{
					// printf("for home player\n");
					game->player[playerctr].defaultx = defaultx[game->player[playerctr].pos];
					game->player[playerctr].defaulty = defaulty[game->player[playerctr].pos];
					
					game->player[playerctr].movelist[0].x = offensex1[game->player[playerctr].pos];
					game->player[playerctr].movelist[0].y = offensey1[game->player[playerctr].pos];
					game->player[playerctr].movelist[0].action = RUN;
					game->player[playerctr].movelist[0].t = 0;
					game->player[playerctr].movelist[1].x = offensex2[game->player[playerctr].pos];
					game->player[playerctr].movelist[1].y = offensey2[game->player[playerctr].pos];
					game->player[playerctr].movelist[1].t = 0;
					
					game->player[playerctr].ozone.x = ozone[game->player[playerctr].pos].x;
					game->player[playerctr].ozone.y = ozone[game->player[playerctr].pos].y;
					game->player[playerctr].ozone.w = ozone[game->player[playerctr].pos].w;
					game->player[playerctr].ozone.h = ozone[game->player[playerctr].pos].h;
					
					if(game->player[playerctr].pos == GOALKEEPER)
					{
						game->player[playerctr].movelist[1].action = WAIT;
						game->player[playerctr].movelist[1].t = 20;
						game->player[playerctr].movelist[2].action = THROW;
					}
					else
						game->player[playerctr].movelist[1].action = RUN;
						
					game->player[playerctr].offctr = 0;
										
					game->player[playerctr].defensex = defensex[game->player[playerctr].pos];
					game->player[playerctr].defensey = defensey[game->player[playerctr].pos];
					game->player[playerctr].throwdirection[0] = DOWNLEFT;
					game->player[playerctr].throwdirection[1] = DOWN;
					game->player[playerctr].throwdirection[2] = DOWNRIGHT;
				}
				else
				{
					// printf("for away player\n");
					game->player[playerctr].defaultx = 600 - defaultx[game->player[playerctr].pos];
					game->player[playerctr].defaulty = 800 - defaulty[game->player[playerctr].pos] + PY + PH;

					game->player[playerctr].movelist[0].x = 600 - offensex1[game->player[playerctr].pos];
					game->player[playerctr].movelist[0].y = 800 - offensey1[game->player[playerctr].pos];
					game->player[playerctr].movelist[0].t = 0;
					game->player[playerctr].movelist[0].action = RUN;
					game->player[playerctr].movelist[1].x = 600 - offensex2[game->player[playerctr].pos];
					game->player[playerctr].movelist[1].y = 800 - offensey2[game->player[playerctr].pos];
					game->player[playerctr].movelist[1].t = 0;
					
					game->player[playerctr].ozone.x = 600 - ozone[game->player[playerctr].pos].x;
					game->player[playerctr].ozone.y = 800 - ozone[game->player[playerctr].pos].y - ozone[game->player[playerctr].pos].h;
					game->player[playerctr].ozone.w = ozone[game->player[playerctr].pos].w;
					game->player[playerctr].ozone.h = ozone[game->player[playerctr].pos].h;
					
					printf("%d\n", game->player[playerctr].ozone.y);
					
					
					if(game->player[playerctr].pos == GOALKEEPER)
					{
						game->player[playerctr].movelist[1].action = WAIT;
						game->player[playerctr].movelist[1].t = 20;
						game->player[playerctr].movelist[2].action = THROW;
					}
					else
					{
						game->player[playerctr].movelist[1].action = RUN;
					}
						
					game->player[playerctr].offctr = 0;

					game->player[playerctr].defensex = 600 - defensex[game->player[playerctr].pos];
					game->player[playerctr].defensey = 800 - defensey[game->player[playerctr].pos];
					game->player[playerctr].throwdirection[0] = UPRIGHT;
					game->player[playerctr].throwdirection[1] = UP;
					game->player[playerctr].throwdirection[2] = UPLEFT;
				}
				
				game->player[playerctr].goals = 0;
				game->player[playerctr].assists = 0;
				game->player[playerctr].tackles = 0;
				game->player[playerctr].saves = 0;
				game->player[playerctr].steals = 0;
								
				fgets(newline, 3, scriptfile);
				
				playerctr++;
			}
			else if(strcmp(scriptline, "OZONEX\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					ozone[ctr].x = itemnum;
				}
			}
			else if(strcmp(scriptline, "OZONEY\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					ozone[ctr].y = itemnum;
				}
			}
			else if(strcmp(scriptline, "OZONEW\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					ozone[ctr].w = itemnum;
				}
			}
			else if(strcmp(scriptline, "OZONEH\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					ozone[ctr].h = itemnum;
				}
			}
			else if(strcmp(scriptline, "DEFAULTX\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					defaultx[ctr] = itemnum;
				}
			}
			else if(strcmp(scriptline, "DEFAULTY\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					defaulty[ctr] = itemnum;
				}
			}
			else if(strcmp(scriptline, "OFFENSEX1\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					offensex1[ctr] = itemnum;
				}
			}
			else if(strcmp(scriptline, "OFFENSEY1\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					offensey1[ctr] = itemnum;
				}
			}
			else if(strcmp(scriptline, "OFFENSEX2\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					offensex2[ctr] = itemnum;
				}
			}
			else if(strcmp(scriptline, "OFFENSEY2\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					offensey2[ctr] = itemnum;
				}
			}
			else if(strcmp(scriptline, "DEFENSEX\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					defensex[ctr] = itemnum;
				}
			}
			else if(strcmp(scriptline, "DEFENSEY\n") == 0)
			{
				for(ctr = 0; ctr < 6; ctr++)
				{
					fscanf(scriptfile, "%d", &itemnum);
					defensey[ctr] = itemnum;
				}
			}
			else if(strcmp(scriptline, "BACKGROUND\n") == 0)
			{
				fscanf(scriptfile, "%s", scriptline2);
				fgets(newline, 3, scriptfile);
				printf("Background graphic: %s\n", scriptline2);
				game->background = SDL_LoadBMP(scriptline2);
				if(game->background == NULL)
				{
					printf("Couldn't load sample.bmp: %s\n", SDL_GetError());
					exit(-1);
				}
				if (game->background->format->palette)
				{
					ncolors = game->background->format->palette->ncolors;
					colors = (SDL_Color *)malloc(ncolors*sizeof(SDL_Color));
					memcpy(colors, game->background->format->palette->colors, ncolors);
				}
				else
				{
					int r, g, b;
		
					ncolors = 256;
					colors = (SDL_Color *)malloc(ncolors*sizeof(SDL_Color));
		
					for (r=0; r<8; ++r)
					{
						for(g=0; g<8; ++g)
						{
							for (b=0; b<4; ++b)
							{
								i = ((r<<5)|(g<<2)|b);
								colors[i].r = r<<5;
								colors[i].g = g<<5;
								colors[i].b = b<<6;
							}
						}
					} // colors
				}	//colors
				
				game->background->flags |= SDL_HWSURFACE;
				
			} // background
			else if(strcmp(scriptline, "BALL\n") == 0)
			{
				fscanf(scriptfile, "%s", scriptline2);
				fgets(newline, 3, scriptfile);			
				printf("Ball graphic: %s\n", scriptline2);
				loadgraphic(&game->ball.image, scriptline2);
			}
			else if(strcmp(scriptline, "SCORED\n") == 0)
			{
				fscanf(scriptfile, "%s", scriptline2);
				fgets(newline, 3, scriptfile);			
				printf("Scored graphic: %s\n", scriptline2);
				loadgraphic(&game->scored, scriptline2);  			
			}
			else if(strcmp(scriptline, "DELAY\n") == 0)
			{
				fscanf(scriptfile, "%d", &itemnum);
				fgets(newline, 3, scriptfile);			
				game->delay = itemnum;
				printf("Setting delay at %d\n", itemnum);								
			}
		}
	}
	
	loadgraphic(&image, "marker.bmp");
	loadgraphic(&game->marker, "blank2.bmp");
	src.x = 1;
	src.y = 1;
	src.w = BITMAPWIDTH;
	src.h = 10;
	SDL_BlitSurface(image, &src, game->marker, NULL);
	
	game->teamdefence[0].deftype = ZONE;
	game->teamdefence[0].aggzone = 200;
	game->teamdefence[0].slackzone = 300;
	game->teamdefence[0].slackman = 500;
	game->teamdefence[1].deftype = ZONE;
	game->teamdefence[1].aggzone = 600;
	game->teamdefence[1].slackzone = 500;
	game->teamdefence[1].slackman = 300;
	
	game->NUMBEROFPLAYERS = playerctr;
	printf("Finished reading script\n\n");
	fclose(scriptfile);
}
