// arenaball initialization file

#include "arenaball.h"

// Initialize the game.
int init_game(GAME * game)
{

	printf("Initializing Game\n");

	// Initialize video
	if((SDL_Init(SDL_INIT_VIDEO) == -1))
	{
		printf("Could not initialize SDL %s.\n", SDL_GetError());
		exit(-1);
	}
	
	// Requisite function, don't know what it does
	atexit(SDL_Quit);
	
	game->screen = SDL_SetVideoMode(400, 347, 8, SDL_HWSURFACE|SDL_ANYFORMAT|SDL_DOUBLEBUF);
	if (game->screen == NULL)
	{
		printf("Couldn't set video mode: %s\n", SDL_GetError());
		exit(1);
	}
	
	game->tocrop = SDL_LoadBMP("background2.bmp");
	game->tocrop->flags |= SDL_HWSURFACE;

	game->scoreboard = SDL_LoadBMP("scoreboard.bmp");
	game->scoreboard->flags |= SDL_HWSURFACE;
	
	// read in settings from the script file
	scriptreader(game);

	// get the duration of the game
	game->timeleft = TIMEDURATION;

	// reset scores to zero
	game->score[0] = 0;
	game->score[1] = 0;
	
	// reset the ball
	resetball(&game->ball);
	// reset the players
	resetplayers(game);
			
	return(0);

}

// load animations, no longer a used function, will delete soon
int load_animations (GAME * game)
{
	return(0);
}

// load a singular animation. Used heavily in scriptstuff.c, might move over there.
// loads from a set sprite bitmap list into a UDT of type _ANIMATION, which basically
// contains eight frames
void loadanimation(ANIMATION * animation, char * filename)
{
	SDL_Surface *image;
	int bltx, blty;
	SDL_Rect src, dest;
	int ctr;
	
	// Load the bitmap file
	loadgraphic(&image, filename);
	// Load blanks into the ANIMATION
	for(ctr = 0; ctr<BITMAPCOUNT; ctr++)
		loadgraphic(&animation->frame[ctr], "blank.bmp");
	
	// Used for blitting, must be widths and height of the animation
	blty = BITMAPSPACING;
	bltx = BITMAPSPACING;
	
	// Go from 0 to 7 inclusive
	for(ctr=0; ctr<BITMAPCOUNT; ctr++)
	{
		src.x = bltx;
		src.y = blty;
		src.w = BITMAPWIDTH;
		src.h = BITMAPWIDTH;
		dest.x = 0;
		dest.y = 0;
		dest.w = BITMAPWIDTH;
		dest.h = BITMAPWIDTH;
		// Blit the image into the frame
		SDL_BlitSurface(image, &src, animation->frame[ctr], &dest);
		
		// Move to next position
		bltx += (BITMAPWIDTH + BITMAPSPACING);
	}
	SDL_FreeSurface(image);
}

// This just loads a basic graphic, assumes that we want white pixels to remain hidden
void loadgraphic(SDL_Surface ** image, char * filename)
{
	// load the image
	*image = SDL_LoadBMP(filename);
	if(image==NULL)
	{
		printf("Couldn't load sample.bmp: %s\n", SDL_GetError());
		exit(-1);
	}
	// Set white pixels to see-through
	SDL_SetColorKey(*image, SDL_SRCCOLORKEY, 0xffffff);
}
