// arenaball events source file

#include "arenaball.h"

// This file handles basic game events
// will document later
int FilterEvents(const SDL_Event *event)
{
	static int boycott = 1;
	
	if ((event->type == SDL_QUIT) && boycott)
	{
		printf("Quit event filtered out -- try again.\n");
		boycott = 0;
		return(0);
	}
	if (event->type == SDL_MOUSEMOTION)
	{
		//printf("Mouse moved to (%d,%d)\n", event->motion.x, event->motion.y);
		return(0);
	}
	return(1);
}

void handleevent(GAME * game, SDL_Event * event)
{

	int directiondx[8] = {-3, 0, 3, -5, 5, -3, 0, 3};
	int directiondy[8] = {-3, -5, -3, 0, 0, 3, 5, 3};

	switch(event->type)
	{
		case SDL_ACTIVEEVENT:
		{
			if (event->active.state & SDL_APPACTIVE)
			{
			if (event->active.gain)
				{
					printf("App activated\n");
				}
				else
				{
					printf("App iconified\n");
				}
			}
		}
		break;
		
		case SDL_QUIT:
		{
			printf("Quit requested, quitting.\n");
			exit(0);			
		}
		break;
		
		case SDL_KEYDOWN:
		{
			Uint8 *keys;
			keys = SDL_GetKeyState(NULL);
			if (keys[SDLK_LCTRL] == SDL_PRESSED)
			{
				throwball(game, 0);
				//printf("Throw key pressed\n");
			}
//			else
			{
				switch(event->key.keysym.sym)
				{
					case SDLK_ESCAPE:
					{
						showstats(game);
						printf("Bye bye...\n");
						exit(0);
					}
					case SDLK_KP7:
					{
						move(&game->player[0], UPLEFT);
						break;
					}
					case SDLK_KP8:
					{
						if(keys[SDLK_KP4] == SDL_PRESSED)
							move(&game->player[0], UPLEFT);					
						else if(keys[SDLK_KP6] == SDL_PRESSED)
							move(&game->player[0], UPRIGHT);
						else
							move(&game->player[0], UP);
						break;
					}
					case SDLK_KP9:
					{
						move(&game->player[0], UPRIGHT);
						break;
					}
					case SDLK_KP4:
					{
						if(keys[SDLK_KP8] == SDL_PRESSED)
							move(&game->player[0], UPLEFT);					
						else if(keys[SDLK_KP2] == SDL_PRESSED)
							move(&game->player[0], DOWNLEFT);
						else
							move(&game->player[0], LEFT);
						break;
					}
					case SDLK_KP6:
					{
						if(keys[SDLK_KP8] == SDL_PRESSED)
							move(&game->player[0], UPRIGHT);					
						else if(keys[SDLK_KP2] == SDL_PRESSED)
							move(&game->player[0], DOWNRIGHT);
						else
							move(&game->player[0], RIGHT);
						break;
					}
					case SDLK_KP1:
					{
						move(&game->player[0], DOWNLEFT);
					 	break;
					}
					case SDLK_KP2:
					{
						if(keys[SDLK_KP4] == SDL_PRESSED)
							move(&game->player[0], DOWNLEFT);					
						else if(keys[SDLK_KP6] == SDL_PRESSED)
							move(&game->player[0], DOWNRIGHT);
						else
							move(&game->player[0], DOWN);
						break;
					}
					case SDLK_KP3:
					{
						move(&game->player[0], DOWNRIGHT);
						break;
					}
					case SDLK_x:
					{
						SDL_SaveBMP(game->screen, "screenshot.bmp");			
						break;
					}
					case SDLK_s:
					{
						showstats(game);
						break;
					}
					case SDLK_z:
					{
						if(game->teamdefence[game->player[0].team].deftype == ZONE)
						{
							printf("Switching to Man defence\n");
							game->teamdefence[game->player[0].team].deftype = MAN;
						}
						else
						{
							printf("Switching to Zone defence\n");
							game->teamdefence[game->player[0].team].deftype = ZONE;
						}
					}
					default:
						break;
				}				
				if (keys[SDLK_SPACE] == SDL_PRESSED)
				{
					//printf("Jump key pressed\n");
				}
				if (keys[SDLK_LSHIFT] == SDL_PRESSED)
				{
					tackle(&game->player[0]);
				}
			}
		}
		break;
		
		case SDL_KEYUP:
		{
			Uint8 *keys;
			keys = SDL_GetKeyState(NULL);

			switch (event->key.keysym.sym)
			{
				case SDLK_KP7:
				{
					if (game->player[0].direction == UPLEFT)
					{
						game->player[0].dx = 0;
						game->player[0].dy = 0;
					}
					break;
				}
				case SDLK_KP8:
					game->player[0].dy = 0;
					if (keys[SDLK_KP4] == SDL_PRESSED)
					{
						game->player[0].dx = 0.2 * game->player[0].spd * directiondx[LEFT];
						game->player[0].direction = LEFT;
					}
					else if (keys[SDLK_KP6] == SDL_PRESSED)
					{
						game->player[0].dx = 0.2 * game->player[0].spd * directiondx[RIGHT];
						game->player[0].direction = RIGHT;
					}
					break;
				case SDLK_KP9:
				{
					if (game->player[0].direction == UPRIGHT)
					{
						game->player[0].dx = 0;
						game->player[0].dy = 0;
					}
					break;
				}
				case SDLK_KP4:
				{
					game->player[0].dx = 0;
					if (keys[SDLK_KP8] == SDL_PRESSED)
					{
						game->player[0].dy = 0.2 * game->player[0].spd * directiondy[UP];
						game->player[0].direction = UP;
					}
					else if (keys[SDLK_KP2] == SDL_PRESSED)
					{
						game->player[0].dy = 0.2 * game->player[0].spd * directiondy[DOWN];
						game->player[0].direction = DOWN;
					}
					break;
				}
				case SDLK_KP6:
				{
					game->player[0].dx = 0;
					if (keys[SDLK_KP8] == SDL_PRESSED)
					{
						game->player[0].dy = 0.2 * game->player[0].spd * directiondy[UP];
						game->player[0].direction = UP;
					}
					else if (keys[SDLK_KP2] == SDL_PRESSED)
					{
						game->player[0].dy = 0.2 * game->player[0].spd * directiondy[DOWN];
						game->player[0].direction = DOWN;
					}
					break;
				}
				case SDLK_KP1:
				{
					if (game->player[0].direction == DOWNLEFT)
					{
						game->player[0].dx = 0;
						game->player[0].dy = 0;
					}
					break;
				}
				case SDLK_KP2:
				{
					game->player[0].dy = 0;
					if (keys[SDLK_KP4] == SDL_PRESSED)
					{
						game->player[0].dx = 0.2 * game->player[0].spd * directiondx[LEFT];
						game->player[0].direction = LEFT;
					}
					else if (keys[SDLK_KP6] == SDL_PRESSED)
					{
						game->player[0].dx = 0.2 * game->player[0].spd * directiondx[RIGHT];
						game->player[0].direction = RIGHT;
					}
					break;
				}
				case SDLK_KP3:
				{
					if (game->player[0].direction == DOWNRIGHT)
					{
						game->player[0].dx = 0;
						game->player[0].dy = 0;
					}
					break;
				}
				default:
					break;
			}
		}
	}
}

void move(PLAYER * player, DIRECTION direction)
{
	int directiondx[8] = {-3, 0, 3, -5, 5, -3, 0, 3};
	int directiondy[8] = {-3, -5, -3, 0, 0, 3, 5, 3};
	
	if((player->state != FALLING) & (player->state != THROWING))
	{
		player->dx = player->spd * 0.2 * directiondx[direction];
		player->dy = player->spd * 0.2 * directiondy[direction];
		player->state = RUNNING;
		player->direction = direction;
	}
	else
		player->direction = direction;
}

void throwball(GAME * game, int playernumber)
{

	int directiondx[8] = {-3, 0, 3, -5, 5, -3, 0, 3};
	int directiondy[8] = {-3, -5, -3, 0, 0, 3, 5, 3};

	if (game->player[playernumber].hasball == TRUE)
	{
		game->ball.state = game->player[playernumber].pwr;
		game->ball.dx = game->player[playernumber].pwr * directiondx[game->player[playernumber].direction] * 0.4;
		game->ball.dy = game->player[playernumber].pwr * directiondy[game->player[playernumber].direction] * 0.4;
//		printf("Ball thrown, pwr: %d\n", game->player[playernumber].pwr);
		game->player[playernumber].dx = 0;
		game->player[playernumber].dy = 0;
		game->player[playernumber].statecount = 0;
		game->ball.possession = FREE;
		game->player[playernumber].state = THROWING;
	}

}

void tackle(PLAYER * player)
{
	player->state = TACKLING;
	if((player->state != TACKLING) & (player->state != RUNNING))
	{
		player->statecount = 0;
//		printf("Setting to zero!\n");
	}
}

void showstats(GAME * game)
{
	int ctr;
	
	printf("\nSCORE: HOME %d    AWAY %d\n", game->score[0], game->score[1]);
	printf("---------------------------\n");
	printf("HOME\n");
	printf("  #   G   A   S   T\n");
	for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
	{
		if((game->player[ctr].team == HOME) & (game->player[ctr].pos != GOALKEEPER))
				printf("%3d %3d %3d %3d %3d \n", game->player[ctr].number, game->player[ctr].goals, game->player[ctr].assists, game->player[ctr].steals, game->player[ctr].tackles);
	}
	for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
	{
		if((game->player[ctr].team == HOME) & (game->player[ctr].pos == GOALKEEPER))
			printf("GK(%d) T:%d  Sv:%d  GA:%d  SP:%.3f \n", game->player[ctr].number, game->player[ctr].tackles, game->player[ctr].saves, game->score[1], (game->score[1] + game->player[ctr].saves)?((float)game->player[ctr].saves / (float)(game->score[1] + game->player[ctr].saves)):(game->score[1] + game->player[ctr].saves));
	}
	printf("GK: ");
	printf("AWAY\n");
	printf("  #   G   A   S   T\n");
	for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
	{
		if((game->player[ctr].team == AWAY) & (game->player[ctr].pos != GOALKEEPER))
				printf("%3d %3d %3d %3d %3d \n", game->player[ctr].number, game->player[ctr].goals, game->player[ctr].assists, game->player[ctr].steals, game->player[ctr].tackles);
	}
	for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
	{
		if((game->player[ctr].team == AWAY) & (game->player[ctr].pos == GOALKEEPER))
			printf("GK(%d) T:%d  Sv:%d  GA:%d  SP:%.3f \n", game->player[ctr].number, game->player[ctr].tackles, game->player[ctr].saves, game->score[0], (game->score[0] + game->player[ctr].saves)?((float)game->player[ctr].saves / (float)(game->score[0] + game->player[ctr].saves)):(game->score[0] + game->player[ctr].saves));
	}

}
