#include "arenaball.h"

// This checks for all the physics involving the ball.
void checkballcollisions(GAME * game)
{
	
	// only do if ball is free...
	if(game->ball.possession == FREE)
	{
		// add the dx and dy
		game->ball.x += game->ball.dx;
		game->ball.y += game->ball.dy;

		// slow the ball down
		game->ball.state--;
		if(game->ball.state == 0)
		{
			if(game->ball.dx != 0)
				game->ball.dx *= 0.8;
			else
				game->ball.dx = 0;
			if (game->ball.dy != 0)
				game->ball.dy *= 0.8;
			else
				game->ball.dy = 0;
			game->ball.state = 15;		
		}

		// Have the ball bounce off the left wall
		if(game->ball.x + BX < MAPLEFTLIMIT)
		{
			game->ball.x = MAPLEFTLIMIT - BX;
			printf("Boing\n");
			game->ball.dx = abs(game->ball.dx);
		}
		// Have the ball bounce off the right wall 
		else if(game->ball.x + BX + BW > MAPRIGHTLIMIT)
		{
			game->ball.x = MAPRIGHTLIMIT - BX - BW;
			printf("Boing\n");
			game->ball.dx = (-1 * abs(game->ball.dx));
		}
		
		//Have the ball bounce off the lower wall
		if(game->ball.y + BY + BH > MAPLOWERLIMIT)
		{
			game->ball.y = MAPLOWERLIMIT - BY - BH;
			
			// Check for goal scored
			
			if((game->ball.x > 200) & (game->ball.x < (400 - BW - BX)))
			{
				goalscored(game, HOME);
			}
			else
				printf("Boing\n");
			game->ball.dy = (-1 * abs(game->ball.dy));
		}
		
		// Have the ball bounce off the upper wall
		else if(game->ball.y + BY < MAPUPPERLIMIT)
		{
			game->ball.y = MAPUPPERLIMIT - BY;
			// Check for goal scored
			
			if((game->ball.x > 200) & (game->ball.x < (400 - BW - BX)))
			{
				goalscored(game, AWAY);
			}
			else
				printf("Boing\n");
			game->ball.dy = abs(game->ball.dy);
		}
	}
}

// Check for player collisions
void checkplayercollisions(int playernumber, GAME * game)
{

	AREA aplayer, aball, oplayer;
	int direction;
	int ctr;
	boolean tacklecheck;
	
	// Basic direction constants
	int directiondx[8] = {-3, 0, 3, -5, 5, -3, 0, 3};
	int directiondy[8] = {-3, -5, -3, 0, 0, 3, 5, 3};

	// If the player isn't falling, have him shift positions.
	if(game->player[playernumber].state != FALLING)
	{
		game->player[playernumber].x += game->player[playernumber].dx;
		game->player[playernumber].y += game->player[playernumber].dy;
	}
	
	// check collisions with other players
	for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
	{
		// for all players but current one
		if(ctr != playernumber)
		{	
			oplayer.x = game->player[ctr].x + PX;
			oplayer.y = game->player[ctr].y + PY;
			oplayer.w = PW;
			oplayer.h = PH;
			aplayer.x = game->player[playernumber].x + PX;
			aplayer.y = game->player[playernumber].y + PY;
			aplayer.w = PW;
			aplayer.h = PH;

			// if the two players overlap and one is not falling
			if(IsOverlap(aplayer, oplayer) & (game->player[ctr].state != FALLING))
			{
			
				// check if main player is tackling
				if(game->player[playernumber].state == TACKLING)
				{
					if((game->player[ctr].state == STANDING) | (game->player[ctr].state == RUNNING) | (game->player[ctr].state == THROWING))
					{
						tacklecheck = ((game->player[playernumber].pwr + game->player[playernumber].agg + (rand()%30)) >= (game->player[ctr].pwr + game->player[ctr].agg + (rand()%30)));
						// if other player is standing or running or throwing
						if(tacklecheck == TRUE)
						{
							//printf("Active player tackling\n");
							// that player is now tackled
							game->player[ctr].state = FALLING;
							game->player[ctr].statecount = 0;
							game->player[ctr].dx = 0;	// maybe update so the player shifts? Might be fun
							game->player[ctr].dy = 0;
							// if the player has the ball
							if (game->player[ctr].hasball == TRUE)
							{
								// update tackles
								if(game->player[ctr].team != game->player[playernumber].team)
								{
									printf("Player #%d gets tackle on player #%d\n", game->player[playernumber].number, game->player[ctr].number);
									game->player[playernumber].tackles++;
								}
								
								game->player[ctr].hasball = FALSE;
								direction = rand()%8;
								// have the ball bounce out in same direction that player who is tackling is headed
								// make random? Might be fun
								game->ball.dx = directiondx[direction];
								game->ball.dy = directiondy[direction];
								game->ball.possession = FREE;
							}
						}
						else
						{
							game->player[playernumber].state = FALLING;
							game->player[playernumber].statecount = 0;
							game->player[playernumber].dx = 0;
							game->player[playernumber].dy = 0;
							if (game->player[ctr].hasball == TRUE)
							{
								// update tackles
								if(game->player[playernumber].team != game->player[ctr].team)
								{
									printf("Player #%d gets tackle on player #%d\n", game->player[ctr].number, game->player[playernumber].number);
									game->player[ctr].tackles++;
								}
								
								game->player[playernumber].hasball = FALSE;
								direction = rand()%8;
								game->ball.dx = directiondx[direction];
								game->ball.dy = directiondy[direction];
								game->ball.possession = FREE;
							}
						}
						//printf("escaped?\n");
					}
				}
				// Perform checks as above, this time to see if the other player is trying to tackle the active player
				else if(game->player[ctr].state == TACKLING)
				{
					if((game->player[playernumber].state == STANDING) | (game->player[playernumber].state == RUNNING) | (game->player[playernumber].state == THROWING))
					{
						tacklecheck = ((game->player[playernumber].pwr + game->player[playernumber].agg + (rand()%30)) <= (game->player[ctr].pwr + game->player[ctr].agg + (rand()%30)));
						// if other player is standing or running or throwing
						if(tacklecheck == TRUE)
						{
							//srand(time(NULL));
							//printf("Active player tackled\n");
							game->player[playernumber].state = FALLING;
							game->player[playernumber].statecount = 0;
							game->player[playernumber].dx = 0;
							game->player[playernumber].dy = 0;
							if (game->player[playernumber].hasball == TRUE)
							{
								// update tackles
								if(game->player[ctr].team != game->player[playernumber].team)
								{
									printf("Player #%d gets tackle on player #%d\n", game->player[ctr].number, game->player[playernumber].number);
									game->player[ctr].tackles++;
								}
								
								game->player[playernumber].hasball = FALSE;
								direction = rand()%8;
								
								game->ball.dx = directiondx[direction];
								game->ball.dy = directiondy[direction];
								game->ball.possession = FREE;
							}
						}
						else
						{
							game->player[ctr].state = FALLING;
							game->player[ctr].statecount = 0;
							game->player[ctr].dx = 0;
							game->player[ctr].dy = 0;
							if (game->player[ctr].hasball == TRUE)
							{
								// update tackles
								if(game->player[ctr].team != game->player[playernumber].team)
								{
									printf("Player #%d gets tackle on player #%d\n", game->player[playernumber].number, game->player[ctr].number);
									game->player[playernumber].tackles++;
								}
								
								game->player[ctr].hasball = FALSE;
								direction = rand()%8;
								
								game->ball.dx = directiondx[direction];
								game->ball.dy = directiondy[direction];
								game->ball.possession = FREE;
							}
						}
						//printf("escaped?\n");
					}
				}
				
				// At this stage, if it's just a bump, handle the bump
				if(game->player[playernumber].state != FALLING)
				{
					handleplayeroverlap(&game->player[playernumber], &game->player[ctr]);
					// Randomly determine if the player will succeed in tackle, not yet implemented
					if(playernumber != 0)
						if((game->player[playernumber].team != game->player[ctr].team) | ((game->timeleft % 5) == 0))
							game->player[playernumber].state = TACKLING;
				}
			}
		}
	}
	
	// boundary checking, horizontal range
	if(game->player[playernumber].x + PX + PW > MAPRIGHTLIMIT)
		game->player[playernumber].x = MAPRIGHTLIMIT - PX - PW;
	else if(game->player[playernumber].x + PX < MAPLEFTLIMIT)
		game->player[playernumber].x = MAPLEFTLIMIT - PX;

	// check boundaries for goalkeepers, don't let them creep out too far
	if(game->player[playernumber].pos == GOALKEEPER)
	{
		if(game->player[playernumber].team == BLUE)
		{
			if(game->player[playernumber].y + PY + PH > 120)
				game->player[playernumber].y = 120 - PY - PH;
		}		
		else
		{
			if(game->player[playernumber].y + PY < 680)
				game->player[playernumber].y = 680 - PY;
		}		
	}
			
	// boundary checking, vertical range
	if(game->player[playernumber].y + PH + PY > MAPLOWERLIMIT)
		game->player[playernumber].y = MAPLOWERLIMIT - PH - PY;
	else if(game->player[playernumber].y + PY < MAPUPPERLIMIT)
		game->player[playernumber].y = MAPUPPERLIMIT - PY;
	
	// check for ball overlap
	if(game->player[playernumber].hasball == TRUE)
	{
		// update the ball position for where the player is headed
		game->ball.x = game->player[playernumber].x + PLAYERCENTER - BALLCENTER - BALLRADIUS;
		game->ball.y = game->player[playernumber].y + PLAYERCENTER - BALLCENTER;
	}
	else if (game->ball.possession == FREE)
	{
		// Check if player overlaps with the ball
		//printf("Checking overlap!\n");
		aplayer.x = game->player[playernumber].x + PX;
		aplayer.y = game->player[playernumber].y + PY;
		aplayer.w = PW;
		aplayer.h = PH;
		
		// this might be updated to a straight PX and PY instead of CX and CY		
		aball.x = game->ball.x + BX;
		aball.y = game->ball.y + BY;
		aball.w = BW;
		aball.h = BH;

		// Check for an overlap where the player is not throwing or falling
		if((IsOverlap(aplayer, aball)) & (game->player[playernumber].state != THROWING) & (game->player[playernumber].state != FALLING))
		{
			// This might be a stat! If the previous owner of the ball was the other team, this counts
			// as a steal. Also, ball ownership must be updated
			game->player[playernumber].hasball = TRUE;
			
			if(game->player[playernumber].pos == GOALKEEPER)
			{
				for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
					if(game->player[ctr].team == game->player[playernumber].team)
						generatemovelist(&game->player[ctr], &game->ball);
			}

			// check if it's a steal
			if((game->ball.lastteam != game->player[playernumber].team) & (game->ball.lastteam != 2))
			{
				if(game->player[playernumber].pos == GOALKEEPER)
				{
					// check if ball is caught within gray zone first...?
					printf("Player %d makes a save\n", game->player[playernumber].number);
					game->player[playernumber].saves++;
				}
				else
				{
					printf("Player %d steals the ball\n", game->player[playernumber].number);
					game->player[playernumber].steals++;
				}
				game->ball.previousplayer = 0;
				game->ball.previousteam = 2;
				
				//update offcounters to 0
				
				for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
					if(game->player[ctr].team == game->player[playernumber].team)
						generatemovelist(&game->player[ctr], &game->ball);
			}
			else
			{
				game->ball.previousplayer = game->ball.lastplayer;
				game->ball.previousteam = game->ball.lastteam;			
			}
			game->ball.lastplayer = game->player[playernumber].number;
			game->ball.lastteam = game->player[playernumber].team;
			
			//printf("In here!\n");
			game->player[playernumber].hasball = TRUE;
			game->ball.possession = game->player[playernumber].team;
			game->ball.x = game->player[playernumber].x + PLAYERCENTER - BALLCENTER - BALLRADIUS;
			game->ball.y = game->player[playernumber].y + PLAYERCENTER - BALLCENTER;
			game->ball.playerindex = playernumber;
		}
	}
}

// This routine handles the overlap. Lets players continue to run if they go into
// another player diagonally
void handleplayeroverlap(PLAYER * player1, PLAYER * player2)
{
	int xdif, ydif;
	
	// Calculate the x and y differential between the players
	xdif = abs(player1->x - player2->x);
	ydif = abs(player1->y - player2->y);
	
	// Each of these handles how players bounce off each other
	// Basically, if a player is closer to passing another player on the bottom than 
	// he is on the side, have that player continue along the bottom but have his
	// path up the side obstructed
	if(player1->x < player2->x)
	{
	 	if(player1->y < player2->y)
	 	{
	 		if(xdif > ydif)
	 		{
	 			player1->x = player2->x - PW;
	 			//printf("Bumping to the left\n");
	 		}
	 		else
	 		{
	 		 	player1->y = player2->y - PH;
	 		 	//printf("Bumping up top\n");
	 		}
	 	}
	 	else
	 	{
	 		if(xdif > ydif)
	 		{
	 			player1->x = player2->x - PW;
	 			//printf("Bumping to the left\n");
	 		}
	 		else
	 		{
	 			player1->y = player2->y + PH;
	 			//printf("Bumping down below\n");
	 		}
	 	}	
	}
	else
	{
	 	if(player1->y < player2->y)
	 	{
	 		if(xdif > ydif)
	 		{
	 			player1->x = player2->x + PW;
	 			//printf("Bumping to the right\n");
	 		}
	 		else
	 		{
	 		 	player1->y = player2->y - PH;
	 			//printf("Bumping up top\n");
	 		}
	 	}
	 	else
	 	{
	 		if(xdif > ydif)
	 		{
	 			player1->x = player2->x + PW;
	 			//printf("Bumping to the right\n");
	 		}
	 		else
	 		{
	 			player1->y = player2->y + PH;
	 			//printf("Bumping down below\n");
	 		}
	 	}	
	}
}

// Checks if two areas (x,y,w,h) overlap
boolean IsOverlap(AREA a, AREA b)
{
	boolean istrue;

	istrue = FALSE;
	
	// Basically, the top left vertex of area a must be within a certain
	// range in order to qualify as an overlap. That area is defined as
	// both widths of the areas by both heights of the areas, offset from
	// the second area's top left vertex by the width and height of the 
	// first area. Heh, did you get that?
	if((b.x > (a.x - b.w)) & (b.x < (a.x + a.w)))
		if((b.y > (a.y - b.h)) & (b.y < (a.y + a.h)))
			istrue = TRUE;
	
	return(istrue);
}
