// arenaball.header file
// header file for arenaball game

// includes a bunch of constants that will probably get eliminated in favour of
// script settings

#ifndef __ARENABALL__
#define __ARENABALL__

#include "SDL/SDL.h"
#include "SDL/SDL_timer.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#define BITMAPWIDTH 37
#define BITMAPSPACING 1
#define BITMAPCOUNT 8

#define TIMEDURATION 3000

#define PLAYERCENTER 19
#define PLAYERRANGE 10
#define PLAYERBOTTOMEDGE 36
#define PLAYERTOPEDGE 1
#define PLAYERLEFTEDGE 7
#define PLAYERRIGHTEDGE 30

#define CATCHZONEX 6
#define CATCHZONEY 6
#define CATCHZONEWH 15
#define BALLX 1
#define BALLY 1
#define BALLDIAMETER 13

#define MAPUPPERLIMIT 25
#define MAPLOWERLIMIT 775
#define MAPLEFTLIMIT 25
#define MAPRIGHTLIMIT 575

#define BALLRADIUS 6
#define BALLCENTER 8
#define BALLLEFTEDGE 2
#define BALLRIGHTEDGE 13
#define BALLTOPEDGE 2
#define BALLBOTTOMEDGE 13

#define PX 7
#define PY 22
#define PW 23
#define PH 12

#define CX 8
#define CY 6
#define CW 21
#define CH 19

#define BX 2
#define BY 2
#define BW 11
#define BH 11

#define HOME 0
#define AWAY 1

typedef enum _DEFTYPE
{
	ZONE=0, MAN
} DEFTYPE;

typedef enum _POS
{
	GOALKEEPER=0, LEFTGUARD, RIGHTGUARD, LEFTSTRIKER, RIGHTSTRIKER, POINTMAN
} POS;

typedef enum _DIRECTION
{
	UPLEFT, UP, UPRIGHT, LEFT, RIGHT, DOWNLEFT, DOWN, DOWNRIGHT, UNKNOWN
} DIRECTION;

typedef enum _STATE
{
	STANDING, RUNNING, THROWING, TACKLING, JUMPING, FALLING
} STATE;

typedef enum _POSSESSION
{
	BLUE=0, RED, FREE
} POSSESSION;

typedef enum _BOOLEAN
{
 	FALSE=0, TRUE
} boolean;

typedef struct _DEFENCE
{
	DEFTYPE deftype;
	int aggzone;
	int slackzone;
	int slackman;
} DEFENCE;

typedef struct _ANIMATION
{
	SDL_Surface *frame[BITMAPCOUNT];
} ANIMATION;

typedef enum _OFFACTION 
{
	RUN = 0, CHARGE, WAIT, THROW, BREAKAWAY, NIL
} OFFACTION;

typedef struct _AREA
{
	int x;
	int y;
	int w;
	int h;
} AREA;

typedef struct _OFFMOVE
{
	OFFACTION action;
	int x;
	int y;
	int t;
	int d;
} OFFMOVE;

typedef struct _PLAYER
{
	SDL_Surface * image;
	ANIMATION stander;
	ANIMATION runner;
	ANIMATION thrower;
	ANIMATION faller;
	int x, y;
	int dx, dy;
	int defaultx, defaulty;
	int defensex, defensey;
	int throwdirection[3];
	int state;
	int statecount;
	
	AREA ozone;
	DIRECTION direction;
	POSSESSION team;
	boolean hasball;
	
	int waitctr;
	int offctr;
	OFFMOVE movelist[6];
	
	int spd;
	int pwr;
	int end;
	int agg;
	
	int tackles;
	int goals;
	int assists;
	int steals;
	int saves;
	
	int number;
	POS pos;
} PLAYER;

typedef struct _BALL
{
	SDL_Surface * image;
	
	int x, y;
	int dx, dy;
	int state;
	
	DIRECTION direction;
	POSSESSION possession;
	
	int lastplayer;
	int lastteam;
	int previousplayer;
	int previousteam;
	
	int playerindex;
	
} BALL;

typedef struct _YSORT
{
	int index;
	int y;
} YSORT;

typedef struct _DSORT
{
	int index;
	int distance;
} DSORT;

typedef struct _GAME
{
	SDL_Surface * screen;
	SDL_Surface * scoreboard;
	SDL_Surface * tocrop;
   SDL_Surface * background;
   SDL_Surface * scored;
   SDL_Surface * marker;

	PLAYER player[12];
	int NUMBEROFPLAYERS;
	
	BALL ball;
	
	DEFENCE teamdefence[2];
	DSORT dsort[12];
	
	SDL_Color *colors;
	
	int score[2];
	int timeleft;
	int delay;

} GAME;

int init_game(GAME * game);
int load_animations(GAME * game);
int unload_animations(GAME * game);
int FilterEvents(const SDL_Event *event);
void checkballcollisions(GAME * game);
void checkplayercollisions(int playernumber, GAME * game);
void updateframe(int playernumber, GAME * game);
boolean IsOverlap(AREA a, AREA b);
void goalscored(GAME * game, short team);
void handleevent(GAME * game, SDL_Event * event);
void loadanimation(ANIMATION * animation, char * filename);
void loadgraphic(SDL_Surface ** image, char * filename);
void scriptreader(GAME * game);
void handleplayeroverlap(PLAYER * player1, PLAYER * player2);
void determineAI(GAME * game, int playernumber);
void move(PLAYER * player, DIRECTION direction);
void throwball(GAME * game, int playernumber);
void tackle(PLAYER * player);
boolean Xoverlap(AREA a, AREA b);
boolean Yoverlap(AREA a, AREA b);
void resetplayers(GAME * game);
void resetball(BALL * ball);
void chasedown(PLAYER * player, AREA b);
void showstats(GAME * game);

void advancemovelist(PLAYER * player, BALL * ball);
void generatemovelist(PLAYER * player, BALL * ball);

#endif
