// main arenaball source file

#include "arenaball.h"

// the main routine currently contains the entire game
// eventually, when this gets to be only a part of it, with
// player management etc., this will be abstracted to its
// own module
int main(void)
{

	int ctr, ctr2, ctr3, ctr4;
	int eventint;
	SDL_Rect dest, src;
	SDL_Event event;
	
	YSORT ysort[13];
	YSORT dummy;
	DSORT ddummy;
			
	GAME game;
	
	srand((unsigned int)time((time_t*)NULL));

	//load_animations(&game);	
	init_game(&game);
	
	//SDL_EventState(SDL_KEYDOWN, SDL_IGNORE);
	//SDL_EventState(SDL_KEYUP, SDL_IGNORE);
	SDL_SetEventFilter(FilterEvents);

	// enter game loop	
	while(game.timeleft)
	{
		// read in any events
		eventint = SDL_PollEvent(&event);
		handleevent(&game, &event);
		
		// get defense information for zones, don't bother if ball is free
		if(game.ball.possession != FREE)
		{
			// get all the players
			for(ctr = 0, ctr4 = 0; ctr < game.NUMBEROFPLAYERS; ctr++)
			{
				// if it's a player on defence, read in the index and the distance
				if(game.player[ctr].team != game.ball.possession)
				{
					game.dsort[ctr4].index = ctr;
					game.dsort[ctr4].distance = sqrt(pow((game.player[ctr].x - game.ball.x), 2) + pow((game.player[ctr].y - game.ball.y), 2));
					ctr4++;
				}
			}
			// sort all the players by distance, highest up is closest
			for(ctr2 = 0; ctr2 < (ctr4 - 1); ctr2++)
			{
				for(ctr3 = (ctr2 + 1); ctr3 < ctr4; ctr3++)
				{
					if(game.dsort[ctr2].distance > game.dsort[ctr3].distance)
					{
						ddummy = game.dsort[ctr2];
						game.dsort[ctr2] = game.dsort[ctr3];
						game.dsort[ctr3] = ddummy;
					}
				}
//				printf("Sorted: Player %d is closest at distance %d\n", dsort[0].index, dsort[0].distance);
			}
		}
		
		// blit background onto tocrop
		SDL_BlitSurface(game.background, NULL, game.tocrop, NULL);

		// check for any ball collisions, ball position updated here...
		checkballcollisions(&game);
		//printf("%d players loaded...\n", game.NUMBEROFPLAYERS);		
		
		// check player collisions, get stats for y sorting
		for(ctr = 0; ctr < game.NUMBEROFPLAYERS; ctr++)
		{
			// determine the AI for every player that isn't human controlled
			if(ctr != 0)
				determineAI(&game, ctr);
			// check player collisions
			checkplayercollisions(ctr, &game);
			// get the players' y positions and indexes
			ysort[ctr].y = game.player[ctr].y + PY;
			ysort[ctr].index = ctr;
			// update the player's image
			updateframe(ctr, &game);
		}

		// put the ball in the list to be sorted		
		ysort[game.NUMBEROFPLAYERS].y = game.ball.y;
		ysort[game.NUMBEROFPLAYERS].index = 100;

		// sort players by y position
		for(ctr = 0; ctr < game.NUMBEROFPLAYERS; ctr++)
			for(ctr2 = (ctr + 1); ctr2 < game.NUMBEROFPLAYERS + 1; ctr2++)
				if(ysort[ctr].y > ysort[ctr2].y)
				{
					dummy = ysort[ctr2];
					ysort[ctr2] = ysort[ctr];
					ysort[ctr] = dummy;
				}
				
		// display players by y position
		for(ctr = 0; ctr < game.NUMBEROFPLAYERS+1; ctr++)
		{
			ctr2 = ysort[ctr].index;
			// show marker on human player
			if (ctr2 == 100)
			{
				if(game.ball.possession == FREE)
				{
					// display ball		
					dest.x = game.ball.x;
					dest.y = game.ball.y;
					dest.w = BW;
					dest.h = BH;
					SDL_BlitSurface(game.ball.image, NULL, game.tocrop, &dest);
				}
			}
			else 
			{
				if (ctr2 == 0)
				{
					dest.x = game.player[ctr2].x;
					dest.y = game.player[ctr2].y + 28;
					dest.w = BITMAPWIDTH;
					dest.h = 10;
					SDL_BlitSurface(game.marker, NULL, game.tocrop, &dest);
				}
			
				// get the player's information for display
				dest.x = game.player[ctr2].x;
				dest.y = game.player[ctr2].y;
				dest.w = BITMAPWIDTH;
				dest.h = 12;
				//printf("About to display player %d at position%d\n", ctr2, game.player[ctr2].y);
				
				// blit the player to tocrop
				SDL_BlitSurface(game.player[ctr2].image, NULL, game.tocrop, &dest);

				if (game.player[ctr2].hasball == TRUE)
				{
					game.ball.dx = game.player[ctr2].dx;
					game.ball.dy = game.player[ctr2].dy;
					// display ball
					dest.x = game.ball.x;
					dest.y = game.ball.y;
					dest.w = BW;
					dest.h = BH;
					SDL_BlitSurface(game.ball.image, NULL, game.tocrop, &dest);
				}
			}
		}

		
		// determine the area of the tocrop to blit from
		src.x = game.ball.x - 200;
		if(src.x <= 0)
			src.x = 0;
		else if(src.x >= 200)
			src.x = 200;
		
		src.y = game.ball.y - 150;
		if(src.y <= 0)
			src.y = 0;
		else if(src.y >= 500)
			src.y = 500;
		
		src.w = 400;
		src.h = 300;
		
		// blit cropped tocrop onto the screen
		SDL_BlitSurface(game.tocrop, &src, game.screen, NULL);
		
		src.x = 0;
		src.y = 0;
		src.w = 400;
		src.h = 100;
		dest.x = 0;
		dest.y = 300;
		dest.w = 400;
		dest.h = 100;
		SDL_BlitSurface(game.scoreboard, &src, game.screen, &dest);		
		
		// flip the buffer
		SDL_Flip(game.screen);
				
		// delay until next go around
		SDL_Delay(game.delay);
		
		// decrement the time
		game.timeleft--;
	}
	
	// unload all animations
	unload_animations(&game);
	
	// put game ending features here...
	
	// Put quit information here 
	
	showstats(&game);
	
	printf("Quitting SDL.\n");
	SDL_Quit();
	printf("Quitting...\n");
	
	// exit
	exit(0);
}

// Routine in case a goal is scored
void goalscored(GAME * game, short team)
{
	int ctr;
	SDL_Rect src, dest;	

	// update, show new score
	game->score[team]++;
	printf("SCORED! HOME: %d  AWAY: %d\n", game->score[HOME], game->score[AWAY]);
	
	// determine who gets goal and who gets assist...
	if(game->ball.lastteam != team)
		printf("Own goal...");
	else
	{
		printf("Goal scored by #%d\n", game->ball.lastplayer);
		for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
			if((game->player[ctr].number == game->ball.lastplayer) & (game->player[ctr].team == game->ball.lastteam))
			{
				game->player[ctr].goals++;
				printf("That's goal #%d for him!\n", game->player[ctr].goals);
			}
		//loop through and assign goal to this player
		//game->player[game->ball.lastplayer].goals++;
		
		if((game->ball.lastteam == game->ball.previousteam) & (game->ball.lastplayer != game->ball.previousplayer))
		{
			printf("Assist goes to #%d\n", game->ball.previousplayer);
			for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
				if((game->player[ctr].number == game->ball.previousplayer) & (game->player[ctr].team == game->ball.previousteam))
				{
					game->player[ctr].assists++;
					printf("That's assist #%d for him!\n", game->player[ctr].assists);
				}
					
			//loop through and assign assist to this player			
		}
	}
	
	
	// reset defences depending on score...
	
	game->teamdefence[HOME].deftype = ZONE;
	game->teamdefence[AWAY].deftype = ZONE;
	if(game->score[HOME] > game->score[AWAY])
	{
		game->teamdefence[AWAY].deftype = MAN;
	}
	else if (game->score[AWAY] > game->score[HOME])
	{
		game->teamdefence[HOME].deftype = MAN;
	}

	// blit the ball the point that it's been scored	
	dest.x = game->ball.x;
	dest.y = game->ball.y;
	SDL_BlitSurface(game->ball.image, NULL, game->tocrop, &dest);

	// blit "Goal!!" or something
	// This needs to be fixed, probably should move to the text based stuff soon...			
	dest.x = 5;
	dest.y = 50;
	
	SDL_BlitSurface(game->scored, NULL, game->tocrop, &dest);
	// Need to do a location blit check here too.

	// blit the current picture onto the screen
	// needs tidying, this was cut and pasted from another function
	src.x = game->ball.x - 200;
	if(src.x <= 0)
		src.x = 0;
	else if(src.x >= 200)
		src.x = 200;
	
	src.y = game->ball.y - 150;
	if(src.y <= 0)
		src.y = 0;
	else if(src.y >= 500)
		src.y = 500;
	src.w = 400;
	src.h = 300;
	SDL_BlitSurface(game->tocrop, &src, game->screen, NULL);

	// flip the buffer and delay a moment
	SDL_Flip(game->screen);
	SDL_Delay(1000);

	// blit the background
	SDL_BlitSurface(game->background, NULL, game->tocrop, NULL);
	// reset the ball and players, update their frames
	resetball(&game->ball);
	resetplayers(game);
	updateframe(0, game);

	// blit all the players at their starting positions
	for(ctr=0; ctr < game->NUMBEROFPLAYERS; ctr++)	
	{
		dest.x = game->player[ctr].x;
		dest.y = game->player[ctr].y;
		dest.w = BITMAPWIDTH;
		dest.h = BITMAPWIDTH;

		SDL_BlitSurface(game->player[ctr].image, NULL, game->tocrop, &dest);
	}

	// blit the current picture
	// once again, might need tidying
	src.x = game->ball.x - 200;
	if(src.x <= 0)
		src.x = 0;
	else if(src.x >= 200)
		src.x = 200;
	
	src.y = game->ball.y - 150;
	if(src.y <= 0)
		src.y = 0;
	else if(src.y >= 500)
		src.y = 500;
	
	src.w = 400;
	src.h = 300;
	SDL_BlitSurface(game->tocrop, &src, game->screen, NULL);
	
	// flip and delay, and then whistle, return to game loop
	SDL_Flip(game->screen);
	SDL_Delay(1000);
	printf("Whistle!\n");

}

// this function resets the players at their starting positions
void resetplayers(GAME * game)
{
	// for each player, revert it to their default x:y,
	// reset all states
	int ctr;
	for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
	{
		game->player[ctr].hasball = FALSE;
	 	game->player[ctr].x = game->player[ctr].defaultx - 19;
		game->player[ctr].y = game->player[ctr].defaulty - PY - PH;
		game->player[ctr].dx = 0;
		game->player[ctr].dy = 0;
		game->player[ctr].state = STANDING;
		game->player[ctr].statecount = 0;
		game->player[ctr].image = game->player[ctr].stander.frame[0];
		if(game->player[ctr].team == BLUE)
			game->player[ctr].direction = DOWN;
		else
			game->player[ctr].direction = UP;
		
		if(game->player[ctr].pos != GOALKEEPER)	
			generatemovelist(&game->player[ctr], &game->ball);
	}
}

// this function resets the ball
void resetball(BALL * ball)
{
	ball->x = 300 - (BW * 0.5);
	ball->y = 400 - (BH * 0.5);
	ball->dx = 0;
	ball->dy = 0;
	
	// reset ball ownerships for stat tracking
	ball->lastplayer = 0;
	ball->lastteam = 2;
	ball->previousplayer = 0;
	
	ball->possession = FREE;
}

// this function updates the image for each player
void updateframe(int playernumber, GAME * game)
{
	SDL_Surface * image;
	static int statecount;
	
	// get the statecount
	statecount = game->player[playernumber].statecount;
	//printf("Updating frame for %d, counter at %d\n", playernumber, statecount);

	// if the player is falling
	if (game->player[playernumber].state == FALLING)
	{
		// update, check for last frame, reset at standing
		statecount++;
		if(statecount > 7)
		{
			statecount = 0;
			game->player[playernumber].state = STANDING;
		}
		image = game->player[playernumber].faller.frame[statecount];
	}
	// if the player is throwing
	else if (game->player[playernumber].state == THROWING)
	{
		// update, check for last frame
	 	statecount++;
		// make sure player no longer has the ball
		game->player[playernumber].hasball = FALSE;
	 	if(statecount > 7)
	 	{
	 		statecount = 0;
	 	 	game->player[playernumber].state = STANDING;
			// get the standing frame
	 	 	image = game->player[playernumber].stander.frame[statecount];
	 	}
	 	else
			// get the throwing frame
			image = game->player[playernumber].thrower.frame[statecount];
	}
	// if the player is standing there
	else if (game->player[playernumber].state == STANDING)
	{
		// reset statecount to 0
		statecount = 0;	
		image = game->player[playernumber].stander.frame[statecount];
	}
	// if the player is tackling
	else if (game->player[playernumber].state == TACKLING)
	{
		// update, check for last frame, reset at running
		statecount++;
		if(statecount > 7)
		{
			statecount = 0;
			game->player[playernumber].state = RUNNING;
	 	 	image = game->player[playernumber].runner.frame[statecount];
		}
		else
		{
			image = game->player[playernumber].runner.frame[statecount];
		}
		
		// AI doesn't seem to want to run and tackle, so this has been thrown in
		// to allow them to
		if(playernumber != 0)
		{
			game->player[playernumber].x += game->player[playernumber].dx;
			game->player[playernumber].y += game->player[playernumber].dy;		
		}
	}
	// if the player isn't moving anywhere
	else if((game->player[playernumber].dx == 0) & (game->player[playernumber].dy == 0))
	{
		// have the player be standing
		image = game->player[playernumber].runner.frame[0];
		game->player[playernumber].state = STANDING;
	}
	// if the player is running
	else if (game->player[playernumber].state == RUNNING)
	{
		// update, check for 7, allow to keep running
	 	statecount++;
	 	if(statecount > 7)
	 		statecount = 0;
		image = game->player[playernumber].runner.frame[statecount];
	}
	
	// reassign the state, assign the image 
	game->player[playernumber].statecount = statecount;
	game->player[playernumber].image = image;
		
}

// this function unloads all animations (terribly unfinished)
int unload_animations(GAME * game)
{
	int ctr;
	SDL_FreeSurface(game->background);
	for(ctr=7; ctr>=0; ctr--)
	{
		//SDL_FreeSurface(game->player[0].runner.frame[ctr]);
		//SDL_FreeSurface(game->player[0].runner.frame[ctr]);	
	}
	return(0);
}
