#include "arenaball.h"


// This file determines basic ai, includes basic movement function call chasedown

void determineAI (GAME * game, int playernumber)
{
	AREA aball, aposition, aplayer, azone, oplayer, ozone;
	POS playertoguard[6] = {GOALKEEPER, RIGHTSTRIKER, LEFTSTRIKER, RIGHTGUARD, LEFTGUARD, POINTMAN};
	int ctr, ctr2, breakaway, randnum;
	int obstructing, obstructingindex;
	float modifier;
	int direction;
	
	modifier = 0.3;
	
	aplayer.x = game->player[playernumber].x + PX;
	aplayer.y = game->player[playernumber].y + PY;
	aplayer.w = PW;
	aplayer.h = PH;
	
	//printf("Determining ai for %d\n", playernumber);
	
	if((game->player[playernumber].state != FALLING) & (game->player[playernumber].state != THROWING))
	{
		// Handle the free ball
		if(game->ball.possession == FREE)
		{
		
			aball.x = game->ball.x + BX;
			aball.y = game->ball.y + BY;
			aball.w = BW;
			aball.h = BH;

			if((game->player[playernumber].team == HOME) & (game->ball.y < 200))
				chasedown(&game->player[playernumber], aball);
			else if((game->player[playernumber].team == AWAY) & (game->ball.y > 600))
				chasedown(&game->player[playernumber], aball);
			else if(game->player[playernumber].team != game->ball.lastteam)
				chasedown(&game->player[playernumber], aball);
			else
			{
				azone.x = game->player[playernumber].x + PX - (game->player[playernumber].agg * 12);
				azone.y = game->player[playernumber].y + PY - (game->player[playernumber].agg * 12);
				azone.w = PW + (game->player[playernumber].agg * 24);
				azone.h = PH + (game->player[playernumber].agg * 24);
				
				ozone.x = game->player[playernumber].ozone.x;
				ozone.y = game->player[playernumber].ozone.y;
				ozone.w = game->player[playernumber].ozone.w;
				ozone.h = game->player[playernumber].ozone.h;
	
				if(IsOverlap(azone, aball))
					chasedown(&game->player[playernumber], aball);
				else if(IsOverlap(ozone, aball))
				{
					chasedown(&game->player[playernumber], aball);
				}
				else
				{
					aposition.x = game->player[playernumber].movelist[game->player[playernumber].offctr].x;
					aposition.y = game->player[playernumber].movelist[game->player[playernumber].offctr].y;
					aposition.w = BW;
					aposition.h = BH;
					
					aplayer.x = game->player[playernumber].x + PX;
					aplayer.y = game->player[playernumber].y + PY;
					aplayer.w = PW;
					aplayer.h = PH;
					
					if(!IsOverlap(aplayer, aposition))
						chasedown(&game->player[playernumber], aposition);
					else
					{
						game->player[playernumber].dx = 0;
						game->player[playernumber].dy = 0;
						game->player[playernumber].state = STANDING;
					}
				}
			}
		}
		else if(game->ball.possession == BLUE)
		{
			if(game->player[playernumber].team == BLUE)
/********************************* HOME IS ON OFFENCE ******************************/
			{
				if(game->player[playernumber].pos != GOALKEEPER)
				{
					if ((game->ball.y < 150) & (game->player[playernumber].y > game->ball.y) & (game->player[playernumber].hasball == FALSE))
						game->player[playernumber].offctr = 0;
					else if (game->player[playernumber].offctr == 0)
						game->player[playernumber].offctr = 1;
				}
				
				// if the player has a chance to go on a breakaway, go for it
				if((game->player[playernumber].hasball == TRUE) & ((game->ball.y > 300) | (game->player[playernumber].pos == GOALKEEPER)))
				{
					// check number of players between him and goal
					azone.x = game->player[playernumber].x + PX - 30;
					azone.y = game->player[playernumber].y + PY;
					azone.w = PW +	60;
					azone.h = 400;	

					breakaway = 0;				
					for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
					{
						if((game->player[ctr].team != game->player[playernumber].team) & (game->player[ctr].pos != GOALKEEPER))
						{
							oplayer.x = game->player[ctr].x + PX;
							oplayer.y = game->player[ctr].y + PY;
							oplayer.w = PW;
							oplayer.h = PH;
							
							if(IsOverlap(azone, oplayer))
								breakaway++;
						}
					}
					
					// if he can go on a breakaway, go for it...
					if((breakaway < 1) & (game->player[playernumber].pos != GOALKEEPER))
					{
						if(game->player[playernumber].movelist[game->player[playernumber].offctr].action != BREAKAWAY)
						{
							game->player[playernumber].offctr = 5;
							game->player[playernumber].movelist[game->player[playernumber].offctr].action = BREAKAWAY;
							game->player[playernumber].movelist[game->player[playernumber].offctr].x = 200 + rand()%200;
							game->player[playernumber].movelist[game->player[playernumber].offctr].y = 650 + rand()%50;
							//printf("Player going on a breakaway!\n");
						}
					}
					else if(game->player[playernumber].movelist[game->player[playernumber].offctr].action == BREAKAWAY)
					{
						generatemovelist(&game->player[playernumber], &game->ball);
					}
					else
					{
						if((game->player[playernumber].pos == GOALKEEPER) | (rand()%150 < (15 - game->player[playernumber].agg)))
						{
							azone.x = game->player[playernumber].x + PX - 20;
							azone.y = game->player[playernumber].y + PY;
							azone.w = PW + 40;
							azone.h = 40;
						
							obstructing = 0;
							obstructingindex = 0;
						
							for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
							{
								if(game->player[ctr].team != game->player[playernumber].team)
								{
									oplayer.x = game->player[ctr].x + PX;
									oplayer.y = game->player[ctr].y + PY;
									oplayer.w = PW;
									oplayer.h = PH;
									
									if(IsOverlap(azone, oplayer))
									{
										obstructingindex = ctr;
										obstructing++;
									}
								}
							}
							
							randnum = rand()%15 + 1;
							
							// for the moment, make him pass, aggressive players might go for it, through...
							if((randnum >= game->player[playernumber].agg) | (game->player[playernumber].pos == GOALKEEPER))
							{
								//printf("Failed 2nd aggression check %d <= %d\n", game->player[playernumber].agg, randnum);
								if(obstructing == 1)
								{
									game->player[playernumber].offctr = 5;
									game->player[playernumber].movelist[5].action = THROW;
									
									if(game->player[obstructingindex].x > game->player[playernumber].x)
										game->player[playernumber].movelist[5].d = DOWNLEFT;
									else
										game->player[playernumber].movelist[5].d = DOWNRIGHT;
										
									//printf("Throwing to clear\n");
							
								}
								if(obstructing > 1)
								{
									game->player[playernumber].offctr = 5;
									game->player[playernumber].movelist[5].action = THROW;
									game->player[playernumber].movelist[5].d = UNKNOWN;
									
									//printf("Throwing desperately\n");
								}
								else
								{
									//printf("number of obstructing opponents = %d\n", obstructing);
								}
							}
							else
							{
								//printf("Passed 2nd aggression check %d >= %d\n", game->player[playernumber].agg, randnum);
							
								generatemovelist(&game->player[playernumber], &game->ball);
								game->player[playernumber].offctr = 2;
								game->player[playernumber].movelist[2].action = CHARGE;
								game->player[playernumber].movelist[2].y = game->player[playernumber].y + 100;
								
								//printf("Charging the opponent\n");
							}
						}
					}
				}
				
				aplayer.x = game->player[playernumber].x + PX;
				aplayer.y = game->player[playernumber].y + PY;
				aplayer.w = PW;
				aplayer.h = PH;
				
				switch (game->player[playernumber].movelist[game->player[playernumber].offctr].action)
				{
					case THROW:
					{
						if(game->player[playernumber].hasball == TRUE)
						{
							if(game->player[playernumber].movelist[game->player[playernumber].offctr].d == DOWNLEFT)
							{
								direction = 0;
							}
							else if(game->player[playernumber].movelist[game->player[playernumber].offctr].d == DOWNRIGHT)
							{
								direction = 2;
							}
							else if(game->player[playernumber].x < 250)
							{
								direction = (rand() % 2) + 1;
							}
							else if(game->player[playernumber].x > 350)
							{
								direction = (rand() % 2);
							}
							else
								direction = rand() % 3;
							
							game->player[playernumber].direction = game->player[playernumber].throwdirection[direction];
							throwball(game, playernumber);
							advancemovelist(&game->player[playernumber], &game->ball);						
							//printf("Player is throwing\n");
						}
						else
						{
							advancemovelist(&game->player[playernumber], &game->ball);
						}
						break;
					}
					case WAIT:
					{
//						if(game->player[playernumber].pos == GOALKEEPER)
//							printf("Here?\n");
						game->player[playernumber].dx = 0;
						game->player[playernumber].dy = 0;
						game->player[playernumber].waitctr--;
						if(game->player[playernumber].waitctr < 0)
							advancemovelist(&game->player[playernumber], &game->ball);
//						printf("Player is waiting\n");
						break;
					}
					case CHARGE:
					{
						game->player[playernumber].state = TACKLING;
						aposition.x = game->player[playernumber].movelist[game->player[playernumber].offctr].x;
						aposition.y = game->player[playernumber].movelist[game->player[playernumber].offctr].y;
						aposition.w = BW;
						aposition.h = BH;
						if(IsOverlap(aplayer, aposition))
							advancemovelist(&game->player[playernumber], &game->ball);
						else
							chasedown(&game->player[playernumber], aposition);
//						printf("Player is charging\n");
						break;						
					}
					case BREAKAWAY:
					{
						aposition.x = game->player[playernumber].movelist[game->player[playernumber].offctr].x;
						aposition.y = game->player[playernumber].movelist[game->player[playernumber].offctr].y;
						aposition.w = BW;
						aposition.h = BH;
						
//						printf("Heading to x:y %d:%d\n", aposition.x, aposition.y);
						if(IsOverlap(aplayer, aposition))
						{
							if(game->player[playernumber].x < 250)
							{
								direction = (rand() % 2) + 1;
							}
							else if(game->player[playernumber].x > 350)
							{
								direction = (rand() % 2);
							}
							else
								direction = rand() % 3;
							
							game->player[playernumber].direction = game->player[playernumber].throwdirection[direction];
							throwball(game, playernumber);
							game->player[playernumber].movelist[3].action = WAIT;
						}
						else
						{
							chasedown(&game->player[playernumber], aposition);
						}
						break;
					}
					case RUN:
					{
						aposition.x = game->player[playernumber].movelist[game->player[playernumber].offctr].x;
						aposition.y = game->player[playernumber].movelist[game->player[playernumber].offctr].y;
						aposition.w = BW;
						aposition.h = BH;
						if(IsOverlap(aplayer, aposition))
						{
							if((game->ball.y < 150) & (game->player[playernumber].hasball == FALSE) & (game->ball.dx == 0) & (game->ball.dy == 0) & ((game->player[playernumber].pos == RIGHTGUARD) | (game->player[playernumber].pos == POINTMAN) | (game->player[playernumber].pos == LEFTGUARD)))
							{
								game->player[playernumber].dx = 0;
								game->player[playernumber].dy = 0;
							}
							else
							{
//						if(game->player[playernumber].pos == GOALKEEPER)
//							printf("Here?\n");
								advancemovelist(&game->player[playernumber], &game->ball);
							}
						}
						else
							chasedown(&game->player[playernumber], aposition);
//						printf("Player is running to %d:%d\n", game->player[playernumber].movelist[game->player[playernumber].offctr].x, game->player[playernumber].movelist[game->player[playernumber].offctr].y);
						break;						
					}
					default:
					{
//						printf("%d\n", game->player[playernumber].movelist[game->player[playernumber].offctr].action);
						
						break;
					}
					
				} // end offense select
			}
			else
			{
/********************************* AWAY IS ON DEFENCE ******************************/
				if(game->player[playernumber].pos == GOALKEEPER)
				{
				
					azone.x = game->player[playernumber].x + PX - (game->player[playernumber].agg * 3);
					azone.y = game->player[playernumber].y + PY - (game->player[playernumber].agg * 6);
					azone.w = PW + (game->player[playernumber].agg * 6);
					azone.h = PH + (game->player[playernumber].agg * 6);
					
					aball.x = game->ball.x + BX;
					aball.y = game->ball.y + BY;
					aball.w = BW;
					aball.h = BH;
					
					if(IsOverlap(azone, aball))
					{
						printf("Overlap!\n");
					
						aposition.x = aball.x;
						aposition.y = aball.y + PH;
					}
					else
					{
						if((game->ball.x < 210) | (game->ball.x > 390))
							aposition.x = 150 + (game->ball.x * 0.5);
						else
							aposition.x = game->ball.x;
						aposition.y = 760 - ((770 - game->ball.y) * 0.2);
					}
				}
				else if(game->ball.y > game->teamdefence[game->player[playernumber].team].aggzone)
				{
					aposition.x = game->ball.x;
					aposition.y = game->ball.y + PH;
				}
            else if((game->teamdefence[game->player[playernumber].team].deftype == ZONE) & (playernumber == game->dsort[0].index) & (game->ball.y > game->teamdefence[game->player[playernumber].team].slackzone))
            {
					aposition.x = game->ball.x;
					aposition.y = game->ball.y + PH;					
            }
            else if(game->teamdefence[game->player[playernumber].team].deftype == MAN)
            {
//					printf("In here\n");
            	//printf("Player %d guarding player %d\n", game->player[playernumber].pos, playertoguard[game->player[playernumber].pos]);
					//printf("Here\n");            	
					for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
					{
						if((game->player[ctr].pos == playertoguard[game->player[playernumber].pos]) & (game->player[ctr].team != game->player[playernumber].team))
							ctr2 = ctr;
					}
					if(game->player[ctr2].y > game->teamdefence[game->player[playernumber].team].slackman)
					{         	
	            	aposition.x = game->player[ctr2].x + PX;
   	         	aposition.y = game->player[ctr2].y + PY;
   	         }
   	         else
   	         {
   	         	aposition.x = game->player[playernumber].defensex;
   	         	aposition.y = game->player[playernumber].defensey;
   	         }

            }
				else
				{
					aposition.x = game->player[playernumber].defensex;
					aposition.y = game->player[playernumber].defensey;				
				}
				/* */
				aposition.w = BW;
				aposition.h = BH;
				if(!IsOverlap(aplayer, aposition))
				{
					//printf("On defense!\n");
					chasedown(&game->player[playernumber], aposition);
					//printf("Chasing down pt x=%d y=%d\n", aposition.x, aposition.y);
				}
				else
				{
				 	game->player[playernumber].dx = 0;
				 	game->player[playernumber].dy = 0;
				}

				/* */
				//moveRIGHT(&game->player[playernumber]);			
			}
		}
		else
		{
/********************************* HOME IS ON DEFENCE ******************************/
			if(game->player[playernumber].team == BLUE)
			{
				/* */
				if(game->player[playernumber].pos == GOALKEEPER)
				{
					azone.x = game->player[playernumber].x + PX - (game->player[playernumber].agg * 3);
					azone.y = game->player[playernumber].y + PY;
					azone.w = PW + (game->player[playernumber].agg * 6);
					azone.h = PH + (game->player[playernumber].agg * 6);
					
					aball.x = game->ball.x + BX;
					aball.y = game->ball.y + BY;
					aball.w = BW;
					aball.h = BH;
					
					if(IsOverlap(azone, aball))
					{
						aposition.x = aball.x;
						aposition.y = aball.y + PH;
					}
					else
					{
						if((game->ball.x < 210) | (game->ball.x > 390))
							aposition.x = 150 + (game->ball.x * 0.5);
						else
							aposition.x = game->ball.x;
						aposition.y = 30 + ((game->ball.y - 30) * 0.2);
					}
				}
				else if(game->ball.y < game->teamdefence[game->player[playernumber].team].aggzone)
				{
					aposition.x = game->ball.x;
					aposition.y = game->ball.y + PH;				
				}
            else if((game->teamdefence[game->player[playernumber].team].deftype == ZONE) & (playernumber == game->dsort[0].index) & (game->ball.y < game->teamdefence[game->player[playernumber].team].slackzone))
            {
					aposition.x = game->ball.x;
					aposition.y = game->ball.y + PH;					
            }
            else if(game->teamdefence[game->player[playernumber].team].deftype == MAN)
            {
					for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
					{
						if((game->player[ctr].pos == playertoguard[game->player[playernumber].pos]) & (game->player[ctr].team != game->player[playernumber].team))
							ctr2 = ctr;
					}
					if(game->player[ctr2].y < game->teamdefence[game->player[playernumber].team].slackman)
					{            	
	            	aposition.x = game->player[ctr2].x + PX;
   	         	aposition.y = game->player[ctr2].y + PY;
   	         }
   	         else
   	         {
   	         	aposition.x = game->player[playernumber].defensex;
   	         	aposition.y = game->player[playernumber].defensey;
   	         }
            }
				else
				{
					aposition.x = game->player[playernumber].defensex;
					aposition.y = game->player[playernumber].defensey;				
				}
				aposition.w = 2;
				aposition.h = 2;
				if(!IsOverlap(aplayer, aposition))
				{
					//printf("On defense!\n");
					chasedown(&game->player[playernumber], aposition);
				}
				else
				{
					// go into zone defence
				 	game->player[playernumber].dx = 0;
				 	game->player[playernumber].dy = 0;
				}

				/* */
			}
			else
			{
/********************************* AWAY IS ON OFFENCE ******************************/
				if(game->player[playernumber].pos != GOALKEEPER)
				{
					if ((game->ball.y > 650) & (game->player[playernumber].y < game->ball.y) & (game->player[playernumber].hasball == FALSE))
						game->player[playernumber].offctr = 0;
					else if (game->player[playernumber].offctr == 0)
						game->player[playernumber].offctr = 1;
				}
				
				// if the player has a chance to go on a breakaway, go for it
				if((game->player[playernumber].hasball == TRUE) & ((game->ball.y < 500) | (game->player[playernumber].pos == GOALKEEPER)))
				{
					// check number of players between him and goal
					azone.x = game->player[playernumber].x + PX - 30;
					azone.y = game->player[playernumber].y + PY - 400;
					azone.w = PW +	60;
					azone.h = 400;	

					breakaway = 0;				
					for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
					{
						if((game->player[ctr].team != game->player[playernumber].team) & (game->player[ctr].pos != GOALKEEPER))
						{
							oplayer.x = game->player[ctr].x + PX;
							oplayer.y = game->player[ctr].y + PY;
							oplayer.w = PW;
							oplayer.h = PH;
							
							if(IsOverlap(azone, oplayer))
								breakaway++;
						}
					}
					
					// if he can go on a breakaway, go for it...
					if((breakaway < 1) & (game->player[playernumber].pos != GOALKEEPER))
					{
						if(game->player[playernumber].movelist[game->player[playernumber].offctr].action != BREAKAWAY)
						{
							game->player[playernumber].offctr = 5;
							game->player[playernumber].movelist[game->player[playernumber].offctr].action = BREAKAWAY;
							game->player[playernumber].movelist[game->player[playernumber].offctr].x = 200 + rand()%200;
							game->player[playernumber].movelist[game->player[playernumber].offctr].y = 100 + rand()%50;
						}
					}
					else if(game->player[playernumber].movelist[game->player[playernumber].offctr].action == BREAKAWAY)
					{
						generatemovelist(&game->player[playernumber], &game->ball);
					}
					else
					{
						if((game->player[playernumber].pos == GOALKEEPER) | (rand()%150 < (15 - game->player[playernumber].agg)))
						{
							azone.x = game->player[playernumber].x + PX - 20;
							azone.y = game->player[playernumber].y + PY - 40;
							azone.w = PW + 40;
							azone.h = 40;
						
							obstructing = 0;
							obstructingindex = 0;
						
							for(ctr = 0; ctr < game->NUMBEROFPLAYERS; ctr++)
							{
								if(game->player[ctr].team != game->player[playernumber].team)
								{
									oplayer.x = game->player[ctr].x + PX;
									oplayer.y = game->player[ctr].y + PY;
									oplayer.w = PW;
									oplayer.h = PH;
									
									if(IsOverlap(azone, oplayer))
									{
										obstructingindex = ctr;
										obstructing++;
									}
								}
							}
							
							randnum = rand()%15 + 1;
							
							// for the moment, make him pass, aggressive players might go for it, through...
							if((randnum >= game->player[playernumber].agg) | (game->player[playernumber].pos == GOALKEEPER))
							{
								printf("Failed 2nd aggression check %d <= %d\n", game->player[playernumber].agg, randnum);
								if(obstructing == 1)
								{
									game->player[playernumber].offctr = 5;
									game->player[playernumber].movelist[5].action = THROW;
									
									if(game->player[obstructingindex].x > game->player[playernumber].x)
										game->player[playernumber].movelist[5].d = UPLEFT;
									else
										game->player[playernumber].movelist[5].d = UPRIGHT;
										
									printf("Throwing to clear\n");
							
								}
								if(obstructing > 1)
								{
									game->player[playernumber].offctr = 5;
									game->player[playernumber].movelist[5].action = THROW;
									game->player[playernumber].movelist[5].d = UNKNOWN;
									
//									printf("Throwing desperately\n");
								}
								else
								{
									printf("number of obstructing opponents = %d\n", obstructing);
								}
							}
							else
							{
								printf("Passed 2nd aggression check %d >= %d\n", game->player[playernumber].agg, randnum);
							
								generatemovelist(&game->player[playernumber], &game->ball);
								game->player[playernumber].offctr = 2;
								game->player[playernumber].movelist[2].action = CHARGE;
								game->player[playernumber].movelist[2].y = game->player[playernumber].y - 100;
								
								printf("Charging the opponent\n");
							}
						}
					}
				}								
				
				aplayer.x = game->player[playernumber].x + PX;
				aplayer.y = game->player[playernumber].y + PY;
				aplayer.w = PW;
				aplayer.h = PH;
				
				switch (game->player[playernumber].movelist[game->player[playernumber].offctr].action)
				{
					case THROW:
					{
						if(game->player[playernumber].hasball == TRUE)
						{
							if(game->player[playernumber].movelist[game->player[playernumber].offctr].d == UPLEFT)
							{
								direction = 2;
							}
							else if(game->player[playernumber].movelist[game->player[playernumber].offctr].d == UPRIGHT)
							{
								direction = 0;
							}
							else if(game->player[playernumber].x < 250)
							{
								direction = (rand() % 2);
							}
							else if(game->player[playernumber].x > 350)
							{
								direction = (rand() % 2) + 1;
							}
							else
								direction = rand() % 3;
							
							game->player[playernumber].direction = game->player[playernumber].throwdirection[direction];
							throwball(game, playernumber);
							advancemovelist(&game->player[playernumber], &game->ball);						
							//printf("Player is throwing\n");
						}
						else
						{
							advancemovelist(&game->player[playernumber], &game->ball);
						}
						break;
					}
					case WAIT:
					{
//						if(game->player[playernumber].pos == GOALKEEPER)
//							printf("Here?\n");
						game->player[playernumber].dx = 0;
						game->player[playernumber].dy = 0;
						game->player[playernumber].waitctr--;
						if(game->player[playernumber].waitctr < 0)
							advancemovelist(&game->player[playernumber], &game->ball);
//						printf("Player is waiting\n");
						break;
					}
					case CHARGE:
					{
						game->player[playernumber].state = TACKLING;
						aposition.x = game->player[playernumber].movelist[game->player[playernumber].offctr].x;
						aposition.y = game->player[playernumber].movelist[game->player[playernumber].offctr].y;
						aposition.w = BW;
						aposition.h = BH;
						if(IsOverlap(aplayer, aposition))
							advancemovelist(&game->player[playernumber], &game->ball);
						else
							chasedown(&game->player[playernumber], aposition);
//						printf("Player is charging\n");
						break;						
					}
					case BREAKAWAY:
					{
						aposition.x = game->player[playernumber].movelist[game->player[playernumber].offctr].x;
						aposition.y = game->player[playernumber].movelist[game->player[playernumber].offctr].y;
						aposition.w = BW;
						aposition.h = BH;
						
//						printf("Heading to x:y %d:%d\n", aposition.x, aposition.y);
						if(IsOverlap(aplayer, aposition))
						{
							if(game->player[playernumber].x < 250)
							{
								direction = (rand() % 2);
							}
							else if(game->player[playernumber].x > 350)
							{
								direction = (rand() % 2) + 1;
							}
							else
								direction = rand() % 3;
							
							game->player[playernumber].direction = game->player[playernumber].throwdirection[direction];
							throwball(game, playernumber);
							game->player[playernumber].movelist[3].action = WAIT;
						}
						else
						{
							chasedown(&game->player[playernumber], aposition);
						}
						break;
					}
					case RUN:
					{
						aposition.x = game->player[playernumber].movelist[game->player[playernumber].offctr].x;
						aposition.y = game->player[playernumber].movelist[game->player[playernumber].offctr].y;
						aposition.w = BW;
						aposition.h = BH;
						if(IsOverlap(aplayer, aposition))
						{
							if((game->ball.y > 650) & (game->player[playernumber].hasball == FALSE) & (game->ball.dx == 0) & (game->ball.dy == 0) & ((game->player[playernumber].pos == RIGHTGUARD) | (game->player[playernumber].pos == POINTMAN) | (game->player[playernumber].pos == LEFTGUARD)))
							{
								game->player[playernumber].dx = 0;
								game->player[playernumber].dy = 0;
							}
							else
							{
//						if(game->player[playernumber].pos == GOALKEEPER)
//							printf("Here?\n");
								advancemovelist(&game->player[playernumber], &game->ball);
							}
						}
						else
							chasedown(&game->player[playernumber], aposition);
//						printf("Player is running to %d:%d\n", game->player[playernumber].movelist[game->player[playernumber].offctr].x, game->player[playernumber].movelist[game->player[playernumber].offctr].y);
						break;						
					}
					default:
					{
//						printf("%d\n", game->player[playernumber].movelist[game->player[playernumber].offctr].action);
						
						break;
					}
				} // end offense select
			} // end away on offence
		} // end home/away
	} // end player ! falling
}

void advancemovelist(PLAYER * player, BALL * ball)
{

//	printf("Player at checkpoint %d\n", player->offctr);

	player->offctr++;
	if((player->offctr > 5) | (player->movelist[player->offctr].action == NIL))
	{
		generatemovelist(player, ball);
		player->offctr = 1;
	}
	else
	{
		switch(player->movelist[player->offctr].action)
		{
			case WAIT:
			{
				player->waitctr = player->movelist[player->offctr].t;
				break;
			}
			case THROW:
			{
//				printf("Player to throw\n");
				break;
			}
			default:
			{
//				printf("Player to move to x:y %d:%d\n", player->movelist[player->offctr].x, player->movelist[player->offctr].y);
				break;
			}
		}
	}
}

// basic randomness at the moment...
void generatemovelist(PLAYER * player, BALL * ball)
{
	int ctr;
	POSSESSION team;
	OFFACTION actionlist[25] = {WAIT, THROW, WAIT, THROW, WAIT, THROW, RUN, WAIT, THROW, RUN, WAIT, THROW,
										RUN, CHARGE, WAIT, RUN, CHARGE, THROW, RUN, CHARGE, RUN, CHARGE, RUN, CHARGE, RUN};
	
	team = player->team;

	if(player->pos == GOALKEEPER)
	{
		player->offctr = 0;
		player->movelist[0].action = RUN;
		player->movelist[1].action = WAIT;
		player->movelist[1].t = 20;
		player->movelist[2].action = THROW;
	}
	else
	{
		ctr = (rand() % 10) + player->agg;
		//ctr = rand() % 4;
		player->movelist[2].action = actionlist[ctr];
		
		if(team == HOME)
		{
			if(player->hasball == TRUE)
			{
				if(player->y > player->movelist[0].y)
					player->offctr = 1;
				else
					player->offctr = 0;
			}
			else
			{
				if(ball->y > 200)
					player->offctr = 1;
				else
					player->offctr = 0;
			}
		}
		else
		{
			if(player->hasball == TRUE)
			{
				if(player->y < player->movelist[0].y)
					player->offctr = 1;
				else
					player->offctr = 0;
			}
			else
			{
				if(ball->y < 600)
					player->offctr = 1;
				else
					player->offctr = 0;
			}
		
		}	
	}

	switch(player->movelist[2].action)
	{
		case RUN:
		{
			if(team == HOME)
				player->movelist[2].y = player->movelist[1].y + (rand() % 3) * 15;
			else
				player->movelist[2].y = player->movelist[1].y - (rand() % 3) * 15;
			player->movelist[2].x = player->movelist[1].x - 30 + (rand() % 5) * 15;
			if(player->movelist[2].x < 40)
				player->movelist[2].x = 40;
			else if(player->movelist[2].x > 560)
				player->movelist[2].x = 560;
				
			player->movelist[2].t = 0;
			break;
		}
		case THROW:	
		{
			player->movelist[2].x = 0;
			player->movelist[2].y = 0;
			player->movelist[2].t = 0;
		
			break;
		}
		case CHARGE:
		{
			if(team == HOME)
				player->movelist[2].y = player->movelist[1].y + (rand() % 3) * 15;
			else
				player->movelist[2].y = player->movelist[1].y - (rand() % 3) * 15;
			player->movelist[2].x = player->movelist[1].x - 30 + (rand() % 5) * 15;
			
			if(player->movelist[2].x < 40)
				player->movelist[2].x = 40;
			else if(player->movelist[2].x > 560)
				player->movelist[2].x = 560;

			
			player->movelist[2].t = 0;
			break;
		}		
		case WAIT:
		{
			player->movelist[2].t = (rand() % 4 + 1) * 3;
			player->movelist[2].x = player->movelist[1].x;
			player->movelist[2].y = player->movelist[1].y;
			break;
		}
		default:
		{
			break;
		}
	}

	if(player->movelist[2].action != THROW)
	{
		ctr = (rand() % 10) + player->agg;
		player->movelist[3].action = actionlist[ctr];

		switch(player->movelist[3].action)
		{
			case RUN:
			{
				if(team == HOME)
					player->movelist[3].y = player->movelist[2].y + (rand() % 3) * 15;
				else
					player->movelist[3].y = player->movelist[2].y - (rand() % 3) * 15;
				player->movelist[3].x = player->movelist[2].x - 30 + (rand() % 5) * 15;
				
				if(player->movelist[3].x < 40)
					player->movelist[3].x = 40;
				else if(player->movelist[3].x > 560)
					player->movelist[3].x = 560;
 
				
				player->movelist[3].t = 0;
				break;
			}
			case CHARGE:
			{
				if(team == HOME)
					player->movelist[3].y = player->movelist[2].y + (rand() % 3) * 15;
				else
					player->movelist[3].y = player->movelist[2].y - (rand() % 3) * 15;
				player->movelist[3].x = player->movelist[2].x - 30 + (rand() % 5) * 15;
				
				if(player->movelist[3].x < 40)
					player->movelist[3].x = 40;
				else if(player->movelist[3].x > 560)
					player->movelist[3].x = 560;
				
				player->movelist[3].t = 0;
				break;
			}		
			case WAIT:
			{
				player->movelist[3].t = (rand() % 4 + 1) * 3;
				player->movelist[3].x = player->movelist[2].x;
				player->movelist[3].y = player->movelist[2].y;
				break;
			}
			case THROW:	
			{
				player->movelist[3].x = 0;
				player->movelist[3].y = 0;
				player->movelist[3].t = 0;
			
				break;
			}
			default:
			{
				break;
			}
		}
	}
	else
	{
		player->movelist[3].action = NIL;
		player->movelist[3].x = 0;
		player->movelist[3].y = 0;
		player->movelist[3].t = 0;
	}
	
	if((player->movelist[3].action != THROW) & (player->movelist[3].action != NIL))
	{
		ctr = rand() % 10 + player->agg;
		player->movelist[4].action = actionlist[ctr];

		switch(player->movelist[4].action)
		{
			case RUN:
			{
				if(team == HOME)
					player->movelist[4].y = player->movelist[3].y + (rand() % 3) * 15;
				else
					player->movelist[4].y = player->movelist[3].y - (rand() % 3) * 15;
				player->movelist[4].x = player->movelist[3].x - 30 + (rand() % 5) * 15;
				
				if(player->movelist[4].x < 40)
					player->movelist[4].x = 40;
				else if(player->movelist[4].x > 560)
					player->movelist[4].x = 560;

				player->movelist[4].t = 0;
				break;
			}
			case CHARGE:
			{
				if(team == HOME)
					player->movelist[4].y = player->movelist[3].y + (rand() % 3) * 15;
				else
					player->movelist[4].y = player->movelist[3].y - (rand() % 3) * 15;
				player->movelist[4].x = player->movelist[3].x - 30 + (rand() % 5) * 15;
				
				if(player->movelist[4].x < 40)
					player->movelist[4].x = 40;
				else if(player->movelist[4].x > 560)
					player->movelist[4].x = 560;
				
				player->movelist[4].t = 0;
				break;
			}		
			case WAIT:
			{
				player->movelist[4].t = (rand() % 4 + 1) * 3;
				player->movelist[4].x = player->movelist[3].x;
				player->movelist[4].y = player->movelist[3].y;
				break;
			}
			case THROW:	
			{
				player->movelist[4].x = 0;
				player->movelist[4].y = 0;
				player->movelist[4].t = 0;
			
				break;
			}
			default:
			{
				break;
			}
		}
	}
	else
	{
		player->movelist[4].action = NIL;
		player->movelist[4].x = 0;
		player->movelist[4].y = 0;
		player->movelist[4].t = 0;
	}

	if((player->movelist[4].action != THROW) & (player->movelist[4].action != NIL))
		player->movelist[5].action = THROW;
	else
		player->movelist[5].action = NIL;
	player->movelist[5].x = 0;
	player->movelist[5].y = 0;
	player->movelist[5].t = 0;
			
}

boolean Xoverlap(AREA a, AREA b)
{
	if((b.x > (a.x - b.w)) & (b.x < (a.x + a.w)))
		return TRUE;
	else
		return FALSE;
}

boolean Yoverlap(AREA a, AREA b)
{
	if((b.y > (a.y - a.h)) & (b.y < (a.y + a.h)))
		return TRUE;
	else
		return FALSE;
}

void chasedown(PLAYER * player, AREA a)
{
	AREA aplayer;
	
	aplayer.x = player->x + PX;
	aplayer.y = player->y + PY;
	aplayer.w = PW;
	aplayer.h = PH;
	
	if(Xoverlap(aplayer, a) == TRUE)
	{
		//printf("X overlap\n");
		if(aplayer.y > a.y)
			move(player, UP);
		else
			move(player, DOWN);
	}
	else if (Yoverlap(aplayer, a) == TRUE)
	{
		//printf("Y overlap\n");
		if(aplayer.x > a.x)
			move(player, LEFT);
		else
			move(player, RIGHT);
	}
	else
	{
		if(aplayer.x > a.x)
		{
			if(aplayer.y > a.y)
				move(player, UPLEFT);
			else
				move(player, DOWNLEFT);
		}
		else
		{
			if(aplayer.y > a.y)
				move(player, UPRIGHT);
			else
				move(player, DOWNRIGHT);
		}	
	}
}
