/* $Header: /fridge/cvs/xscorch/sutil/sstr.h,v 1.4 2001/04/12 05:46:50 justins Exp $ */
/*
   
   xscorch - sstr.h           Copyright(c) 2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Improved string manipulation functions
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __sstr_h_included
#define __sstr_h_included


int strcmpn(const char *dest, const char *src);
int strncmpn(const char *dest, const char *src, int size);
char *strncpyn(char *dest, const char *src, int size);
char *strncatn(char *dest, const char *src, int size);
char *snprintfn(char *dest, int size, const char *fmt, ...);
void *memmoven(void *dest, const void *src, int size);
void *memsetn(void *dest, int ch, int size);
void *memcpyn(void *dest, const void *src, int size);
char *serror(int errn);


char *strunescape(char *src);
char *strescape(char *src, int size);
char *strtrim(char *src);
char *strscan(char *src, char ch);
char *strchop(char *src, char ch);


/* For the registry code */
#define  trim(s)              strtrim((s))
#define  escape(s, z)         strescape((s), (z))
#define  escaped_scan(s, c)   strscan((s), (c))
#define  escaped_chop(s, c)   strchop((s), (c))
#define  unescape_quoted(s)   strunescape((s))


#endif /* __sstr_h_included? */
