/* $Header: /fridge/cvs/xscorch/sgtk/swindow-gtk.c,v 1.4 2001/04/07 22:12:46 justins Exp $ */
/*
   
   xscorch - swindow-gtk.c    Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   GTK interface to xscorch
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdio.h>
#include <stdlib.h>
#include <xscorch.h>
#include <sdisplay.h>
#include <sactiveconsole.h>
#include <gdk/gdkkeysyms.h>
#include <sexplosion-gtk.h>
#include <swindow-gtk.h>
#include <simage-gtk.h>
#include <scolor-gtk.h>
#include <smenu-gtk.h>
#include <stank-gtk.h>
#include <ssound/ssound.h>
#include <sgame/splayer.h>
#include <sgame/sstate.h>
#include <sgame/sland.h>
#include <sgame/sgame.h>
#include <sutil/sstr.h>
#include <snet/snet.h>
#include <sdialog.h>



static gint _sc_window_timeout_gtk(gpointer data) {

   sc_window_gtk *w = data;

   /* Execute next state in the state machine */
   sc_state_run(w->c, w->c->game);
   
   /* Run sound updates */
   #if USE_SOUND
      sc_sound_update(w->c->sound);
   #endif /* Sound? */

   /* Leave the timeout in place */
   return(TRUE); 
 
}
 


void sc_window_timer_enable(sc_window *w_) {

   sc_window_gtk *w = (sc_window_gtk *)w_;

   w->timer_id = gtk_timeout_add(SC_SLEEP_TIME, _sc_window_timeout_gtk, w);

}



void sc_window_timer_disable(sc_window *w_) {

   sc_window_gtk *w = (sc_window_gtk *)w_;

   gtk_timeout_remove(w->timer_id);

}



static void _sc_screen_expose_gtk(GtkWidget *widget, GdkEvent *event, gpointer data) {

   sc_window_gtk *w = data;
   
   #if SC_GTK_DEBUG_GTK
      SC_DEBUG_ENTER_();
   #endif /* debug */

   /* Start game if this is our first drawing */
   if(!w->exposed && w->ready) {
      sc_window_timer_enable((sc_window *)w);
      w->exposed = TRUE;
   }

   #if SC_GTK_DEBUG_GTK
      SC_DEBUG_EXIT_();
   #endif /* debug */

}



static gint _sc_delete_event_gtk(GtkWidget *app, GdkEventAny *event, gpointer data) {

   #if SC_GTK_DEBUG_GTK
      SC_DEBUG_ENTER_();
   #endif /* debug */

   gtk_main_quit();

   #if SC_GTK_DEBUG_GTK
      SC_DEBUG_EXIT_();
   #endif /* debug */

   return(TRUE);

}



static gboolean _sc_window_keypress_gtk(GtkWidget *widget, GdkEventKey *key, gpointer data) {

   sc_window_gtk *w = data;
   sc_player *curplayer = w->c->plorder[w->c->game->curplayer];

   #if SC_GTK_DEBUG_GTK
      SC_DEBUG_ENTER("%d (%s)  xx", key->keyval, gdk_keyval_name(key->keyval));
   #endif /* debug */

   /* Main game */
   if(SC_STATE_IS_ENABLED(w->c->game) && !SC_STATE_IS_PAUSE(w->c->game)) switch(key->keyval) {
      case GDK_Tab:
         sc_player_advance_weapon(w->c, curplayer, key->state & GDK_SHIFT_MASK ? -1 : 1);
         return(TRUE);
      case GDK_Up:
      case GDK_KP_Up:
         sc_player_advance_power(w->c, curplayer, (key->state & GDK_SHIFT_MASK) ? SC_PLAYER_POWER_STEP : SC_PLAYER_POWER_BIGSTEP);
         return(TRUE);
      case GDK_Down:
      case GDK_KP_Down:
         sc_player_advance_power(w->c, curplayer, -((key->state & GDK_SHIFT_MASK) ? SC_PLAYER_POWER_STEP : SC_PLAYER_POWER_BIGSTEP));
         return(TRUE);
      case GDK_Right:
      case GDK_KP_Right:
         sc_player_advance_turret(w->c, curplayer, -((key->state & GDK_SHIFT_MASK) ? SC_PLAYER_TURRET_STEP : SC_PLAYER_TURRET_BIGSTEP));
         return(TRUE);
      case GDK_Left:
      case GDK_KP_Left:
         sc_player_advance_turret(w->c, curplayer, (key->state & GDK_SHIFT_MASK) ? SC_PLAYER_TURRET_STEP : SC_PLAYER_TURRET_BIGSTEP);
         return(TRUE);
      case GDK_F:
      case GDK_f:
         sc_window_tank_move_gtk(w, curplayer);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_R:
      case GDK_r:
         sc_window_paint((sc_window *)w, 0, 0, w->c->fieldwidth, w->c->fieldheight, SC_PAINT_EVERYTHING);
         return(TRUE);
      case GDK_S:
      case GDK_s:
         sc_player_activate_shield(w->c, curplayer);
         return(TRUE);
      case GDK_T:
      case GDK_t:
         sc_player_set_contact_triggers(w->c, curplayer, !curplayer->contacttriggers);
         return(TRUE);
      case GDK_1:
      case GDK_KP_1:
         if(w->c->numplayers < 1) return(FALSE);
         sc_window_tank_info_gtk(w, w->c->players[0]);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_2:
      case GDK_KP_2:
         if(w->c->numplayers < 2) return(FALSE);
         sc_window_tank_info_gtk(w, w->c->players[1]);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_3:
      case GDK_KP_3:
         if(w->c->numplayers < 3) return(FALSE);
         sc_window_tank_info_gtk(w, w->c->players[2]);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_4:
      case GDK_KP_4:
         if(w->c->numplayers < 4) return(FALSE);
         sc_window_tank_info_gtk(w, w->c->players[3]);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_5:
      case GDK_KP_5:
         if(w->c->numplayers < 5) return(FALSE);
         sc_window_tank_info_gtk(w, w->c->players[4]);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_6:
      case GDK_KP_6:
         if(w->c->numplayers < 6) return(FALSE);
         sc_window_tank_info_gtk(w, w->c->players[5]);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_7:
      case GDK_KP_7:
         if(w->c->numplayers < 7) return(FALSE);
         sc_window_tank_info_gtk(w, w->c->players[6]);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_8:
      case GDK_KP_8:
         if(w->c->numplayers < 8) return(FALSE);
         sc_window_tank_info_gtk(w, w->c->players[7]);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_9:
      case GDK_KP_9:
         if(w->c->numplayers < 9) return(FALSE);
         sc_window_tank_info_gtk(w, w->c->players[8]);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_0:
      case GDK_KP_0:
         if(w->c->numplayers < 10) return(FALSE);
         sc_window_tank_info_gtk(w, w->c->players[9]);
         sc_game_pause(w->c, w->c->game);
         return(TRUE);
      case GDK_Return:
      case GDK_KP_Enter:
         sc_game_set_state_now(w->c, w->c->game, SC_STATE_TURN_PL_DONE);
         return(TRUE);

   }

   return(FALSE);

}



static bool _sc_load_images(sc_window_gtk *w) {

   const char *filename;

   filename = SC_GLOBAL_DIR "/" SC_IMAGE_DIR "/xscorch-logo.xpm";
   w->logo = gdk_pixmap_colormap_create_from_xpm(w->app->window, NULL, 
                                                 &w->logo_m, NULL, 
                                                 filename);
   if(w->logo == NULL) {
      fprintf(stderr, "Cannot load \"%s\", aborting.\n", filename);
      return(false);
   }

   filename = SC_GLOBAL_DIR "/" SC_IMAGE_DIR "/xscorch-icon.xpm";
   w->icon = gdk_pixmap_colormap_create_from_xpm(w->app->window, NULL, 
                                                 &w->icon_m, NULL, 
                                                 filename);
   if(w->icon == NULL) {
      fprintf(stderr, "Cannot load \"%s\", aborting.\n", filename);
      return(false);
   }

   return(true);

}



sc_window *sc_window_new(sc_config *c, int argc, char **argv) {

   sc_window_gtk *w;
   GtkWidget *cont;
   GdkColor black;
   gint   fake_argc = 1;
   gchar* fake_argv[] = { "xscorch", NULL };
   char **fake_argv_p;
   
   /* initialise GTK */
   fake_argv_p = fake_argv;
   gtk_init(&fake_argc, &fake_argv_p);
   
   /* Initialise w */   
   w = g_new0(sc_window_gtk, 1);
   c->window = (sc_window *)w;
   w->exposed = FALSE;
   w->ready = FALSE;
   w->chatbox = NULL;
   w->c = c;

   /* Create the window */      
   w->app = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title(GTK_WINDOW(w->app), "XScorch");
   gtk_signal_connect(GTK_OBJECT(w->app), "delete_event", GTK_SIGNAL_FUNC(_sc_delete_event_gtk), w);
   gtk_window_set_policy(GTK_WINDOW(w->app), FALSE, FALSE, TRUE);

   /* Create the main (vertical) container */
   cont = gtk_vbox_new(FALSE, 0);
   gtk_container_border_width(GTK_CONTAINER(cont), 1);
   gtk_container_add(GTK_CONTAINER(w->app), cont);

   /* Create menus, etc */
   sc_window_create_menus_gtk(w);
   gtk_box_pack_start(GTK_BOX(cont), w->mainmenu, TRUE, TRUE, 0);
   
   /* Next comes the top statusbar */
   w->status = sc_active_console_new(0, 0, 1, 1, CONSOLE_BORDERLESS);
   sc_status_setup((sc_window *)w);
   gtk_box_pack_start(GTK_BOX(cont), w->status, FALSE, TRUE, 0);

   /* Create drawable screen area */
   /*w->border = sc_display_new(w->c->fieldwidth + 4, w->c->fieldheight + 4);
   gtk_box_pack_start(GTK_BOX(cont), w->border, TRUE, TRUE, 0);*/
   w->screen = sc_display_new(w->c->fieldwidth, w->c->fieldheight);
   gtk_signal_connect(GTK_OBJECT(sc_display_get_drawbuf(SC_DISPLAY(w->screen))), "expose_event", GTK_SIGNAL_FUNC(_sc_screen_expose_gtk), w);
   /*gtk_fixed_put(GTK_FIXED(w->border), w->screen, 2, 2);*/
   gtk_box_pack_start(GTK_BOX(cont), w->screen, TRUE, TRUE, 0);
   
   /* Please initialise the colormaps */
   w->colormap = sc_colormap_new_gtk();
   sc_colormap_alloc_colors_gtk(w);
   
   /* Show everything */
   gtk_widget_show_all(w->app);

   /* Setup display background color */
   gdk_color_black(gtk_widget_get_colormap(w->screen), &black);
   gdk_window_set_background(w->screen->window, &black);
   /*gdk_window_set_background(w->border->window, &black);*/
                              
   /* Setup the offscreen land buffer */
   w->landbuffer = gdk_pixmap_new(w->app->window, w->c->fieldwidth, w->c->fieldheight, -1);
   
   /* Setup explosion cache */
   w->explcache = sc_expl_cache_new_gtk();
   
   /* Load the images */
   if(!_sc_load_images(w)) return(NULL);
   gdk_window_set_icon(w->app->window, NULL, w->icon, w->icon_m);
   w->ready = TRUE;
   
   /* connect after loading, just to retain sanity. */
   gtk_signal_connect(GTK_OBJECT(w->app), "key_press_event", GTK_SIGNAL_FUNC(_sc_window_keypress_gtk), w);

   /* Return the structure */
   return((sc_window *)w);

}



void sc_window_free(sc_window **w_) {

   sc_window_gtk *w = (sc_window_gtk *)(*w_);

   if(w->landbuffer != NULL) gdk_pixmap_unref(w->landbuffer);

   gtk_widget_destroy(w->app);
   w->c->window = NULL;
   sc_colormap_free_gtk(&w->colormap);
   sc_expl_cache_free_gtk(&w->explcache);
   free(w);

   *w_ = NULL;

}



void sc_window_run(sc_window *w_) {

   sc_window_gtk *w = (sc_window_gtk *)w_;
   
   if(w == NULL) return;
   gtk_main();
   return;

}



void sc_window_idle(sc_window *w_) {

   if(w_ == NULL) return;
   while (gtk_events_pending()) gtk_main_iteration();

}



void sc_window_message(sc_window *w_, const char *title, const char *msg) {

   sc_dialog_message(title, msg);

}



void sc_window_update(sc_window *w_) {

   sc_window_gtk *w = (sc_window_gtk *)w_;
   sc_window_update_menus_gtk(w);

}



void sc_window_resize(sc_window *w_) {

   sc_window_gtk *w = (sc_window_gtk *)w_;
   sc_config *c = w->c;

   /* There went the landbuffer... */
   if(w->landbuffer != NULL) gdk_pixmap_unref(w->landbuffer);
   w->landbuffer = gdk_pixmap_new(w->app->window, c->fieldwidth, c->fieldheight, -1);
         
   /*  We just seriously fsck'd things up  */
   gtk_widget_set_usize(sc_display_get_drawbuf(SC_DISPLAY(w->screen)), c->fieldwidth, c->fieldheight);
   sc_status_setup(c->window);
   sc_window_idle(c->window);
      
   /* Redraw everything */
   sc_land_generate(c, c->land);
   sc_window_paint(c->window, 0, 0, c->land->width, c->land->height, SC_REGENERATE_LAND | SC_REDRAW_LAND);
   sc_pixmap_copy_gtk(sc_display_get_buffer(SC_DISPLAY(w->screen)), sc_display_get_gc(SC_DISPLAY(w->screen)), w->logo, w->logo_m, c->land->width - sc_pixmap_width_gtk(w->logo), c->land->height - sc_pixmap_height_gtk(w->logo));
                     
}
