/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/sactiveconsole.h,v 1.2 2001/04/07 19:46:50 justins Exp $ */
/*
   
   xscorch - sactiveconsole.h Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Display an active console (a console with "hotspots")
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __sactiveconsole_h_included
#define __sactiveconsole_h_included


#include <gtk/gtk.h>
#include <sconsole.h>


#define  SC_ACTIVE_CONSOLE(obj)         GTK_CHECK_CAST(obj, sc_active_console_get_type(), ScActiveConsole)
#define  SC_ACTIVE_CONSOLE_CLASS(klass) GTK_CHECK_CLASS_CAST(klass, sc_active_console_get_type(), ScActiveConsoleClass)
#define  IS_SC_ACTIVE_CONSOLE(obj)      GTK_CHECK_TYPE(obj, sc_active_console_get_type())


typedef struct _ScActiveConsoleSpot {
   gint x;
   gint y;
   gint width;
   gint height;
   gpointer data;
} ScActiveConsoleSpot;


typedef struct _ScActiveConsole {
   ScConsole console;
   GList *spots;
   GList *current;
   gboolean allowreturn;
} ScActiveConsole;


typedef struct _ScActiveConsoleClass {
   ScConsoleClass parent_class;
   void (*activate)(ScActiveConsole *cons);
   gboolean (*button_press_spot)(ScActiveConsole *cons, ScActiveConsoleSpot *spot, GdkEventButton *event);
   gboolean (*button_release_spot)(ScActiveConsole *cons, ScActiveConsoleSpot *spot, GdkEventButton *event);
   gboolean (*key_press_spot)(ScActiveConsole *cons, ScActiveConsoleSpot *spot, GdkEventKey *event);
   gboolean (*key_release_spot)(ScActiveConsole *cons, ScActiveConsoleSpot *spot, GdkEventKey *event);
   gboolean (*select_spot)(ScActiveConsole *cons, ScActiveConsoleSpot *spot);
} ScActiveConsoleClass;


GtkType sc_active_console_get_type(void);
GtkWidget *sc_active_console_new(gint x, gint y, gint width, gint height, ScConsoleStyle style);
void sc_active_console_init(ScActiveConsole *cons, gint x, gint y, gint width, gint height, ScConsoleStyle style);


void sc_active_console_add_spot(ScActiveConsole *cons, gint x, gint y, gint width, gint height, gpointer data);
void sc_active_console_add_row_spot(ScActiveConsole *cons, gint row, gpointer data);


#endif /* __sactiveconsole_h_included */
