/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/sactiveconsole.c,v 1.2 2001/04/07 19:46:50 justins Exp $ */
/*
   
   xscorch - sactiveconsole.c Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Display an active console
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdlib.h>
#include <sactiveconsole.h>
#include <gdk/gdkkeysyms.h>
#include <sgtk.h>



static ScConsoleClass *parent_class;



enum _ScMenuConsoleSignals {
   ACTIVATE_SIGNAL,
   SELECT_SPOT_SIGNAL,
   BUTTON_PRESS_SPOT_SIGNAL,
   BUTTON_RELEASE_SPOT_SIGNAL,
   KEY_PRESS_SPOT_SIGNAL,
   KEY_RELEASE_SPOT_SIGNAL,
   LAST_SIGNAL
};
static gint _sc_active_console_signals[LAST_SIGNAL] = { 0 };



typedef gboolean (*GtkSignal_BOOL__POINTER_POINTER)(GtkObject *, gpointer, gpointer, gpointer);
static void _sc_marshal_BOOL__POINTER_POINTER(GtkObject *object, GtkSignalFunc func, gpointer func_data, GtkArg *args) {

   GtkSignal_BOOL__POINTER_POINTER rfunc;
   gboolean *return_val;
   return_val = GTK_RETLOC_BOOL(args[2]);
   rfunc = (GtkSignal_BOOL__POINTER_POINTER)func;
   *return_val = (*rfunc)(object, GTK_VALUE_POINTER(args[0]), GTK_VALUE_POINTER(args[1]), func_data);

}
 
 
 
static void _sc_active_console_destroy(GtkObject *obj) {

   ScActiveConsole *cons = SC_ACTIVE_CONSOLE(obj);
   GList *cur = cons->spots;

   while(cur != NULL) {
      if(cur->data != NULL) free(cur->data);
      cur->data = NULL;
      cur = cur->next;
   }
   g_list_free(cons->spots);
   
   /* Call parent handler? */
   if(GTK_OBJECT_CLASS(parent_class)->destroy != NULL) {
      GTK_OBJECT_CLASS(parent_class)->destroy(obj);
   } /* Parent handler */

}



static void _sc_active_console_activate(ScActiveConsole *cons) {

   ScActiveConsoleSpot *spot;
   gboolean rtnval = FALSE;

   if(cons->current == NULL) return;
   spot = cons->current->data;
   gtk_signal_emit(GTK_OBJECT(cons), _sc_active_console_signals[SELECT_SPOT_SIGNAL], spot, &rtnval);

}



static gint _sc_active_console_key_press(GtkWidget *widget, GdkEventKey *event) {

   ScActiveConsole *cons = SC_ACTIVE_CONSOLE(widget);
   ScActiveConsoleSpot *spot;
   gboolean rtnval = FALSE;
   
   /* Try out parent handler first */
   if(GTK_WIDGET_CLASS(parent_class)->key_press_event != NULL) {
      if(GTK_WIDGET_CLASS(parent_class)->key_press_event(widget, event)) {
         /* Crap. The signal's already been handled */
         return(TRUE);
      } /* Signal processed? */
   } /* Signal handler available? */

   if(cons->current == NULL) return(FALSE);
   
   #if SC_GTK_DEBUG_GTK
      SC_DEBUG_ENTER("key is %d (%s)   xx", event->keyval, gdk_keyval_name(event->keyval));
   #endif /* debug */
   
   switch(event->keyval) {
      case GDK_Up:
      case GDK_KP_Up:
         cons->current = cons->current->prev;
         if(cons->current == NULL) {
            cons->current = g_list_last(cons->spots);
         }
         spot = cons->current->data;
         sc_console_set_cursor(SC_CONSOLE(cons), spot->x, spot->y, spot->width, spot->height);
         return(TRUE);
         
      case GDK_Down:
      case GDK_KP_Down:
         cons->current = cons->current->next;
         if(cons->current == NULL) {
            cons->current = cons->spots;
         }
         spot = cons->current->data;
         sc_console_set_cursor(SC_CONSOLE(cons), spot->x, spot->y, spot->width, spot->height);
         return(TRUE);
         
      case GDK_Return:
      case GDK_KP_Enter:
         #if SC_GTK_DEBUG_GTK
            SC_DEBUG_ENTER("asked for return%s", "");
         #endif /* debug */
         if(!cons->allowreturn) {
            spot = cons->current->data;
            #if SC_GTK_DEBUG_GTK
               SC_DEBUG_ENTER("emitting %d", _sc_active_console_signals[KEY_PRESS_SPOT_SIGNAL]);
            #endif /* debug */
            gtk_signal_emit(GTK_OBJECT(cons), _sc_active_console_signals[KEY_PRESS_SPOT_SIGNAL], spot, event, &rtnval);
            #if SC_GTK_DEBUG_GTK
               SC_DEBUG_ENTER("emitted w/ result %d", rtnval);
            #endif /* debug */
            if(rtnval) return(TRUE);
         }
      
      case GDK_space:
      case GDK_KP_Space:
         spot = cons->current->data;
         #if SC_GTK_DEBUG_GTK
            SC_DEBUG_ENTER("emitting %d", _sc_active_console_signals[SELECT_SPOT_SIGNAL]);
         #endif /* debug */
         gtk_signal_emit(GTK_OBJECT(cons), _sc_active_console_signals[SELECT_SPOT_SIGNAL], spot, &rtnval);
         #if SC_GTK_DEBUG_GTK
            SC_DEBUG_ENTER("emitted w/ result %d", rtnval);
         #endif /* debug */
         if(rtnval) return(TRUE);
         break;

      default:
         spot = cons->current->data;
         #if SC_GTK_DEBUG_GTK
            SC_DEBUG_ENTER("emitting %d", _sc_active_console_signals[KEY_PRESS_SPOT_SIGNAL]);
         #endif /* debug */
         gtk_signal_emit(GTK_OBJECT(cons), _sc_active_console_signals[KEY_PRESS_SPOT_SIGNAL], spot, event, &rtnval);
         #if SC_GTK_DEBUG_GTK
            SC_DEBUG_ENTER("emitted w/ result %d", rtnval);
         #endif /* debug */
         if(rtnval) return(TRUE);
         break;
   }

   return(FALSE);

}



static gint _sc_active_console_key_release(GtkWidget *widget, GdkEventKey *event) {

   ScActiveConsole *cons = SC_ACTIVE_CONSOLE(widget);
   ScActiveConsoleSpot *spot;
   gboolean rtnval = FALSE;

   /* Try out parent handler first */
   if(GTK_WIDGET_CLASS(parent_class)->key_release_event != NULL) {
      if(GTK_WIDGET_CLASS(parent_class)->key_release_event(widget, event)) {
         /* Crap. The signal's already been handled */
         return(TRUE);
      } /* Signal processed? */
   } /* Signal handler available? */

   if(cons->current == NULL) return(FALSE);
   
   #if SC_GTK_DEBUG_GTK
      SC_DEBUG_ENTER("key is %d (%s)   xx", event->keyval, gdk_keyval_name(event->keyval));
   #endif /* debug */
   
   switch(event->keyval) {
      case GDK_Up:
      case GDK_KP_Up:
      case GDK_Down:
      case GDK_KP_Down:
      case GDK_space:
      case GDK_KP_Space:
         #if SC_GTK_DEBUG_GTK
            SC_DEBUG_ENTER("ignored%s", "");
         #endif /* debug */
         return(TRUE);

      default:
         spot = cons->current->data;
         #if SC_GTK_DEBUG_GTK
            SC_DEBUG_ENTER("emitting %d", _sc_active_console_signals[KEY_RELEASE_SPOT_SIGNAL]);
         #endif /* debug */
         gtk_signal_emit(GTK_OBJECT(cons), _sc_active_console_signals[KEY_RELEASE_SPOT_SIGNAL], spot, event, &rtnval);
         #if SC_GTK_DEBUG_GTK
            SC_DEBUG_ENTER("emitted w/ result %d", rtnval);
         #endif /* debug */
         if(rtnval) return(TRUE);
         break;
   }

   return(FALSE);

}



static gint _sc_active_console_button_press(GtkWidget *widget, GdkEventButton *event) {

   ScActiveConsole *cons = SC_ACTIVE_CONSOLE(widget);
   ScActiveConsoleSpot *spot;
   gboolean rtnval = FALSE;
   gint currow;
   gint curcol;
   GList *cur;

   /* Try out parent handler first */
   if(GTK_WIDGET_CLASS(parent_class)->button_press_event != NULL) {
      if(GTK_WIDGET_CLASS(parent_class)->button_press_event(widget, event)) {
         /* Crap. The signal's already been handled */
         return(TRUE);
      } /* Signal processed? */
   } /* Signal handler available? */

   gtk_widget_grab_focus(GTK_WIDGET(cons));
   if(cons->current == NULL) return(FALSE);

   currow = event->y / sc_console_get_row_height(SC_CONSOLE(cons));
   curcol = event->x / sc_console_get_col_width(SC_CONSOLE(cons));
   if(SC_CONSOLE(cons)->style != CONSOLE_BORDERLESS) {
      currow -= 1;
      curcol -= 2;
   }
   cur = cons->spots;
   while(cur != NULL) {
      spot = cur->data;
      if(curcol >= spot->x && curcol < spot->x + spot->width &&
       currow >= spot->y && currow < spot->y + spot->height) {
         cons->current = cur;
         sc_console_set_cursor(SC_CONSOLE(cons), spot->x, spot->y, spot->width, spot->height);
         sc_console_set_cursor_highlighted(SC_CONSOLE(cons), TRUE);
         gtk_signal_emit(GTK_OBJECT(cons), _sc_active_console_signals[BUTTON_PRESS_SPOT_SIGNAL], spot, event, &rtnval);
         return(TRUE);
      }
      cur = cur->next;
   }

   return(FALSE);

}



static gint _sc_active_console_button_release(GtkWidget *widget, GdkEventButton *event) {

   ScActiveConsole *cons = SC_ACTIVE_CONSOLE(widget);
   ScActiveConsoleSpot *spot;
   gboolean rtnval = FALSE;
   gint currow;
   gint curcol;
   GList *cur;

   /* Try out parent handler first */
   if(GTK_WIDGET_CLASS(parent_class)->button_release_event != NULL) {
      if(GTK_WIDGET_CLASS(parent_class)->button_release_event(widget, event)) {
         /* Crap. The signal's already been handled */
         return(TRUE);
      } /* Signal processed? */
   } /* Signal handler available? */

   gtk_widget_grab_focus(GTK_WIDGET(cons));
   if(cons->current == NULL) return(FALSE);

   spot = cons->current->data;
   sc_console_set_cursor(SC_CONSOLE(cons), spot->x, spot->y, spot->width, spot->height);
   sc_console_set_cursor_highlighted(SC_CONSOLE(cons), FALSE);

   currow = event->y / sc_console_get_row_height(SC_CONSOLE(cons));
   curcol = event->x / sc_console_get_col_width(SC_CONSOLE(cons));
   if(SC_CONSOLE(cons)->style != CONSOLE_BORDERLESS) {
      currow -= 1;
      curcol -= 2;
   }
   cur = cons->spots;
   while(cur != NULL) {
      spot = cur->data;
      if(curcol >= spot->x && curcol < spot->x + spot->width &&
       currow >= spot->y && currow < spot->y + spot->height) {
         if(cons->current == cur) {
            gtk_signal_emit(GTK_OBJECT(cons), _sc_active_console_signals[SELECT_SPOT_SIGNAL], spot, &rtnval);
            if(rtnval) return(TRUE);
         }
         gtk_signal_emit(GTK_OBJECT(cons), _sc_active_console_signals[BUTTON_RELEASE_SPOT_SIGNAL], spot, event, &rtnval);
         return(TRUE);
      }
      cur = cur->next;
   }

   return(FALSE);

}



static void _sc_active_console_class_init(ScActiveConsoleClass *klass) {

   GtkObjectClass *object_class = (GtkObjectClass *)klass;
   
   parent_class = gtk_type_class(sc_console_get_type());
   
   _sc_active_console_signals[ACTIVATE_SIGNAL] = 
      gtk_signal_new("activate", 
                     GTK_RUN_FIRST | GTK_RUN_ACTION, 
                     object_class->type, 
                     GTK_SIGNAL_OFFSET(ScActiveConsoleClass, activate), 
                     gtk_marshal_NONE__NONE,
                     GTK_TYPE_NONE, 0);
   _sc_active_console_signals[SELECT_SPOT_SIGNAL] = 
      gtk_signal_new("select_spot", 
                     GTK_RUN_LAST, 
                     object_class->type, 
                     GTK_SIGNAL_OFFSET(ScActiveConsoleClass, select_spot), 
                     gtk_marshal_BOOL__POINTER, 
                     GTK_TYPE_BOOL, 1, GTK_TYPE_POINTER);
   _sc_active_console_signals[BUTTON_PRESS_SPOT_SIGNAL] = 
      gtk_signal_new("button_press_spot", 
                     GTK_RUN_LAST, 
                     object_class->type, 
                     GTK_SIGNAL_OFFSET(ScActiveConsoleClass, button_press_spot), 
                     _sc_marshal_BOOL__POINTER_POINTER,
                     GTK_TYPE_BOOL, 2, GTK_TYPE_GDK_EVENT, GTK_TYPE_POINTER);
   _sc_active_console_signals[BUTTON_RELEASE_SPOT_SIGNAL] = 
      gtk_signal_new("button_release_spot", 
                     GTK_RUN_LAST, 
                     object_class->type, 
                     GTK_SIGNAL_OFFSET(ScActiveConsoleClass, button_release_spot), 
                     _sc_marshal_BOOL__POINTER_POINTER,
                     GTK_TYPE_BOOL, 2, GTK_TYPE_GDK_EVENT, GTK_TYPE_POINTER);
   _sc_active_console_signals[KEY_PRESS_SPOT_SIGNAL] = 
      gtk_signal_new("key_press_spot", 
                     GTK_RUN_LAST, 
                     object_class->type, 
                     GTK_SIGNAL_OFFSET(ScActiveConsoleClass, key_press_spot), 
                     _sc_marshal_BOOL__POINTER_POINTER,
                     GTK_TYPE_BOOL, 2, GTK_TYPE_GDK_EVENT, GTK_TYPE_POINTER);
   _sc_active_console_signals[KEY_RELEASE_SPOT_SIGNAL] = 
      gtk_signal_new("key_release_spot", 
                     GTK_RUN_LAST, 
                     object_class->type, 
                     GTK_SIGNAL_OFFSET(ScActiveConsoleClass, key_release_spot), 
                     _sc_marshal_BOOL__POINTER_POINTER,
                     GTK_TYPE_BOOL, 2, GTK_TYPE_GDK_EVENT, GTK_TYPE_POINTER);

   ((GtkWidgetClass *)klass)->activate_signal = _sc_active_console_signals[ACTIVATE_SIGNAL];

   gtk_object_class_add_signals(object_class, _sc_active_console_signals, LAST_SIGNAL);

   /* Setup new signal default handlers */
   klass->activate            = _sc_active_console_activate;
   klass->select_spot         = NULL;
   klass->button_press_spot   = NULL;
   klass->button_release_spot = NULL;
   klass->key_press_spot      = NULL;
   klass->key_release_spot    = NULL;
   
   /* Install signals from parent class */
   GTK_WIDGET_CLASS(klass)->key_press_event     = _sc_active_console_key_press;
   GTK_WIDGET_CLASS(klass)->key_release_event   = _sc_active_console_key_release;
   GTK_WIDGET_CLASS(klass)->button_press_event  = _sc_active_console_button_press;
   GTK_WIDGET_CLASS(klass)->button_release_event= _sc_active_console_button_release;
   GTK_OBJECT_CLASS(klass)->destroy             = _sc_active_console_destroy;
   
}



static void _sc_active_console_init_obj(ScActiveConsole *cons) {
   
   cons->spots = NULL;
   cons->current = NULL;
   
   GTK_WIDGET_SET_FLAGS(GTK_WIDGET(cons), GTK_CAN_DEFAULT);
   gtk_widget_set_events(GTK_WIDGET(cons), GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);
   
}



GtkType sc_active_console_get_type(void) {

   static GtkType sc_active_console_type = 0;
   
   if(sc_active_console_type == 0) {
      static const GtkTypeInfo sc_active_console_info = {
         (char *)"ScActiveConsole",
         sizeof(ScActiveConsole),
         sizeof(ScActiveConsoleClass),
         (GtkClassInitFunc)_sc_active_console_class_init,
         (GtkObjectInitFunc)_sc_active_console_init_obj,
         (GtkArgSetFunc)NULL,
         (GtkArgGetFunc)NULL
      };
      sc_active_console_type = gtk_type_unique(sc_console_get_type(), &sc_active_console_info);
   }

   return(sc_active_console_type);

}



void sc_active_console_init(ScActiveConsole *cons, gint x, gint y, gint width, gint height, ScConsoleStyle style) {

   cons->current = NULL;
   cons->allowreturn = TRUE;
   sc_console_init(SC_CONSOLE(cons), x, y, width, height, style);
   sc_console_set_cursor(SC_CONSOLE(cons), 0, 0, 1, 1);
   gtk_widget_set_sensitive(GTK_WIDGET(cons), TRUE);

}



GtkWidget *sc_active_console_new(gint x, gint y, gint width, gint height, ScConsoleStyle style) {

   ScActiveConsole *cons;

   cons = gtk_type_new(sc_active_console_get_type());
   g_return_val_if_fail(cons != NULL, NULL);

   sc_active_console_init(cons, x, y, width, height, style);
   return(GTK_WIDGET(cons));

}



void sc_active_console_add_spot(ScActiveConsole *cons, gint x, gint y, gint width, gint height, gpointer data) {

   ScActiveConsoleSpot *spot;
   
   spot = (ScActiveConsoleSpot *)malloc(sizeof(ScActiveConsoleSpot));
   if(spot == NULL) return;
   
   spot->x = x;
   spot->y = y;
   spot->width = width;
   spot->height= height;
   spot->data  = data;
   
   cons->spots = g_list_append(cons->spots, spot);
   if(cons->current == NULL) {
      cons->current = cons->spots;
      sc_console_set_cursor(SC_CONSOLE(cons), x, y, width, height);
   }
   
}



void sc_active_console_add_row_spot(ScActiveConsole *cons, gint row, gpointer data) {

   sc_active_console_add_spot(cons, 0, row, sc_console_get_width(SC_CONSOLE(cons)), 1, data);

}
