/* $Header: /fridge/cvs/xscorch/sgtk/stank-gtk.c,v 1.3 2001/04/07 22:12:46 justins Exp $ */
/*
   
   xscorch - stank-gtk.c      Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Tank configuration screen
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdlib.h>
#include <stdio.h>   
#include <math.h>
#include <xscorch.h>
#include <sdisplay.h>
#include <sactiveconsole.h>
#include <gdk/gdkkeysyms.h>
#include <swindow-gtk.h>
#include <scolor-gtk.h>
#include <sgame/saccessory.h>
#include <sgame/sinventory.h>
#include <sgame/seconomy.h>
#include <sgame/sweapon.h>
#include <sgame/sshield.h>
#include <sgame/splayer.h>
#include <sgame/sgame.h>
#include <sutil/sstr.h>



static gboolean _sc_window_tank_close_gtk(GtkWidget *widget, ScActiveConsoleSpot *spot, sc_window_gtk *w) {

   sc_display_console_detach_all(SC_DISPLAY(w->screen));
   sc_game_unpause(w->c, w->c->game);
   return(TRUE);

}



void sc_window_tank_info_gtk(sc_window_gtk *w, sc_player *p) {

   char buf[SC_GTK_STRING_BUFFER];
   GtkWidget *console;

   console = sc_active_console_new(8, 4, 46, 7, CONSOLE_NORMAL);
   sc_console_set_foreground(SC_CONSOLE(console), &w->colormap->pcolors[p->index]);

   sc_console_write_line(SC_CONSOLE(console), 36, 6, "< Close >");
   sc_active_console_add_spot(SC_ACTIVE_CONSOLE(console), 36, 6, 9, 1, NULL);
   gtk_signal_connect_after(GTK_OBJECT(console), "select-spot", GTK_SIGNAL_FUNC(_sc_window_tank_close_gtk), w);
   
   snprintfn(buf, sizeof(buf), "%2d: %s (%s)", 
             p->index + 1, p->name, sc_ai_name(p->aitype));
   sc_console_write_line(SC_CONSOLE(console), 0, 0, buf);
   snprintfn(buf, sizeof(buf), "    Life:     %5d     Shield:  %d", 
             p->life, p->shield == NULL ? 0 : p->shield->life);
   sc_console_write_line(SC_CONSOLE(console), 0, 1, buf);
   snprintfn(buf, sizeof(buf), "    Wins:     %d         Kills:   %d", 
             p->numwins, p->kills);
   sc_console_write_line(SC_CONSOLE(console), 0, 2, buf);
   snprintfn(buf, sizeof(buf), "    Suicides: %d", 
             p->suicides);
   sc_console_write_line(SC_CONSOLE(console), 0, 3, buf);
   snprintfn(buf, sizeof(buf), "    Money:    $%-8d %c$%d this round", 
             p->money, p->money > p->oldmoney ? '+' : '-', p->money - p->oldmoney);
   sc_console_write_line(SC_CONSOLE(console), 0, 4, buf);
   snprintfn(buf, sizeof(buf), "Press [Enter] to close");
   sc_console_write_line(SC_CONSOLE(console), 0, 5, buf);

   sc_display_console_attach(SC_DISPLAY(w->screen), SC_CONSOLE(console));
   #if !SC_GTK_DEBUG_DISABLE_DEFAULT   
      gtk_window_set_default(GTK_WINDOW(w->app), console);
   #endif /* debug */
   
   sc_game_pause(w->c, w->c->game);

}



static gboolean _sc_window_tank_move_btn_gtk(GtkWidget *widget, ScActiveConsoleSpot *spot, sc_window_gtk *w) {

   char buf[SC_GTK_STRING_BUFFER];
   int fuel;

   switch((int)spot->data) {
      case 1:
         if(sc_player_move(w->c, w->c->plorder[w->c->game->curplayer], -1)) {
            fuel = sc_player_total_fuel(w->c->accessories, w->c->plorder[w->c->game->curplayer]);
            snprintfn(buf, sizeof(buf), "%4d", fuel);
            sc_console_write_line(SC_CONSOLE(widget), 22, 0, buf);
         }
         return(TRUE);
      case 2:
         if(sc_player_move(w->c, w->c->plorder[w->c->game->curplayer], +1)) {
            fuel = sc_player_total_fuel(w->c->accessories, w->c->plorder[w->c->game->curplayer]);
            snprintfn(buf, sizeof(buf), "%4d", fuel);
            sc_console_write_line(SC_CONSOLE(widget), 22, 0, buf);
         }
         return(TRUE);
      case 3:
         sc_display_console_detach_all(SC_DISPLAY(w->screen));
         sc_game_unpause(w->c, w->c->game);
         return(TRUE);
   }
   return(FALSE);

}



static gboolean _sc_window_tank_move_key_gtk(GtkWidget *widget, ScActiveConsoleSpot *spot, GdkEventKey *key, sc_window_gtk *w) {

   char buf[SC_GTK_STRING_BUFFER];
   int fuel;

   switch(key->keyval) {
      case GDK_Left:
      case GDK_KP_Left:
         if(sc_player_move(w->c, w->c->plorder[w->c->game->curplayer], -1)) {
            fuel = sc_player_total_fuel(w->c->accessories, w->c->plorder[w->c->game->curplayer]);
            snprintfn(buf, sizeof(buf), "%4d", fuel);
            sc_console_write_line(SC_CONSOLE(widget), 22, 0, buf);
         }
         return(TRUE);
      case GDK_Right:
      case GDK_KP_Right:
         if(sc_player_move(w->c, w->c->plorder[w->c->game->curplayer], +1)) {
            fuel = sc_player_total_fuel(w->c->accessories, w->c->plorder[w->c->game->curplayer]);
            snprintfn(buf, sizeof(buf), "%4d", fuel);
            sc_console_write_line(SC_CONSOLE(widget), 22, 0, buf);
         }
         return(TRUE);
      case GDK_Return:
      case GDK_KP_Enter:
         sc_display_console_detach_all(SC_DISPLAY(w->screen));
         sc_game_unpause(w->c, w->c->game);
         return(TRUE);
   }
   return(FALSE);

}



void sc_window_tank_move_gtk(sc_window_gtk *w, sc_player *p) {

   char buf[SC_GTK_STRING_BUFFER];
   GtkWidget *console;
   int x;

   if(p->x < w->c->fieldwidth / 2) {
      x = w->c->fieldwidth / (2 * sc_console_get_col_width(SC_CONSOLE(w->status))) + 1;
   } else {
      x = 2;
   }
   console = sc_active_console_new(x, 4, 26, 6, CONSOLE_NORMAL);
   sc_console_set_foreground(SC_CONSOLE(console), &w->colormap->pcolors[p->index]);

   sc_console_write_line(SC_CONSOLE(console), 0, 0, p->name);
   
   snprintfn(buf, sizeof(buf), "%4d", sc_player_total_fuel(w->c->accessories, p));
   sc_console_write_line(SC_CONSOLE(console), 22, 0, buf);
   
   sc_console_write_line(SC_CONSOLE(console), 0, 1, "Right means left and left");
   sc_console_write_line(SC_CONSOLE(console), 0, 2, "means right. Go which way?");

   gtk_signal_connect_after(GTK_OBJECT(console), "key_press_spot", GTK_SIGNAL_FUNC(_sc_window_tank_move_key_gtk), w);
   gtk_signal_connect_after(GTK_OBJECT(console), "select-spot", GTK_SIGNAL_FUNC(_sc_window_tank_move_btn_gtk), w);

   sc_console_write_line(SC_CONSOLE(console), 2, 4, "< Left >");
   sc_active_console_add_spot(SC_ACTIVE_CONSOLE(console), 2, 4, 8, 1, (void *)1);
   
   sc_console_write_line(SC_CONSOLE(console), 15,4, "< Right >");
   sc_active_console_add_spot(SC_ACTIVE_CONSOLE(console), 15,4, 9, 1, (void *)2);
   
   sc_console_write_line(SC_CONSOLE(console), 15,5, "< Close >");
   sc_active_console_add_spot(SC_ACTIVE_CONSOLE(console), 15,5, 9, 1, (void *)3);
   
   sc_display_console_attach(SC_DISPLAY(w->screen), SC_CONSOLE(console));
   #if !SC_GTK_DEBUG_DISABLE_DEFAULT   
      gtk_window_set_default(GTK_WINDOW(w->app), console);
   #endif /* debug */
   SC_ACTIVE_CONSOLE(console)->allowreturn = FALSE;
   
   sc_game_pause(w->c, w->c->game);

}
