/* $Header: /fridge/cvs/xscorch/sgtk/sstatus-gtk.c,v 1.8 2001/04/08 22:06:53 jacob Exp $ */
/*
   
   xscorch - sstatus-gtk.c    Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   GTK top statusbar 
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdio.h>
#include <stdlib.h>
#include <xscorch.h>
#include <sconsole.h>
#include <swindow-gtk.h>
#include <scolor-gtk.h>
#include <sgame/sinventory.h>
#include <sgame/sphysics.h>
#include <sgame/splayer.h>
#include <sgame/sweapon.h>
#include <sgame/sshield.h>
#include <sgame/sgame.h>
#include <sutil/sstr.h>

#include <sactiveconsole.h>



#define  SC_TWO_ROW_BOUNDARY     80



void sc_status_update(sc_window *w_, const sc_player *p) {

   int size;
   const sc_weapon_info *wi;
   char buf[SC_GTK_STRING_BUFFER];
   sc_window_gtk *w = (sc_window_gtk *)w_;

   if(w == NULL) return;
   wi = sc_weapon_lookup(w->c->weapons, p->selweapon, SC_WEAPON_LIMIT_ALL);
   if(wi == NULL) return;

   sc_window_redraw_tank(w_, p);
   
   if(p->aitype == SC_AI_NETWORK) return;
   
   size = w->c->fieldwidth / sc_console_get_col_width(SC_CONSOLE(w->status));

   sc_console_clear(SC_CONSOLE(w->status));
   sc_console_write_line(SC_CONSOLE(w->status), size - strlen(p->name) - 2, size < SC_TWO_ROW_BOUNDARY ? 1 : 0, p->name);
   sc_console_highlight_attach(SC_CONSOLE(w->status), &w->colormap->pcolors[p->index], &w->colormap->black, size - strlen(p->name) - 2, size < SC_TWO_ROW_BOUNDARY ? 1 : 0, 50, 1);

   if(size < SC_TWO_ROW_BOUNDARY) {
      snprintfn(buf, sizeof(buf), "Ang: %3d %c  Pwr: %4d  %c  Life: %4d  Shld: %4d",
                (p->turret >= 90 ? 180 - p->turret : p->turret), p->turret > 90 ? '<' : '>',
                 p->power, (p->contacttriggers ? 'T' : ' '), p->life, p->shield != NULL ? p->shield->life : 0);
      buf[sizeof(buf) - 1] = '\0';
      sc_console_write_line(SC_CONSOLE(w->status), 1, 0, buf);
      snprintfn(buf, sizeof(buf), "%2d %-16s   Wind: %4d %c",
                wi->inventories[p->index], wi->name,
                abs((int)(w->c->physics->curwind * 1000 / SC_PHYSICS_WIND_MAX)),
                    (w->c->physics->curwind >= 0 ? '>' : '<'));
      buf[sizeof(buf) - 1] = '\0';
      sc_console_write_line(SC_CONSOLE(w->status), 1, 1, buf);
   } else {
      snprintfn(buf, sizeof(buf),
                "Ang: %3d %c  Pwr: %4d  %c  Life: %4d  Shld: %4d   %2d %-16s   Wind: %4d %c",
                (p->turret >= 90 ? 180 - p->turret : p->turret), p->turret > 90 ? '<' : '>',
                p->power, (p->contacttriggers ? 'T' : ' '), p->life, p->shield != NULL ? p->shield->life : 0,
                wi->inventories[p->index], wi->name,
                abs((int)(w->c->physics->curwind * 1000 / SC_PHYSICS_WIND_MAX)),
                    (w->c->physics->curwind >= 0 ? '>' : '<'));
      buf[sizeof(buf) - 1] = '\0';
      sc_console_write_line(SC_CONSOLE(w->status), 1, 0, buf);
   }

}



void sc_status_player_message(sc_window *w_, sc_player *p, const char *msg) {

   sc_window_gtk *w = (sc_window_gtk *)w_;
   char buf[SC_GTK_STRING_BUFFER];
   
   if(w == NULL) return;

   snprintfn(buf, sizeof(buf), " %s:  %s", p->name, msg);
   buf[sizeof(buf) - 1] = '\0';

   sc_console_clear(SC_CONSOLE(w->status));
   sc_console_write_line(SC_CONSOLE(w->status), 1, 0, buf);
   sc_console_highlight_attach(SC_CONSOLE(w->status), &w->colormap->pcolors[p->index], &w->colormap->black, 0, 0, sc_console_get_width(SC_CONSOLE(w->status)), 1);

}



void sc_status_message(sc_window *w_, const char *msg) {

   sc_window_gtk *w = (sc_window_gtk *)w_;

   if(w == NULL) return;

   sc_console_clear(SC_CONSOLE(w->status));
   sc_console_write_line(SC_CONSOLE(w->status), 1, 0, msg);
   
}



void sc_status_setup(sc_window *w_) {

   sc_window_gtk *w = (sc_window_gtk *)w_;
   int size;
   int rows;
   
   if(w == NULL) return;

   rows = 1;
   size = w->c->fieldwidth / sc_console_get_col_width(SC_CONSOLE(w->status));
   if(size < SC_TWO_ROW_BOUNDARY) ++rows;
   sc_active_console_init(SC_ACTIVE_CONSOLE(w->status), 0, 0, size, rows, CONSOLE_BORDERLESS);

}
