/* $Header: /fridge/cvs/xscorch/sgtk/soptions-gtk.c,v 1.2 2001/04/07 19:44:17 justins Exp $ */
/*
   
   xscorch - soptions-gtk.c   Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Economy configuration dialogue
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <swindow-gtk.h>
#include <ssetup-gtk.h>
#include <sgame/sconfig.h>
#include <snet/snet.h>

#include <slabel.h>
#include <sdialog.h>
#include <slinkspin.h>
#include <slinkcombo.h>



typedef struct _sc_options_setup_data_gtk {
   sc_config *c;
   sc_config_options *co;
   int modeidx;
   int teamidx;
   int orderidx;
   int talkidx;
   int talkprob;
} sc_options_setup_data_gtk;



static void _sc_options_setup_apply_gtk(ScDialog *dlg, sc_options_setup_data_gtk *setup) {

   sc_config_options *co = setup->co;

   co->mode     = sc_config_mode_types()[setup->modeidx];
   co->team     = sc_config_team_types()[setup->teamidx];
   co->order    = sc_config_order_types()[setup->orderidx];
   co->talk     = sc_config_talk_types()[setup->talkidx];
   co->talkprob = setup->talkprob;

   #if USE_NETWORK
   if(SC_NETWORK_SERVER(setup->c)) sc_net_server_send_config(setup->c, setup->c->server);
   #endif
   
}



void sc_options_setup_gtk(sc_window_gtk *w) {

   sc_config_options *co = &w->c->options;
   sc_options_setup_data_gtk setup;
   ScDialog *dialog;
   int confirm = (SC_NETWORK_AUTH(w->c) ? SC_DIALOG_OK : 0);
   int row = 0;

   setup.c = w->c;
   setup.co = co;
   setup.modeidx = 0;
   setup.teamidx = 0;
   setup.orderidx= 0;
   setup.talkidx = 0;
   setup.talkprob= co->talkprob;
   while(sc_config_mode_types()[setup.modeidx] != co->mode)  ++setup.modeidx;
   while(sc_config_team_types()[setup.teamidx] != co->team)  ++setup.teamidx;
   while(sc_config_order_types()[setup.orderidx]!=co->order)++setup.orderidx;
   while(sc_config_talk_types()[setup.talkidx] != co->talk)  ++setup.talkidx;

   dialog = SC_DIALOG(sc_dialog_new("Options Setup", NULL, confirm | SC_DIALOG_CANCEL));
   gtk_signal_connect(GTK_OBJECT(dialog), "apply", GTK_SIGNAL_FUNC(_sc_options_setup_apply_gtk), &setup);

   sc_dialog_grid_attach(dialog, sc_label_new("Mode:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_combo_new(&setup.modeidx, sc_config_mode_names()), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("N/A:  Teams:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_combo_new(&setup.teamidx, sc_config_team_names()), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("Order:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_combo_new(&setup.orderidx, sc_config_order_names()), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("Talk mode:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_combo_new(&setup.talkidx, sc_config_talk_names()), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("Talk probability:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_spin_new(&setup.talkprob, 0, 100, 1), row++, 1);

   sc_dialog_run(dialog);

}



