/* $Header: /fridge/cvs/xscorch/sgtk/sfile-gtk.c,v 1.3 2001/04/07 22:32:52 justins Exp $ */
/*
   
   xscorch - sfile-gtk.c      Copyright(c) 2001 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Various file saving utilities
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <swindow-gtk.h>
#include <ssetup-gtk.h>
#include <sgame/sconfig.h>
#include <sgame/scffile.h>
#include <sutil/sstr.h>
#include <sutil/sreg.h>
#include <gdk/gdkkeysyms.h>

#include <sdialog.h>
#include <slinkentry.h>
#include <slabel.h>



typedef struct _sc_file_save {
   sc_config *c;
   char name[SC_FILENAME_LENGTH];
} sc_file_save;



static void _sc_config_file_save_apply_gtk(ScDialog *dlg, sc_file_save *save) {

   char buf[0x1000];
      
   reg_set_name(save->c->cfreg, save->name);
   if(sc_config_file_save(save->c)) {
      snprintfn(buf, sizeof(buf), "Options saved successfully to \"%s\".", save->name);
      sc_dialog_message("Options saved", buf);
   } else {
      snprintfn(buf, sizeof(buf), "An error occurred during the save of \"%s\".", save->name);
      sc_dialog_error(buf);
   }

}



void sc_config_file_save_gtk(sc_window_gtk *w) {

   sc_file_save save;
   ScDialog  *dialog;
   GtkWidget *widget;
   
   save.c = w->c;
   strncpyn(save.name, w->c->cfreg->filename, sizeof(save.name));
   
   dialog = SC_DIALOG(sc_dialog_new("Save Options As ...", NULL, SC_DIALOG_OK | SC_DIALOG_CANCEL));
   gtk_signal_connect(GTK_OBJECT(dialog), "apply", GTK_SIGNAL_FUNC(_sc_config_file_save_apply_gtk), &save);

   widget = sc_label_new("Save options in file:");
   gtk_table_attach(GTK_TABLE(dialog->grid), widget, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 2, 2);
   widget = sc_link_entry_new(save.name, SC_FILENAME_LENGTH);
   gtk_table_attach(GTK_TABLE(dialog->grid), widget, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 2, 2);

   sc_dialog_run(dialog);

}



