/* $Header: /fridge/cvs/xscorch/sgtk/seconomy-gtk.c,v 1.2 2001/04/07 19:44:17 justins Exp $ */
/*
   
   xscorch - seconomy-gtk.c   Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Economy configuration dialogue
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <swindow-gtk.h>
#include <ssetup-gtk.h>
#include <sgame/seconomy.h>
#include <sgame/sconfig.h>
#include <snet/snet.h>

#include <slabel.h>
#include <sdialog.h>
#include <slinkspin.h>
#include <slinkcheck.h>
#include <slinkcombo.h>



typedef struct _sc_economy_setup_data_gtk {
   sc_config *c;
   sc_economy *ec;
   double interestrate;
   bool dynamicinterest;
   int initialcash;
   bool computersbuy;
   bool computersaggressive;
   bool freemarket;
   int scoringidx;
} sc_economy_setup_data_gtk;



static void _sc_economy_setup_apply_gtk(ScDialog *dlg, sc_economy_setup_data_gtk *setup) {

   setup->ec->interestrate  = setup->interestrate;
   setup->ec->dynamicinterest=setup->dynamicinterest;
   setup->ec->initialcash   = setup->initialcash;
   setup->ec->computersbuy  = setup->computersbuy;
   setup->ec->computersaggressive = setup->computersaggressive;
   setup->ec->freemarket    = setup->freemarket;
   setup->ec->scoring       = sc_economy_scoring_types()[setup->scoringidx];

   #if USE_NETWORK
   if(SC_NETWORK_SERVER(setup->c)) sc_net_server_send_config(setup->c, setup->c->server);
   #endif
   
}



void sc_economy_setup_gtk(sc_window_gtk *w) {

   sc_economy *ec = w->c->economy;
   sc_economy_setup_data_gtk setup;
   ScDialog *dialog;
   int confirm = (SC_NETWORK_AUTH(w->c) ? SC_DIALOG_OK : 0);
   int row = 0;

   setup.c = w->c;
   setup.ec = ec;
   setup.interestrate   = ec->interestrate;
   setup.dynamicinterest= ec->dynamicinterest;
   setup.initialcash    = ec->initialcash;
   setup.computersbuy   = ec->computersbuy;
   setup.computersaggressive = ec->computersaggressive;
   setup.freemarket     = ec->freemarket;
   setup.scoringidx     = 0;
   while(sc_economy_scoring_types()[setup.scoringidx] != ec->scoring) ++setup.scoringidx;

   dialog = SC_DIALOG(sc_dialog_new("Economy Setup", NULL, confirm | SC_DIALOG_CANCEL));
   gtk_signal_connect(GTK_OBJECT(dialog), "apply", GTK_SIGNAL_FUNC(_sc_economy_setup_apply_gtk), &setup);

   sc_dialog_grid_attach(dialog, sc_label_new("Interest rate (percent):  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_spinf_new(&setup.interestrate, 0, SC_ECONOMY_MAX_INTEREST, 0.01), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("Dynamic interest:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_check_new(&setup.dynamicinterest), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("Initial cash:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_spin_new(&setup.initialcash, 0, SC_ECONOMY_MAX_CASH, SC_ECONOMY_MAX_CASH / 100), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("Computers can buy:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_check_new(&setup.computersbuy), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("Computers buy aggressively:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_check_new(&setup.computersaggressive), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("N/A:  Free market:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_check_new(&setup.freemarket), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("Scoring:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_combo_new(&setup.scoringidx, sc_economy_scoring_names()), row++, 1);
   
   sc_dialog_run(dialog);

}



