/* $Header: /fridge/cvs/xscorch/sgtk/scolor-gtk.h,v 1.2 2001/04/07 19:44:17 justins Exp $ */
/*
   
   xscorch - scolor-gtk.h     Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   GTK colormap
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __scolor_gtk_h_included
#define __scolor_gtk_h_included


#include <xscorch.h>
#include <gtk/gtk.h>
#include <sgame/sconfig.h>
#include <sgame/scolor.h>


/* Forward structure definitions */
struct _sc_window_gtk;
struct _sc_color;


/* Structure for storing allocated colors */
typedef struct _sc_color_gtk {
   GdkColor gradient[SC_NUM_GRADIENTS][SC_MAX_GRADIENT_SIZE];
   GdkColor pcolors[SC_MAX_PLAYERS];
   GdkColor black;
   GdkColor gray;
   GdkColor white;
   GdkColor napalm;
} sc_color_gtk;


/* Functions */
sc_color_gtk *sc_colormap_new_gtk(void);
void sc_colormap_free_gtk(sc_color_gtk **color);
void sc_colormap_alloc_colors_gtk(struct _sc_window_gtk *w);


#endif /* __scolor_gtk_h_included */

