/* $Header: /fridge/cvs/xscorch/sgtk/sai-gtk.c,v 1.2 2001/04/07 19:44:17 justins Exp $ */
/*
   
   xscorch - sai-gtk.c        Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   AI controller configuration dialogue
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <swindow-gtk.h>
#include <ssetup-gtk.h>
#include <sgame/sconfig.h>
#include <sai/sai.h>
#include <snet/snet.h> 

#include <slabel.h>
#include <sdialog.h>
#include <slinkcheck.h>



typedef struct _sc_ai_controller_setup_data_gtk {
   sc_config *c;
   sc_ai_controller *aic;
   bool humantargets;
   bool allowoffsets;
   bool nobudget;
} sc_ai_controller_setup_data_gtk;



static void _sc_ai_controller_setup_apply_gtk(ScDialog *dlg, sc_ai_controller_setup_data_gtk *setup) {

   sc_ai_controller *aic = setup->aic;
   
   aic->humantargets = setup->humantargets;
   aic->allowoffsets = setup->allowoffsets;
   aic->nobudget = setup->nobudget;
   
   #if USE_NETWORK
   if(SC_NETWORK_SERVER(setup->c)) sc_net_server_send_config(setup->c, setup->c->server);
   #endif
   
}



void sc_ai_controller_setup_gtk(sc_window_gtk *w) {

   sc_ai_controller *aic = w->c->aicontrol;
   sc_ai_controller_setup_data_gtk setup;
   ScDialog *dialog;
   int confirm = (SC_NETWORK_AUTH(w->c) ? SC_DIALOG_OK : 0);
   int row = 0;

   setup.c = w->c;
   setup.aic = aic;
   setup.humantargets = aic->humantargets;
   setup.allowoffsets = aic->allowoffsets;
   setup.nobudget = aic->nobudget;

   dialog = SC_DIALOG(sc_dialog_new("AI Controller Setup", NULL, confirm | SC_DIALOG_CANCEL));
   gtk_signal_connect(GTK_OBJECT(dialog), "apply", GTK_SIGNAL_FUNC(_sc_ai_controller_setup_apply_gtk), &setup);

   sc_dialog_grid_attach(dialog, sc_label_new("Human Target Practice:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_check_new(&setup.humantargets), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("Allow Offset Targetting:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_check_new(&setup.allowoffsets), row++, 1);

   sc_dialog_grid_attach(dialog, sc_label_new("No Budget Constraints:  "), row, 0);
   sc_dialog_grid_attach(dialog, sc_link_check_new(&setup.nobudget), row++, 1);

   sc_dialog_run(dialog);

}



