/* $Header: /fridge/cvs/xscorch/sgame/sshield.h,v 1.2 2001/04/07 19:50:44 jacob Exp $ */
/*
   
   xscorch - sshield.h        Copyright(c) 2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Scorched shields
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __sshield_h_included
#define __sshield_h_included


/* Includes */
#include <xscorch.h>


/* Forward declarations */
struct _sc_accessory_info;
struct _sc_explosion;
struct _sc_player;


/* Constants */
#define  SC_SHIELD_ABSORB_HIT       700   /* Damage to shield when it absorbs a missile */


/* Macros */
#define  SC_SHIELD_IS_MINIMAL(s)    ((s)->info->shield < 100)
#define  SC_SHIELD_IS_WEAK(s)       ((s)->info->shield >= 100  && (s)->info->shield < 5000)
#define  SC_SHIELD_IS_MEDIUM(s)     ((s)->info->shield >= 5000 && (s)->info->shield < 10000)
#define  SC_SHIELD_IS_STRONG(s)     ((s)->info->shield >= 10000)


/* Current shield status */
typedef struct _sc_shield {
   const struct _sc_accessory_info *info; /* Shield type */
   int life;                              /* Shield remaining life */
} sc_shield;


/* Shield creation and release */
sc_shield *sc_shield_new(const struct _sc_accessory_info *acc);
void sc_shield_free(sc_shield **sh);


/* Shield updates */
bool sc_shield_would_impact(const struct _sc_player *p, int rad2);
bool sc_shield_absorb_hit(struct _sc_player *p);
int  sc_shield_absorb_explosion(struct _sc_player *p, const struct _sc_explosion *e, int damage);


#endif /* __sshield_h_included */

