/* $Header: /fridge/cvs/xscorch/sgame/sshield.c,v 1.2 2001/04/07 19:50:44 jacob Exp $ */
/*
   
   xscorch - sshield.c        Copyright(c) 2000 Justin David Smith
                              Copyright(c) 2000 Jacob Luna Lundberg
   justins(at)chaos2.org      http://chaos2.org/
   jacob(at)chaos2.org        http://chaos2.org/~jacob

   Scorched shields
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdlib.h>
#include <sconfig.h>
#include <sshield.h>
#include <saccessory.h>
#include <sexplosion.h>
#include <stankpro.h>
#include <splayer.h>
#include <sutil/srand.h>



sc_shield *sc_shield_new(const sc_accessory_info *acc) {
/* sc_shield_new
   Create a new shield. */

   sc_shield *sh;
   
   if(!SC_ACCESSORY_IS_SHIELD(acc)) return(NULL);
   
   sh = (sc_shield *)malloc(sizeof(sc_shield));
   if(sh == NULL) return(NULL);

   sh->info = acc;
   sh->life = acc->shield;
   
   return(sh);

}



void sc_shield_free(sc_shield **sh) {
/* sc_shield_free
   Free an old (dead) shield. */

   if(sh == NULL || *sh == NULL) return;
   free(*sh);
   *sh = NULL;

}



bool sc_shield_would_impact(const sc_player *p, int rad2) {
/* sc_shield_would_impact
   When a shield would take a direct hit. */

   if(rad2 >= SQR(p->tank->radius) && rad2 < SQR(p->tank->radius + 1)) {
      if (p->shield != NULL && game_lrand(100) < p->shield->info->probability) {
         return(true);
      }
   }
   return(false);

}



bool sc_shield_absorb_hit(sc_player *p) {
/* sc_shield_absorb_hit
   When a shield takes a direct hit. */

   if(p->shield != NULL) {
      p->shield->life -= SC_SHIELD_ABSORB_HIT;
      if(p->shield->life <= 0) sc_shield_free(&p->shield);
      return(true);
   }
   return(false);

}



int sc_shield_absorb_explosion(sc_player *p, const sc_explosion *e, int damage) {
/* sc_shield_absorb_explosion
   Try to absorb damage into a player's shield.  The damage undealt
   is returned, or zero if all damage absorbed.  */

   /* Must have a shield for it to take damage */
   if(p->shield == NULL) return(damage);

   /* Find out how much of the damage it took */
   p->shield->life -= damage;
   if(p->shield->life <= 0) {
      damage = -p->shield->life;
      sc_shield_free(&p->shield);
      if(e->type == SC_EXPLOSION_NAPALM) {
         damage = 0;
      }
   } else {
      damage = 0;
   }

   /* Return damage to the actual tank */
   return(damage);

}
