/* $Header: /fridge/cvs/xscorch/sgame/sinventory.h,v 1.7 2001/04/08 22:06:53 jacob Exp $ */
/*

   xscorch - sinventory.h     Copyright(c) 2000 Justin David Smith
                              Copyright(c) 2001 Jacob Luna Lundberg
   justins(at)chaos2.org      http://chaos2.org/
   jacob(at)chaos2.org        http://chaos2.org/~jacob

   Scorched player inventory


   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __sinventory_h_included
#define __sinventory_h_included


#include <xscorch.h>
#include <sgame/sweapon.h>
#include <sgame/saccessory.h>


/* Forward structures */
struct _sc_player;
struct _sc_config;


/* Maximum number of items allowed */
#define  SC_INVENTORY_MAX_ITEMS     99
#define  SC_INVENTORY_INFINITE      -1


/* Item information */
typedef struct _sc_item_info {
   /* DO NOT CHANGE the order */
   int ident;                   /* Item identifier (uniq. within item class) */
   int armslevel;               /* Arms level for this item */
   int price;                   /* Cost of this items, per bundle */
   int bundle;                  /* Number of items in a bundle */
} sc_item_info;


/* Inventory array item format */
typedef struct _sc_inventory_item {
   int id;                      /* Lookup id of each item */
   int count;                   /* Number of each type of item */
} sc_inventory_item;


/* Player inventory list */
typedef struct _sc_inventory {
/* TEMP - the whole sc_inventory struct needs to die - JL */
#if 0
   sc_inventory_item *weapons;          /* Number of each type of weapon */
#endif
   int *accessories;                    /* Number of each type of accessory */
} sc_inventory;


/* Initialization and destruction */
void sc_inventory_init(const struct _sc_config *c, sc_inventory *inv);
sc_inventory *sc_inventory_new(void);
void sc_inventory_free(sc_inventory **inv);


/* Inventory queries */
bool sc_inventory_can_buy_weapon(const struct _sc_player *p, const sc_weapon_info *info, int budget);
bool sc_inventory_can_buy_accessory(const sc_accessory_config *ac, const struct _sc_player *p, int index, int budget);
bool sc_inventory_can_sell_weapon(const struct _sc_player *p, const sc_weapon_info *info);
bool sc_inventory_can_sell_accessory(const sc_accessory_config *ac, const struct _sc_player *p, int index);


/* Inventory purchases */
bool sc_inventory_buy_weapon(struct _sc_player *p, const sc_weapon_info *info);
bool sc_inventory_buy_accessory(const sc_accessory_config *ac, struct _sc_player *p, int index);
bool sc_inventory_sell_weapon(struct _sc_player *p, const sc_weapon_info *info);
bool sc_inventory_sell_accessory(const sc_accessory_config *ac, struct _sc_player *p, int index);


#endif /* __sinventory_h_included */
