/* $Header: /fridge/cvs/xscorch/sgame/sgame.h,v 1.3 2001/04/07 19:44:02 jacob Exp $ */
/*
   
   xscorch - sgame.h          Copyright(c) 2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Scorched game state header
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __sgame_h_included
#define __sgame_h_included


#include <xscorch.h>
#include <ssound/ssound.h>



/* Forward structures */
struct _sc_explosion;
struct _sc_config;



typedef struct _sc_game {
   int curplayer;                /* Current player */

   /* Current audio tracks */
   sc_sound_music musicid;       /* Musical Ident */

   /* State machine parametres */
   struct timeval timeout;       /* Time until next state is run */
   int state;                    /* Next state to execute */

   /* State flags */
   int substate;                 /* Substate flag (e.g. player number) */
   struct _sc_explosion *explosions;   /* Explosions to track */
   struct _sc_explosion *curexpl;/* Current explosion object */
   int curindex;                 /* Current explosion index */
} sc_game;


sc_game *sc_game_new(void);
void sc_game_free(sc_game **g);
void sc_game_init(sc_game *g);
void sc_game_time(struct timeval *gametime);
void sc_game_mass_kill(struct _sc_config *c, sc_game *g);
void sc_game_set_state(sc_game *g, int state, unsigned long delay);
void sc_game_set_state_now(struct _sc_config *c, sc_game *g, int state);
void sc_game_set_state_asap(sc_game *g, int state);
void sc_game_set_state_allow_now(struct _sc_config *c, sc_game *g, int state, unsigned long delay);
void sc_game_reinstate(sc_game *g, unsigned long delay);
void sc_game_reinstate_now(struct _sc_config *c, sc_game *g);
void sc_game_reinstate_allow_now(struct _sc_config *c, sc_game *g, unsigned long delay);
void sc_game_sync_timeout(sc_game *g);
void sc_game_pause(struct _sc_config *c, sc_game *g);
void sc_game_unpause(struct _sc_config *c, sc_game *g);
int  sc_game_victor(struct _sc_config *c);
void sc_game_set_victor(struct _sc_config *c);


#endif /* __sgame_h_included? */
