/* $Header: /fridge/cvs/xscorch/sgame/sgame.c,v 1.3 2001/04/07 19:44:02 jacob Exp $ */
/*
   
   xscorch - sgame.c          Copyright(c) 2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Scorched game state machine
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <sgame.h>         /* Game state header */
#include <sstate.h>        /* Game state header */
#include <sphysics.h>      /* Need to do Wind updates */
#include <seconomy.h>      /* Need to do interest update */
#include <swindow.h>       /* We do much drawing from state machine */
#include <sconfig.h>       /* Config is dereferenced frequently */
#include <splayer.h>       /* Dereferenced in death check, etc. */
#include <sweapon.h>       /* We construct weapon chains here */
#include <strack.h>        /* Need for tracking, return codes */
#include <ssound/ssound.h> /* Sound hooks are present, here  */
#include <sland.h>         /* Need to drop the land after deton */
#include <sutil/srand.h>   /* Need a random number generator */
#include <sai/sai.h>       /* We are responsible for running AI */



sc_game *sc_game_new(void) {

   sc_game *g;
   
   g = (sc_game *)malloc(sizeof(sc_game));
   if(g == NULL) return(NULL);

   g->musicid = SC_MUSIC_PRELUDE;
   g->explosions = NULL;
   sc_game_init(g);
   return(g);

}



void sc_game_free(sc_game **g) {

   if(g == NULL || *g == NULL) return;
   sc_expl_free_chain(&(*g)->explosions);
   free(*g);
   *g = NULL;

}



inline void sc_game_time(struct timeval *gametime) {

   gettimeofday(gametime, NULL);

}



inline void sc_game_reinstate(sc_game *g, unsigned long delay) {

   g->timeout.tv_usec += (delay % 1000) * 1000;
   while(g->timeout.tv_usec >= 1000000) {
      g->timeout.tv_usec -= 1000000;
      g->timeout.tv_sec++;
   }
   g->timeout.tv_sec += (delay / 1000);

}



inline void sc_game_reinstate_now(sc_config *c, sc_game *g) {

   sc_game_reinstate(g, 0);
   sc_state_run(c, g);

}



inline void sc_game_reinstate_allow_now(sc_config *c, sc_game *g, unsigned long delay) {

   if(delay <= 0) sc_game_reinstate_now(c, g);
   else sc_game_reinstate(g, delay);

}



inline void sc_game_set_state(sc_game *g, int state, unsigned long delay) {
   
   g->state    = state;
   sc_game_reinstate(g, delay);

}



inline void sc_game_set_state_now(sc_config *c, sc_game *g, int state) {
   
   g->state    = state;
   sc_game_reinstate_now(c, g);

}



inline void sc_game_set_state_asap(sc_game *g, int state) {

   sc_game_set_state(g, state, 0);

}



inline void sc_game_set_state_allow_now(sc_config *c, sc_game *g, int state, unsigned long delay) {

   if(delay <= 0) sc_game_set_state_now(c, g, state);
   else sc_game_set_state(g, state, delay);

}



inline void sc_game_sync_timeout(sc_game *g) {
   
   sc_game_time(&g->timeout);

}



void sc_game_mass_kill(sc_config *c, sc_game *g) {

   int i;
   
   for(i = 0; i < c->numplayers; ++i) {
      c->players[i]->dead = true;
   }
   sc_game_set_state(g, SC_STATE_ROUND_END, 0);

}



void sc_game_init(sc_game *g) {

   g->substate = 0;
   g->curplayer = 0;
   sc_game_sync_timeout(g);
   sc_game_set_state(g, SC_STATE_PRELUDE_BEGIN, 0);
   sc_expl_free_chain(&g->explosions);
   
}



int sc_game_victor(sc_config *c) {

   int i;
   int j;
   
   i = c->numplayers - 1;
   j = 0;
   while(i >= 0) {
      if(!c->players[i]->dead) ++j;
      --i;
   }
   return(j <= 1);

}



void sc_game_set_victor(sc_config *c) {

   int i;
   
   i = c->numplayers - 1;
   while(i >= 0) {
      if(!c->players[i]->dead) sc_player_inc_wins(c, c->players[i]);
      --i;
   }

}



void sc_game_pause(sc_config *c, sc_game *g) {

   g->state = g->state | SC_STATE_PAUSE_FLAG;

}



void sc_game_unpause(sc_config *c, sc_game *g) {

   g->state = g->state & ~SC_STATE_PAUSE_FLAG;
   sc_game_sync_timeout(g);

}




