/* $Header: /fridge/cvs/xscorch/sgame/seconomy.h,v 1.2 2001/04/07 19:42:58 jacob Exp $ */
/*
   
   xscorch - seconomy.h       Copyright(c) 2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Scorched economy
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __seconomy_h_included
#define __seconomy_h_included


#include <xscorch.h>


/* Forward structure definitions */
struct _sc_config;


/* Basic economical constants */
#define  SC_ECONOMY_MAX_CASH        1000000     /* 1mil dollars */
#define  SC_ECONOMY_DEF_CASH        100000      /* Start as broke */
#define  SC_ECONOMY_DEF_INTEREST    0.05        /* Default interest rate (percent) */
#define  SC_ECONOMY_MAX_INTEREST    0.30        /* Maximum interest rate */

/* Markups (values > 1) and markdowns (values < 1) */
#define  SC_ECONOMY_SPLIT_MARKUP    1.30        /* Percent markup if a bundle is split */
#define  SC_ECONOMY_SELL_MARKUP     0.50        /* Percent markup to sell (<1, markdown) */


/* Scoring methods available */
typedef enum _sc_economy_scoring {
   SC_ECONOMY_SCORING_BASIC,     /* Points only for killing a tank, and surviving */
   SC_ECONOMY_SCORING_STANDARD,  /* Fewer pts for kill, but points for damaging */
   SC_ECONOMY_SCORING_GREEDY     /* "He who dies with most toys wins" */
} sc_economy_scoring;


/* Economy configuration */
typedef struct _sc_economy {
   double interestrate;          /* Current interest rate (%/round) */
   bool dynamicinterest;         /* Nonzero if interest rate can change */
   double currentinterest;       /* Current interest rate */
   int initialcash;              /* Initial cash for all players */
   bool computersbuy;            /* Nonzero if computers can buy */
   bool computersaggressive;     /* Computers are agressive with money? */
   bool freemarket;              /* Nonzero if simulating a free mkt */
   sc_economy_scoring scoring;   /* Scoring method */
   
   /* Configured constants */
   int survivalbonus;            /* Amount of money recv'd for survival */
   int damagebonus;              /* Amount of money recv'd for damaging */
   int killbonus;                /* Bonus for killing an opponent */
   int damageloss;               /* Amt of money lost for sustaining damage */
   int deathloss;                /* Amt of money lost for dying */
   int suicideloss;              /* Amt of money lost for killing self */
} sc_economy;


sc_economy *sc_economy_new(void);
void sc_economy_free(sc_economy **ec);
void sc_economy_init(sc_economy *ec);
void sc_economy_interest(struct _sc_config *c, sc_economy *ec);

const char **sc_economy_scoring_names(void);
const int *sc_economy_scoring_types(void);


#endif /* __seconomy_h_included */
