/* $Header: /fridge/cvs/xscorch/sgame/saccessory.h,v 1.4 2001/04/08 01:18:31 justins Exp $ */
/*
   
   xscorch - saccessory.h     Copyright(c) 2001,2000 Justin David Smith
                              Copyright(c) 2001,2000 Jacob Luna Lundberg
   justins(at)chaos2.org      http://chaos2.org/
   jacob(at)chaos2.org        http://chaos2.org/~jacob

   Scorched tank accessories
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __saccessory_h_included
#define __saccessory_h_included


/* Includes */
#include <xscorch.h>


/* Forward declarations */
struct _sc_config;


/* Total number of defenses */
#define  SC_MAX_ACCESSORY_ID        32766    /* Allow lots of accessories */
#define  SC_ACCESSORY_DEFAULT       0        /* Default selected accessory */


/* Data on the various types of accessories */
typedef struct _sc_accessory_info {
   /* DO NOT CHANGE the order of the first four items:
      should be ident, armslevel, price, bundle.  */
   int ident;                       /* Accessory identifier */
   int armslevel;                   /* Arms level for this accessory */
   int price;                       /* Price ($) */
   int bundle;                      /* Bundle size */
   int shield;                      /* Shield strength (0 == not a shield) */
   int fuel;                        /* Amount of fuel (0 == not a fuel tank) */
   int probability;                 /* Prob. of success (e.g. shield deflect) */
   int state;                       /* Accessory state/type bits */
   char *name;                      /* Accessory name */
} sc_accessory_info;


/* Bits in the accessory state flag, which are AND'ed to
   create each player's accessory state flag. */
#define  SC_ACCESSORY_STATE_TRIPLE        0x0001
#define  SC_ACCESSORY_STATE_AUTO_DEF      0x0002
#define  SC_ACCESSORY_STATE_TRIGGER       0x0004


/* Macros for checking bits in the accessory state flag. */
#define  SC_ACCESSORY_IS_TRIPLE(a)   ((a)->state & SC_ACCESSORY_STATE_TRIPLE)
#define  SC_ACCESSORY_IS_AUTO_DEF(a) ((a)->state & SC_ACCESSORY_STATE_AUTO_DEF)
#define  SC_ACCESSORY_IS_TRIGGER(a)  ((a)->state & SC_ACCESSORY_STATE_TRIGGER)


/* Macros for accessory info */
#define  SC_ACCESSORY_IS_INFINITE(a) ((a)->bundle <= 0 || (a)->price <= 0)
#define  SC_ACCESSORY_IS_SHIELD(a)  ((a)->shield != 0)
#define  SC_ACCESSORY_IS_FUEL(a)    ((a)->fuel != 0)


/* Accessory configuration */
typedef struct _sc_accessory_config {
   sc_accessory_info *accessorylist;/* The run-time accessories list pointer */
   int armslevel;                   /* Current technology (arms) level */
   bool uselessitems;               /* Useless items appear in inventory? */
} sc_accessory_config;


/* Accessory information lookup */
int sc_accessory_count(const sc_accessory_config *ac);
const sc_accessory_info *sc_accessory_lookup(const sc_accessory_config *ac, int item);
const sc_accessory_info *sc_accessory_next(const sc_accessory_config *ac, int *item);
const sc_accessory_info *sc_accessory_prev(const sc_accessory_config *ac, int *item);


/* Accessory configuration setup */
sc_accessory_config *sc_accessory_config_new(void);
sc_accessory_info *sc_accessory_info_append(sc_accessory_info *al, const char *filename);
void sc_accessory_config_free(sc_accessory_config **ac);


#endif /* __saccessory_h_included */

