/* $Header: /fridge/cvs/xscorch/sgame/saccessory.c,v 1.5 2001/04/08 01:18:31 justins Exp $ */
/*
   
   xscorch - saccessory.c     Copyright(c) 2000 Jacob Luna Lundberg
                              Copyright(c) 2000 Justin David Smith
   jacob(at)chaos2.org        http://chaos2.org/~jacob
   justins(at)chaos2.org      http://chaos2.org/

   Scorched tank accessories
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <saccessory.h>    /* Get accessory data */
#include <sconfig.h>       /* Config constants */
#include <sstr.h>          /* String functions */



/***  Accessory Data    ***/



int sc_accessory_count(const sc_accessory_config *ac) {
/* sc_accessory_count
   Counts the number of accessories in an sc_accessory_config struct's accessorylist.
   This is optimized but of course if you're calling it a lot you should cache the data.
   The only exception is that the count may change if a new accessory list file is appended. */

   /* Start counter at -1, which will give a value of 0 in the first test */
   int counter = -1;

   /* Count the accessories */
   while(ac->accessorylist[++counter].ident >= 0) /* Just loop */;

   /* Return the count */
   return(counter);

}



const sc_accessory_info *sc_accessory_lookup(const sc_accessory_config *ac, int item) {
/* sc_accessory_lookup
   Returns the accessory information for index given.  If the index is
   out-of-bounds, then NULL is returned. */

   if(item < 0 || item >= sc_accessory_count(ac)) return(NULL);
   return(&(ac->accessorylist[item]));

}



const sc_accessory_info *sc_accessory_next(const sc_accessory_config *ac, int *item) {
/* sc_accessory_next
   Advance to the next accessory in the list (with wrapping).  */

   if(item == NULL) return(NULL);

   ++(*item);
   if(*item >= sc_accessory_count(ac)) *item = 0;
   return(sc_accessory_lookup(ac, *item));

}



const sc_accessory_info *sc_accessory_prev(const sc_accessory_config *ac, int *item) {
/* sc_accessory_prev
   Advance to the previous accessory in the list (with wrapping).  */

   if(item == NULL) return(NULL);

   --(*item);
   if(*item < 0) *item = sc_accessory_count(ac) - 1;
   return(sc_accessory_lookup(ac, *item));

}



/* Eventually this will be in the file that reads accessory list files and
   it will also be generalized so that it works as the name suggests. */
sc_accessory_info *sc_accessory_info_append(sc_accessory_info *al, const char *filename) {
/* sc_accessory_info_append
   Takes an sc_accessory_info array and grows it to hold the data in filename. */

   int counter;
   sc_accessory_info blorf[] = {
      /* Ident Arms  Price Bundl Shld  Fuel  Prob  State   Name */
      {  0,    0,    0,    0,    0,    0,    0,    0x0000, "No accessory" },
      {  1,    0,    5000, 5,    100,  0,    50,   0x0000, "Deflector" },
      {  2,    1,    20000,2,    4000, 0,    90,   0x0000, "Light Mag" },
      {  3,    2,    40000,2,    8000, 0,    95,   0x0000, "Medium Mag" },
      {  4,    3,    80000,2,    16000,0,    99,   0x0000, "Heavy Mag" },
      {  5,    0,    1000, 10,   0,    10,   0,    0x0000, "Fuel Tank" },
      {  6,    1,    25000,1,    0,    0,    0,    0x0001, "Triple Turret" },
      {  7,    3,    1500, 1,    0,    0,    0,    0x0002, "Auto Defense" },
      {  8,    3,    1000, 25,   0,    0,    0,    0x0004, "Contact Trigger" },
      {  -1,   0,    0,    0,    0,    0,    0,    0x0000,  NULL }
   };

   al = (sc_accessory_info *)realloc(al, 10 * sizeof(sc_accessory_info));
   for(counter = 0; counter < 10; ++counter) {
      al[counter].ident       = blorf[counter].ident;
      al[counter].armslevel   = blorf[counter].armslevel;
      al[counter].price       = blorf[counter].price;
      al[counter].bundle      = blorf[counter].bundle;
      al[counter].shield      = blorf[counter].shield;
      al[counter].fuel        = blorf[counter].fuel;
      al[counter].probability = blorf[counter].probability;
      al[counter].state       = blorf[counter].state;
      if(blorf[counter].name == NULL) {
         al[counter].name = NULL;
      } else {
         int i;
         al[counter].name = (char *)malloc(strlen(blorf[counter].name) + 1);
         for(i = 0; i < strlen(blorf[counter].name); ++i)
            al[counter].name[i] = blorf[counter].name[i];
         al[counter].name[i] = '\0';
      }
   }

   return(al);

}



sc_accessory_config *sc_accessory_config_new(void) {
/* sc_accessory_config
   Allocate space and set defaults on a new sc_accessory_config struct. */

   const char *filename;
   sc_accessory_config *ac;

   ac = (sc_accessory_config *)malloc(sizeof(sc_accessory_config));
   if(ac == NULL) return(NULL);

   ac->armslevel = SC_ARMS_LEVEL_DEF;
   ac->uselessitems = true;
   ac->accessorylist = NULL;

   /* Read in the accessory info list */
   /* TEMP: gotta fix the hardcoded filename... (and the hardcoded function using it, lol) */
   /* TEMP: how `bout this? -J */
   filename = SC_GLOBAL_DIR "/" SC_ACCESSORY_FILE;
   ac->accessorylist = sc_accessory_info_append(ac->accessorylist, filename);
   if(ac->accessorylist == NULL) return(NULL);

   return(ac);

}
