/* $Header: /fridge/cvs/xscorch/sai/sai.c,v 1.3 2001/04/07 19:52:43 justins Exp $ */
/*
   
   xscorch - sai.c            Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Main file for AI code
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <saiint.h>              /* Main AI internal header */
#include <sgame/splayer.h>       /* Need player data structure */
#include <sutil/srand.h>         /* Random AI selection */



void sc_ai_init_game(const struct _sc_config *c, sc_player *p) {
/* sc_ai_init_game */

   if(p->aitype == SC_AI_RANDOM) {
      do { /* Need a random AI */
         p->ai->realaitype = game_lrand(SC_AI_RANDOM);
      } while(p->ai->realaitype == SC_AI_HUMAN);
   } else {
      p->ai->realaitype = p->aitype;
   } /* Selecting a random AI? */

}



void sc_ai_init_round(const struct _sc_config *c, sc_player *p) {
/* sc_ai_init_round */

   p->ai->victim = NULL;

}



sc_ai *sc_ai_new(void) {

   return((sc_ai *)malloc(sizeof(sc_ai)));

}



void sc_ai_free(sc_ai **ai) {

   if(ai == NULL || *ai == NULL) return;
   free(*ai);
   *ai = NULL;

}



sc_ai_controller *sc_ai_controller_new(void) {

   sc_ai_controller *aic;
   
   aic = (sc_ai_controller *)malloc(sizeof(sc_ai_controller));
   if(aic == NULL) return(NULL);
   
   aic->humantargets = false;
   aic->allowoffsets = false;
   aic->nobudget = false;
   
   return(aic);

}



void sc_ai_controller_free(sc_ai_controller **aic) {

   if(aic == NULL || *aic == NULL) return;
   free(*aic);
   *aic = NULL;

}



/* AI types and codes */
static const char *_sc_player_ai_names[] = {
   "Human",
   "Network",
   "Moron",
   "Shooter",
   "Spreader",
   "Chooser",      
   "Calculater",    
   "Annihilater",
   "Insanity",
   "Unknown",
   NULL
};
static const int _sc_player_ai_types[] = {
   SC_AI_HUMAN,
   SC_AI_NETWORK,
   SC_AI_MORON,
   SC_AI_SHOOTER,
   SC_AI_SPREADER,
   SC_AI_CHOOSER,
   SC_AI_CALCULATER,
   SC_AI_ANNIHILATER,
   SC_AI_INSANITY,
   SC_AI_RANDOM,
   0
};


const char **sc_ai_names(void) {
   
   return(_sc_player_ai_names);

}


const int *sc_ai_types(void) {
   
   return(_sc_player_ai_types);

}


const char *sc_ai_name(sc_ai_type ai) {

   int index = 0;

   while(_sc_player_ai_names[index] != NULL) {
      if(_sc_player_ai_types[index] == ai) return(_sc_player_ai_names[index]);
      ++index;
   }
   return("Unknown");

}



/* AI types and codes */
static const char *_sc_player_ai_names_nonet[] = {
   "Human",
   "Moron",
   "Shooter",
   "Spreader",
   "Chooser",      
   "Calculater",    
   "Annihilater",
   "Insanity",
   "Unknown",
   NULL
};
static const int _sc_player_ai_types_nonet[] = {
   SC_AI_HUMAN,
   SC_AI_MORON,
   SC_AI_SHOOTER,
   SC_AI_SPREADER,
   SC_AI_CHOOSER,
   SC_AI_CALCULATER,
   SC_AI_ANNIHILATER,
   SC_AI_INSANITY,
   SC_AI_RANDOM,
   0
};


const char **sc_ai_names_nonet(void) {
   
   return(_sc_player_ai_names_nonet);

}


const int *sc_ai_types_nonet(void) {
   
   return(_sc_player_ai_types_nonet);

}



/* AI types and codes */
static const char *_sc_player_ai_names_nohuman[] = {
   "Moron",
   "Shooter",
   "Spreader",
   "Chooser",      
   "Calculater",    
   "Annihilater",
   "Insanity",
   "Unknown",
   NULL
};
static const int _sc_player_ai_types_nohuman[] = {
   SC_AI_MORON,
   SC_AI_SHOOTER,
   SC_AI_SPREADER,
   SC_AI_CHOOSER,
   SC_AI_CALCULATER,
   SC_AI_ANNIHILATER,
   SC_AI_INSANITY,
   SC_AI_RANDOM,
   0
};


const char **sc_ai_names_nohuman(void) {
   
   return(_sc_player_ai_names_nohuman);

}


const int *sc_ai_types_nohuman(void) {
   
   return(_sc_player_ai_types_nohuman);

}


