/***************************************************************************
                          setting.c  -  description
                             -------------------
    begin                : Thu Aug 8 2002
    copyright            : (C) 2002 by Steeve Beaudin
    email                : steevebeaudin@netscape.net
 ***************************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "setting.h"
#include "def.h"


gchar *JS_header = "<script type=\"text/JavaScript\" language=\"JavaScript\">\n<!--\n";
gchar *JS_footer = "// -->\n</script>";
                       
gchar *JSP_header = "<%\nPrintWriter out;\n\nresponse.setContentType(\"text/html\");\n\nout = response.getWriter();\n\n";
gchar *JSP_footer = "\nout.close();\n%>";

gchar *ASP_header = "<%@ Language=VBScript %>\n<%\n";
gchar *ASP_footer = "%>";

gchar *PHP_header = "<?php\n";
gchar *PHP_footer = "?>";

gchar *Perl_header = "#!/usr/bin/perl\n\nprint \"Content-type: text/plain\\n\\n\";\n\n";
gchar *Perl_footer = "\n# End";

gchar *Shell_header = "#!/bin/sh\n\n# disable filename globbing\nset -f\n\necho -e \"Content-type: text/plain\\n\"\n\n";
gchar *Shell_footer = "\nexit 0"; 

void
write_default_setting( void )
{
  gchar *tmprep; 
  GString *tmpstr;
  
  tmpstr = g_string_new("");

  tmprep = gnome_config_get_string("/HtmlCodeConvert/JS/Header");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, JS_header);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/JS/Header",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/JS/IncludeHeader",TRUE); 
  }
  else
    g_free(tmprep);
  
  tmprep = gnome_config_get_string("/HtmlCodeConvert/JS/Footer");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, JS_footer);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/JS/Footer",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/JS/IncludeFooter",TRUE);                                                                        
  }
  else
    g_free(tmprep);

  tmprep = gnome_config_get_string("/HtmlCodeConvert/JSP/Header");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, JSP_header);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/JSP/Header",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/JSP/IncludeHeader",TRUE); 
  }
  else
    g_free(tmprep);

  tmprep = gnome_config_get_string("/HtmlCodeConvert/JSP/Footer");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, JSP_footer);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/JSP/Footer",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/JSP/IncludeFooter",TRUE);                                                                        
  }
  else
    g_free(tmprep);

  tmprep = gnome_config_get_string("/HtmlCodeConvert/ASP/Header");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, ASP_header);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/ASP/Header",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/ASP/IncludeHeader",TRUE); 
  }
  else
    g_free(tmprep);

  tmprep = gnome_config_get_string("/HtmlCodeConvert/ASP/Footer");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, ASP_footer);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/ASP/Footer",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/ASP/IncludeFooter",TRUE);                                                                        
  }
  else
    g_free(tmprep);
  
  tmprep = gnome_config_get_string("/HtmlCodeConvert/PHP/Header");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, PHP_header);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/PHP/Header",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/PHP/IncludeHeader",TRUE); 
  }
  else
    g_free(tmprep);

  tmprep = gnome_config_get_string("/HtmlCodeConvert/PHP/Footer");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, PHP_footer);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/PHP/Footer",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/PHP/IncludeFooter",TRUE);                                                                        
  }
  else
    g_free(tmprep);
  
  tmprep = gnome_config_get_string("/HtmlCodeConvert/Perl/Header");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, Perl_header);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/Perl/Header",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/Perl/IncludeHeader",TRUE); 
  }
  else
    g_free(tmprep);

  tmprep = gnome_config_get_string("/HtmlCodeConvert/Perl/Footer");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, Perl_footer);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/Perl/Footer",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/Perl/IncludeFooter",TRUE);                                                                        
  }
  else
    g_free(tmprep);
  
  tmprep = gnome_config_get_string("/HtmlCodeConvert/Shell/Header");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, Shell_header);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/Shell/Header",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/Shell/IncludeHeader",TRUE); 
  }
  else
    g_free(tmprep);

  tmprep = gnome_config_get_string("/HtmlCodeConvert/Shell/Footer");
  if ( tmprep == NULL )
  { 
    tmpstr = g_string_assign (tmpstr, Shell_footer);
    tmpstr = str_to_hex(tmpstr);
    gnome_config_set_string("/HtmlCodeConvert/Shell/Footer",tmpstr->str);
    gnome_config_set_bool("/HtmlCodeConvert/Shell/IncludeFooter",TRUE);                                                                        
  }
  else
    g_free(tmprep);
  
  g_string_free(tmpstr,TRUE);  
  gnome_config_sync();
  gnome_config_drop_all();
}

void
init_change_setting( GnomePropertyBox *propbox )
{
  load_header_footer( GTK_WIDGET(propbox), "JS" );
  load_header_footer( GTK_WIDGET(propbox), "JSP" );
  load_header_footer( GTK_WIDGET(propbox), "ASP" );
  load_header_footer( GTK_WIDGET(propbox), "PHP" );
  load_header_footer( GTK_WIDGET(propbox), "Perl" );
  load_header_footer( GTK_WIDGET(propbox), "Shell" );

  gnome_property_box_set_state( propbox, FALSE );
}

void
load_header_footer ( GtkWidget *propbox, 
                     gchar *basename)
{
  GtkWidget *textwidget;
  GtkWidget *checkwidget;
  GString *strval;
  gchar *tmpstr;
  gboolean boolval;  

  /* Header */
  tmpstr = g_strjoin( NULL, "text", basename, "Header", NULL );
  textwidget = lookup_widget( GTK_WIDGET(propbox), tmpstr );
  g_free(tmpstr);
  
  tmpstr = g_strjoin( NULL, "check", basename, "Header", NULL );
  checkwidget = lookup_widget( GTK_WIDGET(propbox), tmpstr );
  g_free(tmpstr);
  
  tmpstr = g_strjoin( NULL, "/HtmlCodeConvert/", basename, "/Header", NULL );
  strval = g_string_new( gnome_config_get_string( tmpstr ) );
  g_free(tmpstr);

  strval = hex_to_str(strval);
  
  gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, strval->str, -1);  

  g_string_free(strval,TRUE);

  tmpstr = g_strjoin( NULL, "/HtmlCodeconvert/", basename, "/IncludeHeader", NULL );
  boolval = gnome_config_get_bool( tmpstr );
  g_free(tmpstr);

  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(checkwidget), boolval);
  gtk_widget_set_sensitive(textwidget,boolval);

  /* Footer */
  tmpstr = g_strjoin( NULL, "text", basename, "Footer", NULL );
  textwidget = lookup_widget( GTK_WIDGET(propbox), tmpstr );
  g_free(tmpstr);
  
  tmpstr = g_strjoin( NULL, "check", basename, "Footer", NULL );
  checkwidget = lookup_widget( GTK_WIDGET(propbox), tmpstr );
  g_free(tmpstr);

  tmpstr = g_strjoin( NULL, "/HtmlCodeconvert/", basename, "/Footer", NULL );
  strval = g_string_new( gnome_config_get_string( tmpstr ) );
  g_free(tmpstr);
  
  strval = hex_to_str(strval);
  
  gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, strval->str, -1);  

  g_string_free(strval,TRUE);

  tmpstr = g_strjoin( NULL, "/HtmlCodeConvert/", basename, "/IncludeFooter", NULL );
  boolval = gnome_config_get_bool( tmpstr );
  g_free(tmpstr);

  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(checkwidget), boolval);
  gtk_widget_set_sensitive(textwidget,boolval);
}

void
dialog_apply_callback( GnomePropertyBox *property_box, 
                       gint page_num, 
                       gpointer user_data )
{
  if (page_num != -1)
    return;

    apply_changes_setting (property_box);
}

void
apply_changes_setting( GnomePropertyBox *property_box )
{
  apply_one_setting( GTK_WIDGET(property_box), "JS" );
  apply_one_setting( GTK_WIDGET(property_box), "JSP" );
  apply_one_setting( GTK_WIDGET(property_box), "ASP" );
  apply_one_setting( GTK_WIDGET(property_box), "PHP" );
  apply_one_setting( GTK_WIDGET(property_box), "Perl" );
  apply_one_setting( GTK_WIDGET(property_box), "Shell" );

  gnome_config_drop_all();  
}

void
apply_one_setting( GtkWidget *widget,
                   gchar *basename )
{
  GtkWidget *text;
  GtkWidget *check;
  GString *strval;
  gchar *tmpstr;
  
  strval = g_string_new("");

  /* Header */
  tmpstr = g_strjoin( NULL, "text", basename, "Header", NULL );
  text = lookup_widget( GTK_WIDGET(widget), tmpstr );
  g_free(tmpstr);

  tmpstr = g_strjoin( NULL, "check", basename, "Header", NULL );
  check = lookup_widget( GTK_WIDGET(widget), tmpstr );
  g_free(tmpstr);

  tmpstr = gtk_editable_get_chars( GTK_EDITABLE(text), 0, -1);
  g_string_sprintf( strval, "%s", tmpstr );
  g_free(tmpstr);
  
  strval = str_to_hex(strval);

  tmpstr = g_strjoin( NULL, "/HtmlCodeConvert/", basename, "/Header", NULL );
  gnome_config_set_string( tmpstr, strval->str);
  g_free(tmpstr);

  tmpstr = g_strjoin( NULL, "/HtmlCodeConvert/", basename, "/IncludeHeader", NULL );
  gnome_config_set_bool( tmpstr, gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(check) ));        
  g_free(tmpstr);

  /* Footer */
  tmpstr = g_strjoin( NULL, "text", basename, "Footer", NULL );
  text = lookup_widget( GTK_WIDGET(widget), tmpstr );
  g_free(tmpstr);

  tmpstr = g_strjoin( NULL, "check", basename, "Footer", NULL );
  check = lookup_widget( GTK_WIDGET(widget), tmpstr );
  g_free(tmpstr);

  tmpstr = gtk_editable_get_chars( GTK_EDITABLE(text), 0, -1);
  g_string_sprintf( strval, "%s", tmpstr );
  g_free(tmpstr);

  strval = str_to_hex(strval);

  tmpstr = g_strjoin( NULL, "/HtmlCodeConvert/", basename, "/Footer", NULL );
  gnome_config_set_string( tmpstr, strval->str);
  g_free(tmpstr);

  tmpstr = g_strjoin( NULL, "/HtmlCodeConvert/", basename, "/IncludeFooter", NULL );
  gnome_config_set_bool( tmpstr, gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(check) ));        
  g_free(tmpstr);

  /* End */
  
  g_string_free(strval,TRUE);  
  gnome_config_sync();
}

void
include_header( GtkWidget *text,
                gchar *basename )
{
  gchar *strname;
  gboolean boolval ;
  
  strname = g_strjoin( NULL,"/HtmlCodeConvert/", basename, "/IncludeHeader", NULL);
  boolval = gnome_config_get_bool( strname );
  g_free(strname);
  
  if ( boolval )
  {
    GString *rep;
    strname = g_strjoin( NULL,"/HtmlCodeConvert/", basename, "/Header", NULL);
    rep = g_string_new( gnome_config_get_string(strname) );
    rep = hex_to_str(rep);
    gtk_text_insert ( GTK_TEXT(text), NULL, NULL, NULL, rep->str, -1);
    g_free(strname);
    g_string_free(rep,TRUE);
  }
}

void
include_footer( GtkWidget *text,
                gchar *basename )
{
  
  if ( inConvert )
  {
    gchar *strname;
    gboolean boolval ;
  
    strname = g_strjoin( NULL,"/HtmlCodeConvert/", basename, "/IncludeFooter", NULL);
    boolval = gnome_config_get_bool( strname );
    g_free(strname);
    
    if ( boolval )
    {
      GString *rep;
      gchar *tmpchr;
      guint textlen;
      
      textlen = gtk_text_get_length (GTK_TEXT(text));
      tmpchr = gtk_editable_get_chars(GTK_EDITABLE(text), textlen - 1 , textlen ); 

      if ( ( g_strcasecmp( tmpchr,"\n") != 0 ) )
        gtk_text_insert ( GTK_TEXT(text), NULL, NULL, NULL,"\n", -1);

      g_free(tmpchr);
      
      strname = g_strjoin( NULL,"/HtmlCodeConvert/", basename, "/Footer", NULL);
      rep = g_string_new( gnome_config_get_string(strname) );
      rep = hex_to_str(rep);
      
      gtk_text_insert ( GTK_TEXT(text), NULL, NULL, NULL, rep->str, -1);
      g_free(strname);
      g_string_free(rep,TRUE);
    }
  }
  
}

GString *
str_to_hex( GString *str )
{
  GString *rep;
  gint x;
  
  rep = g_string_new("");
  for ( x = 0; x < str->len; x++ )
    g_string_sprintfa( rep, "%02hhX",  str->str[x] ); 
 
  g_string_sprintf( str,"%s",rep->str);
  
  g_string_free(rep,TRUE);
  return str;
}

GString *
hex_to_str( GString *str )
{
  GString *rep;
  gint x;

  rep = g_string_new("");
  
  for (x = 0 ; x <= str->len - 2  ; x = x + 2 )
  {
    GString *tmp;

    tmp = g_string_new("");
    tmp = g_string_append_c( tmp,(gchar)str->str[x] );
    tmp = g_string_append_c( tmp, (gchar)str->str[x + 1] );
    
    g_string_sprintfa( rep, "%c",  (guchar) g_strtod( g_strconcat("0X",tmp->str,NULL),NULL ) ); 

    g_string_free(tmp,TRUE);
  }
  
  g_string_sprintf( str,"%s",rep->str);
  
  g_string_free(rep,TRUE);
 
  return str;
}

void
active_apply_prop ( GtkWidget *widget )
{
  GtkWidget *propbox;

  propbox = lookup_widget(GTK_WIDGET(widget),"propbox");
  gnome_property_box_changed( GNOME_PROPERTY_BOX(propbox) );
}

void
load_default_setting( GtkWidget *widget, 
                      gchar *basename )
{
  GtkWidget *textwidget;
  GtkWidget *checkwidget;
  gchar *tmpstr;

  /* Header */
  tmpstr = g_strjoin( NULL, "text", basename, "Header", NULL );
  textwidget = lookup_widget( GTK_WIDGET(widget), tmpstr );
  g_free(tmpstr);
  
  tmpstr = g_strjoin( NULL, "check", basename, "Header", NULL );
  checkwidget = lookup_widget( GTK_WIDGET(widget), tmpstr );
  g_free(tmpstr);
  
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(checkwidget), TRUE);
  gtk_widget_set_sensitive(textwidget,TRUE);
  
  /* freeze textHeader */
  gtk_text_freeze ( GTK_TEXT(textwidget));

  /* erase textHeader */
  if ( gtk_text_get_length( GTK_TEXT(textwidget) ) > 0 )
    gtk_editable_delete_text ( GTK_EDITABLE(textwidget), 0, -1 );
  
  if ( g_strcasecmp( basename, "JS") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, JS_header, -1);
  else if ( g_strcasecmp( basename, "JSP") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, JSP_header, -1);
  else if ( g_strcasecmp( basename, "ASP") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, ASP_header, -1);
  else if ( g_strcasecmp( basename, "PHP") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, PHP_header, -1);
  else if ( g_strcasecmp( basename, "Perl") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, Perl_header, -1);
  else if ( g_strcasecmp( basename, "Shell") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, Shell_header, -1);
  
  /* unfreeze textHeader */
  gtk_text_thaw ( GTK_TEXT(textwidget));  

  /* Footer */
  tmpstr = g_strjoin( NULL, "text", basename, "Footer", NULL );
  textwidget = lookup_widget( GTK_WIDGET(widget), tmpstr );
  g_free(tmpstr);
  
  tmpstr = g_strjoin( NULL, "check", basename, "Footer", NULL );
  checkwidget = lookup_widget( GTK_WIDGET(widget), tmpstr );
  g_free(tmpstr);
  
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(checkwidget), TRUE);
  gtk_widget_set_sensitive(textwidget,TRUE);
  
  /* freeze textFooter */
  gtk_text_freeze ( GTK_TEXT(textwidget));

  /* erase textFooter */
  if ( gtk_text_get_length( GTK_TEXT(textwidget) ) > 0 )
    gtk_editable_delete_text ( GTK_EDITABLE(textwidget), 0, -1 );
  
  if ( g_strcasecmp( basename, "JS") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, JS_footer, -1);
  else if ( g_strcasecmp( basename, "JSP") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, JSP_footer, -1);
  else if ( g_strcasecmp( basename, "ASP") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, ASP_footer, -1);
  else if ( g_strcasecmp( basename, "PHP") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, PHP_footer, -1);
  else if ( g_strcasecmp( basename, "Perl") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, Perl_footer, -1);
  else if ( g_strcasecmp( basename, "Shell") == 0 )
    gtk_text_insert ( GTK_TEXT(textwidget), NULL, NULL, NULL, Shell_footer, -1);
  
  /* unfreeze textFooter */
  gtk_text_thaw ( GTK_TEXT(textwidget));  
  
  active_apply_prop( GTK_WIDGET(widget) );
  
}
