/***************************************************************************
                          others.c  -  description
                             -------------------
    begin                : Mon Mar 4 2002
    copyright            : (C) 2002 by Steeve Beaudin
    email                : steevebeaudin@netscape.net
 ***************************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <libgnomeui/gnome-window-icon.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include "others.h"
#include "def.h"
#include "setting.h"

#include "icondata.h"


void
init_app( GtkWidget *widget )
{
  GtkWidget *textsource;
  GtkWidget *pixmaplogo;
  GtkWidget *buttontmp;
  GtkWidget *toolbar;
  GtkWidget *menuitem;
  gchar *pathicon;

  /* Set default icon for app */
  pathicon = gnome_pixmap_file ("HtmlCodeConvert/htmlcodeconvert-mini.xpm");
  if ( pathicon != NULL )
  {
    GtkWidget *appicon;
    
    gnome_window_icon_set_default_from_file(pathicon);
    appicon = lookup_widget(GTK_WIDGET(widget),"appMain");
    gnome_window_icon_set_from_default ( (GtkWindow *) appicon );
  }
  g_free(pathicon);
  
  /* create image and put in pixmaplogo, pixmapHTML, pixmapConvert */
  pixmaplogo = lookup_widget(GTK_WIDGET(widget),"pixmaplogo");
  gnome_pixmap_load_xpm_d ( GNOME_PIXMAP(pixmaplogo), ( gchar **) ti_lapin_xpm );

  pixmaplogo = lookup_widget(GTK_WIDGET(widget),"pixmapHTML");
  gnome_pixmap_load_xpm_d ( GNOME_PIXMAP(pixmaplogo), ( gchar **) ti_lapin_bleu_xpm );

  pixmaplogo = lookup_widget(GTK_WIDGET(widget),"pixmapConvert");
  gnome_pixmap_load_xpm_d ( GNOME_PIXMAP(pixmaplogo), ( gchar **) stock_convert );

  /* === Section create button in toolbar === */
  toolbar = lookup_widget(GTK_WIDGET(widget),"toolbar");
  /* button HTML */
  buttontmp = gtk_toolbar_insert_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("HTML"),
                                _("Display HTML source."), NULL,
                                gnome_pixmap_new_from_xpm_d(( gchar **) ti_lapin_bleu_xpm), NULL, NULL,3);
  gtk_widget_set_name (buttontmp, "buttonHTML");
  gtk_widget_ref (buttontmp);
  gtk_object_set_data_full (GTK_OBJECT (widget), "buttonHTML", buttontmp,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (buttontmp), "clicked",
                      GTK_SIGNAL_FUNC (on_buttonHTML_clicked),
                      NULL);
  gtk_widget_show (buttontmp);

  /* button Convert */
  buttontmp = gtk_toolbar_insert_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Convert"),
                                _("Display convert code."), NULL,
                                gnome_pixmap_new_from_xpm_d(( gchar **) stock_convert), NULL, NULL,4);
  gtk_widget_set_name (buttontmp, "buttonConvert");
  gtk_widget_ref (buttontmp);
  gtk_object_set_data_full (GTK_OBJECT (widget), "buttonConvert", buttontmp,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (buttontmp), "clicked",
                      GTK_SIGNAL_FUNC (on_buttonConvert_clicked),
                      NULL);
  gtk_widget_show (buttontmp);

  gtk_toolbar_insert_space( GTK_TOOLBAR(toolbar),5);
  /* === End section create button toolbar === */

  gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(widget),"buttonHTML"), FALSE);
  gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(widget),"buttonStop"), FALSE);

  /* Connect File menu item */
  menuitem = lookup_widget(GTK_WIDGET(widget),"file");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
                      GTK_SIGNAL_FUNC (on_file_activate),
                      NULL);

  /* Connect Edit menu item */
  menuitem = lookup_widget(GTK_WIDGET(widget),"edit");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
                      GTK_SIGNAL_FUNC (on_edit_activate),
                      NULL);

  /* Connect View menu item */
  menuitem = lookup_widget(GTK_WIDGET(widget),"view");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
                      GTK_SIGNAL_FUNC (on_view_activate),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (widget), "delete_event",
                      GTK_SIGNAL_FUNC (delete_event), NULL);

  textsource = lookup_widget(GTK_WIDGET(widget),"textHTML");

  gtk_signal_connect ( GTK_OBJECT (textsource), "changed", 
                      GTK_SIGNAL_FUNC (source_changed),NULL);


  write_default_setting();

  lastconvert = HTML;
  path_file_open = g_string_new("");
  path_file_save = g_string_new("");
  sourcechanged = FALSE;
  inConvert = FALSE;
  
}

void
terminate_app (void)
{
  gnome_config_drop_all();  
  g_string_free(path_file_open,TRUE);
  g_string_free(path_file_save,TRUE);
}

gint 
delete_event ( GtkWidget *widget,
               GdkEvent *event,
               gpointer user_data )
{
  terminate_app();
  return(FALSE);
}

void
open_filename( GtkFileSelection *selector,
               gpointer user_data )
{
  GtkWidget *textHTML;
  GtkWidget *notebook;
  GString *selected_filename;

  textHTML = lookup_widget(GTK_WIDGET(user_data),"textHTML");
  notebook = lookup_widget(GTK_WIDGET(user_data),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 1 )
  {
    gtk_notebook_set_page((GTK_NOTEBOOK(notebook)), 0 );
  }

  selected_filename = g_string_new( gtk_file_selection_get_filename (GTK_FILE_SELECTION(file_selector)) );

  /* file select is not null and have read access ? */
  if ( possible_open_file(selected_filename->str) )
  {
    FILE * filestream;
    const guint LINE_LENGTH = 1023;
    gchar line[LINE_LENGTH];
    
    /* save file name */
    g_string_assign ( path_file_open, selected_filename->str );

    /* freeze textHTML redraw */
    gtk_text_freeze ( GTK_TEXT(textHTML));

    /* erase textHTML */
    if ( gtk_text_get_length( GTK_TEXT(textHTML) ) > 0 )
    {
      gtk_editable_delete_text ( GTK_EDITABLE(textHTML), 0, -1 );
    }

    status_mess( GTK_WIDGET(user_data), g_strjoin(NULL, _("Loading file: "),g_basename(selected_filename->str),NULL ) );

    filestream = fopen (selected_filename->str, "r");

    while ( fgets(line, LINE_LENGTH, filestream) != NULL)
    {
      gtk_text_insert ( GTK_TEXT(textHTML), NULL, NULL, NULL, line, -1);
      while (gtk_events_pending()) gtk_main_iteration();
    }

    fclose (filestream); 

    /* put cursor on first char of text */
    if ( gtk_text_get_length( GTK_TEXT(textHTML) ) > 0 )
    {
      gtk_editable_set_position ( GTK_EDITABLE(textHTML), 0);
    }

    /* unfreeze textHTML redraw */
    gtk_text_thaw ( GTK_TEXT(textHTML));
  }

  erase_statusbar( GTK_WIDGET(user_data) , NULL );
 
  g_string_free( selected_filename, TRUE );

  sourcechanged = FALSE;
}

void
cancel_select_filename( GtkWidget *widget,
                        gpointer user_data )
{
  erase_statusbar( GTK_WIDGET(user_data), NULL);
  gtk_widget_destroy(GTK_WIDGET(file_selector));
}

gboolean
possible_open_file ( gchar * file )
{
  struct stat stat_p;

  if ( stat( file, &stat_p) == -1 )
  {
    g_warning( _("Error in retrieve file stat for : %s"), file );
    return FALSE;
  }

  /* Normal file */ 
  if ( S_ISREG(stat_p.st_mode) == 0 )
  {
    g_warning( _("Error for open %s, is not normal file."), file );
    return FALSE;
  }

  /* User  read access ? */
  if ( ((S_IRUSR & stat_p.st_mode) == S_IRUSR) && ( getuid() == stat_p.st_uid ) )
  {
    return TRUE;
  }

  /* Group read access ? */
  if ( ((S_IRGRP & stat_p.st_mode) == S_IRGRP) && ( getgid() == stat_p.st_gid ) )
  {
    return TRUE;
  }

  /* Others read access ? */
  if ( (S_IROTH  & stat_p.st_mode) == S_IROTH )
  {
    return TRUE;
  }
  g_warning( _("Error for open %s, you don't have read access."), file );

  return FALSE;
}

void
save_file ( GtkWidget *widget,
            gpointer user_data )
{
  GtkWidget *textsource;
  GtkWidget *notebook;
  FILE *fp;
  guint textlen;
  guint x;
  gchar *tmpchr = NULL;

  status_mess( GTK_WIDGET(widget), g_strjoin(NULL, _("Saving file: "),g_basename(path_file_save->str),NULL ) );
  
  notebook = lookup_widget(GTK_WIDGET(widget),"notebookHTMLConvert");

  while (gtk_events_pending()) gtk_main_iteration();

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 0 )
  {
    textsource = lookup_widget(GTK_WIDGET(widget),"textHTML");
    g_string_assign (path_file_open, path_file_save->str);

    sourcechanged = FALSE;
  }
  else
  {
    textsource = lookup_widget(GTK_WIDGET(widget),"textConvert");
  }

  textlen = gtk_text_get_length (GTK_TEXT(textsource));

  fp = fopen( path_file_save->str, "w");

  for ( x = 0; x < textlen; x++ )
  {
    tmpchr = gtk_editable_get_chars(GTK_EDITABLE(textsource), x, x+1 );
    fputs(tmpchr, fp);
  }

  fclose(fp);
  g_free(tmpchr);

  erase_statusbar( GTK_WIDGET(widget), NULL );
}

gboolean
possible_write_file ( gchar * file )
{
  struct stat stat_p;
  gchar *dirname = NULL ;

  if ( stat( file, &stat_p) == -1 )  /* make test on file */
  {
    dirname = g_dirname (file);

    if ( stat( dirname, &stat_p) == -1 )  /* make test on directory */
    {
      g_free (dirname);
      g_warning( _("Error for %s, you don't have access on directory."), file );
      return FALSE;
    }
    else
      g_free(dirname);
  }
  
  /* User  write access ? */
  if ( ((S_IWUSR & stat_p.st_mode) == S_IWUSR) && ( getuid() == stat_p.st_uid ) )
  {
    return TRUE;
  }

  /* Group write access ? */
  if ( ((S_IWGRP & stat_p.st_mode) == S_IWGRP) && ( getgid() == stat_p.st_gid ) )
  {
    return TRUE;
  }

  /* Others write access ? */
  if ( (S_IWOTH  & stat_p.st_mode) == S_IWOTH )
  {
    return TRUE;
  }
  g_warning( _("Error for %s, you don't have write access."), file );

  return FALSE;
}


void 
source_changed ( GtkWidget *widget,
                 gpointer user_data)
{
  sourcechanged = TRUE;
}

void 
select_file_save ( GtkWidget *widget,
                   gpointer user_data)
{
  GString *selected_filename;

  selected_filename = g_string_new( gtk_file_selection_get_filename (GTK_FILE_SELECTION(file_selector)) );
  
  if ( ! g_file_test (selected_filename->str, G_FILE_TEST_ISDIR ) )
  {
    if ( possible_write_file(selected_filename->str) )
    {
      g_string_assign ( path_file_save, selected_filename->str );

      if ( ! g_file_exists(selected_filename->str) )
        save_file( GTK_WIDGET(user_data), user_data);
      else
        create_overwrite_diag(GTK_WIDGET(widget),user_data);
    }
  }
  else
    g_warning( _("File not saved, you have select directory.") );
    
  g_string_free( selected_filename, TRUE );
}

void 
create_overwrite_diag                    ( GtkWidget *widget,
                                           gpointer user_data)
{
  GtkWidget *buttonYes;
  GtkWidget *buttonNo;
  GtkWidget *labelfilename;
  GtkWidget *labelWarning;
  GdkColor redcolor;
  GtkRcStyle *rc_style_red;

  file_selector = create_dialogOverWrite();
  gnome_window_icon_set_from_default ( GTK_WINDOW(file_selector) );
  buttonYes = lookup_widget(GTK_WIDGET(file_selector),"buttonYes");
  buttonNo = lookup_widget(GTK_WIDGET(file_selector),"buttonNo");
  labelfilename = lookup_widget(GTK_WIDGET(file_selector),"labelFileName");
  labelWarning = lookup_widget(GTK_WIDGET(file_selector),"labelWarning");

  gtk_label_set_text ( GTK_LABEL(labelfilename), path_file_save->str );
  
      
  gtk_signal_connect_object ( GTK_OBJECT (buttonYes), "clicked", 
                              GTK_SIGNAL_FUNC (save_file), GTK_OBJECT(user_data) );
  
  gtk_signal_connect_object ( GTK_OBJECT (buttonYes), "clicked", 
                              GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(file_selector) );

  gtk_signal_connect_object ( GTK_OBJECT (buttonNo), "clicked", 
                              GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(file_selector) );

  redcolor.red = 20000;
  redcolor.green = 0;
  redcolor.blue = 0;
  rc_style_red = gtk_rc_style_new ();
  rc_style_red->fg[GTK_STATE_NORMAL] = redcolor;
  rc_style_red->color_flags[GTK_STATE_NORMAL] |= GTK_RC_FG ;
  gtk_widget_modify_style (labelWarning, rc_style_red);
  gtk_rc_style_unref (rc_style_red);

  gtk_widget_show (file_selector);
}

void
status_mess ( GtkWidget *widget,
              gchar *mess )
{
  GtkWidget *statusbar;

  statusbar = lookup_widget(GTK_WIDGET(widget),"statusbar");

  gnome_appbar_pop ( GNOME_APPBAR(statusbar) );
  gnome_appbar_push ( GNOME_APPBAR(statusbar), mess );

  while (gtk_events_pending()) gtk_main_iteration();
}

void
erase_statusbar                          ( GtkWidget *widget,
                                           gpointer user_data )
{
  GtkWidget *statusbar;

  statusbar = lookup_widget( GTK_WIDGET(widget),"statusbar");
  gnome_appbar_pop ( GNOME_APPBAR(statusbar) );
}

void
create_openfile_dialog                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GString *pathfileselector;

  pathfileselector = g_string_new ("");

  file_selector = gtk_file_selection_new(_("Select HTML source."));

  gtk_window_set_modal ( GTK_WINDOW(file_selector), TRUE );
  gtk_window_set_position (GTK_WINDOW (file_selector), GTK_WIN_POS_MOUSE);

  gnome_window_icon_set_from_default ( GTK_WINDOW(file_selector) );

  gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->ok_button), 
                      "clicked", GTK_SIGNAL_FUNC (open_filename), (gpointer *)widget);
  
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
                              "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT(file_selector) );

  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
                             "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT(file_selector) );
    
  if ( g_strcasecmp(path_file_open->str,"") != 0 )
  {
    gchar *tmpdir;
    tmpdir = g_dirname(path_file_open->str);
    g_string_sprintf(pathfileselector, "%s%s",tmpdir, "/");

    g_free(tmpdir);   
  }
  else
  {
    g_string_sprintf(pathfileselector, "%s%s",g_get_home_dir(), "/");
  } 

  gtk_file_selection_set_filename ( GTK_FILE_SELECTION(file_selector), pathfileselector->str );


  g_string_free( pathfileselector, TRUE );

  gtk_widget_show (file_selector);
}

void
create_save_as_dialog                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GString *pathfileselector;
  GtkWidget *notebook;

  pathfileselector = g_string_new("");

  notebook = lookup_widget(GTK_WIDGET(widget),"notebookHTMLConvert");

  file_selector = gtk_file_selection_new(_("Select destination."));
     
  gtk_window_set_modal ( GTK_WINDOW(file_selector), TRUE );
  gtk_window_set_position (GTK_WINDOW (file_selector), GTK_WIN_POS_MOUSE);
  
  gnome_window_icon_set_from_default ( GTK_WINDOW(file_selector) );

  gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->ok_button), 
                      "clicked", GTK_SIGNAL_FUNC (select_file_save), (gpointer *)widget);
  
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
                              "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                              GTK_OBJECT(file_selector) );

  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
                             "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                              GTK_OBJECT(file_selector) );

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 0 )
  {
    /* Create name for source HTML */
    if ( g_strcasecmp(path_file_open->str,"") != 0  )
    {
      gchar *tmpdir;
      tmpdir = g_dirname(path_file_open->str);
      g_string_sprintf(pathfileselector,"%s%s",tmpdir, "/untitled.html");
      g_free(tmpdir);   
    }
    else
    {
      g_string_sprintf(pathfileselector,"%s%s",g_get_home_dir(), "/untitled.html");
    } 
  }
  else
  {
    if ( g_strcasecmp(path_file_open->str,"") != 0  )
    {
      /* Create file name for text convert, from file open. */
      gchar *tmpname;
      gchar *dirname;
      gchar *ext = NULL;
      gchar **splitname;

      if ( lastconvert == JS )       ext =  g_strdup(".js"); 
      else if ( lastconvert == JSP ) ext =  g_strdup(".jsp"); 
      else if ( lastconvert == ASP ) ext =  g_strdup(".asp"); 
      else if ( lastconvert == PHP ) ext =  g_strdup(".php"); 
      else if ( lastconvert == PL )  ext =  g_strdup(".pl"); 
      else if ( lastconvert == SH )  ext =  g_strdup(".sh"); 

      tmpname = g_strdup( g_basename(path_file_open->str) );
      g_strreverse (tmpname);
      splitname= g_strsplit (tmpname, ".", 1);
            
      g_free(tmpname);
      if ( *(splitname + 1) != NULL )
      {
        tmpname = g_strdup( *(splitname + 1 ) );
      }
      else
      {
        tmpname = g_strdup( *(splitname) );
      }

      g_strreverse (tmpname);
      dirname = g_dirname(path_file_open->str);

      g_string_sprintf(pathfileselector, "%s%s%s%s", dirname, "/", tmpname, ext);

      g_strfreev(splitname);
      g_free(ext);
      g_free(dirname);
      g_free(tmpname);
    }
    else
    {
      /* Create file name for text convert, from scratch. */
      if ( lastconvert == JS )
        g_string_sprintf(pathfileselector,"%s%s", g_get_home_dir(),"/untitled.js"); 
      else if ( lastconvert == JSP )
        g_string_sprintf(pathfileselector,"%s%s", g_get_home_dir(),"/untitled.jsp"); 
      else if ( lastconvert == ASP )
        g_string_sprintf(pathfileselector,"%s%s", g_get_home_dir(),"/untitled.asp"); 
      else if ( lastconvert == PHP )
        g_string_sprintf(pathfileselector,"%s%s", g_get_home_dir(),"/untitled.php"); 
      else if ( lastconvert == PL )
        g_string_sprintf(pathfileselector,"%s%s", g_get_home_dir(),"/untitled.pl"); 
      else if ( lastconvert == SH )
        g_string_sprintf(pathfileselector,"%s%s", g_get_home_dir(),"/untitled.sh"); 
    }
  }

  gtk_file_selection_set_filename (GTK_FILE_SELECTION(file_selector), pathfileselector->str );

  g_string_free( pathfileselector, TRUE );

  gtk_widget_show (file_selector);
}

void
set_state_menu_start_convert            ( GtkWidget *widget )
{
  GtkWidget *tmpWidget;

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"file");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"edit");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);
  
  tmpWidget = lookup_widget(GTK_WIDGET(widget),"view");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);
  
  tmpWidget = lookup_widget(GTK_WIDGET(widget),"settings");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);
  
  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonOpen");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonSaveAs");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonHTML");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);
  
  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonConvert");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonStop");
  gtk_widget_set_sensitive ( tmpWidget, TRUE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonQuit");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);
}

void
set_state_menu_terminate_convert        ( GtkWidget *widget )
{
  GtkWidget *tmpWidget;

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"file");
  gtk_widget_set_sensitive ( tmpWidget, TRUE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"edit");
  gtk_widget_set_sensitive ( tmpWidget, TRUE);
  
  tmpWidget = lookup_widget(GTK_WIDGET(widget),"view");
  gtk_widget_set_sensitive ( tmpWidget, TRUE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"settings");
  gtk_widget_set_sensitive ( tmpWidget, TRUE);
  
  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonOpen");
  gtk_widget_set_sensitive ( tmpWidget, TRUE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonSaveAs");
  gtk_widget_set_sensitive ( tmpWidget, TRUE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonHTML");
  gtk_widget_set_sensitive ( tmpWidget, TRUE);
  
  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonConvert");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonStop");
  gtk_widget_set_sensitive ( tmpWidget, FALSE);

  tmpWidget = lookup_widget(GTK_WIDGET(widget),"buttonQuit");
  gtk_widget_set_sensitive ( tmpWidget, TRUE);
}
