/***************************************************************************
                          convert.c  -  description
                             -------------------
    begin                : Mon Mar 4 2002
    copyright            : (C) 2002 by Steeve Beaudin
    email                : steevebeaudin@netscape.net
 ***************************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include <string.h>
#include "convert.h"
#include "others.h"
#include "setting.h"

void
convert_JS ( GtkWidget *widget )
{
  GtkWidget *textConvert;

  lastconvert = JS;

  textConvert = lookup_widget(GTK_WIDGET(widget),"textConvert");

  status_mess( widget, _("Prepare convert to Java Script.") );

  /* freeze textConvert redraw */
  gtk_text_freeze ( GTK_TEXT(textConvert));

  /* erase textConvert */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_delete_text ( GTK_EDITABLE(textConvert), 0, -1 );

  include_header( textConvert, "JS" );

  convertsource( GTK_WIDGET(widget), JS); 

  include_footer( textConvert, "JS" );

  status_mess( widget, _("Terminate") );

  /* put cursor on first char of text */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_set_position ( GTK_EDITABLE(textConvert), 0);

  /* unfreeze textConvert redraw */
  gtk_text_thaw ( GTK_TEXT(textConvert));

  erase_statusbar( GTK_WIDGET(widget), NULL );
}

void
build_line_JS ( GString * line )
{
  /* Escapes all ' " ' */
  str_escape_dquote(line, "\\\"");

  if ( is_end_by( line->str, "\n") )
  {

    g_string_truncate(line,line->len -1 );
    g_string_prepend(line,"document.writeln(\"");
    g_string_append (line, "\");\n");
  }
  else
  {
    g_string_prepend(line,"document.writeln(\"");
    g_string_append (line, "\");");
  }
}

void
convert_JSP ( GtkWidget *widget )
{
  GtkWidget *textConvert;

  lastconvert = JSP;

  textConvert = lookup_widget(GTK_WIDGET(widget),"textConvert");

  status_mess( widget, _("Prepare convert to JavaServer Pages.") );

  /* freeze textConvert redraw */
  gtk_text_freeze ( GTK_TEXT(textConvert));

  /* erase textConvert */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_delete_text ( GTK_EDITABLE(textConvert), 0, -1 );

  include_header( textConvert, "JSP" );

  convertsource( GTK_WIDGET(widget), JSP); 

  include_footer( textConvert, "JSP" );

  status_mess( widget, _("Terminate") );

  /* put cursor on first char of text */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_set_position ( GTK_EDITABLE(textConvert), 0);

  /* unfreeze textConvert redraw */
  gtk_text_thaw ( GTK_TEXT(textConvert));

  erase_statusbar( GTK_WIDGET(widget), NULL );
}

void
build_line_JSP ( GString *line )
{
  /* Escapes all ' " ' */
  str_escape_dquote(line, "\\\"");

  if ( is_end_by( line->str, "\n") )
  {

    g_string_truncate(line,line->len -1 );
    g_string_prepend(line,"out.println(\"");
    g_string_append (line, "\");\n");
  }
  else
  {
    g_string_prepend(line,"out.println(\"");
    g_string_append (line, "\");");
  }
}

void
convert_ASP ( GtkWidget *widget )
{
  GtkWidget *textConvert;

  lastconvert = ASP;

  textConvert = lookup_widget(GTK_WIDGET(widget),"textConvert");

  status_mess( widget, _("Prepare convert to ASP.") );

  /* freeze textConvert redraw */
  gtk_text_freeze ( GTK_TEXT(textConvert));

  /* erase textConvert */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_delete_text ( GTK_EDITABLE(textConvert), 0, -1 );

  include_header( textConvert, "ASP" );
  
  convertsource( GTK_WIDGET(widget), ASP); 

  include_footer( textConvert, "ASP" );

  status_mess( widget, _("Terminate") );

  /* put cursor on first char of text */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_set_position ( GTK_EDITABLE(textConvert), 0);

  /* unfreeze textConvert redraw */
  gtk_text_thaw ( GTK_TEXT(textConvert));

  erase_statusbar( GTK_WIDGET(widget), NULL );
}

void 
build_line_ASP ( GString *line )
{
  /* Escapes all ' " ' */
  str_escape_dquote(line, "\"\"");

  if ( is_end_by( line->str, "\n") )
  {
    g_string_truncate(line,line->len -1 );
    g_string_prepend(line, "Response.write \"");
    g_string_append (line, "\" & vbCrLf\n");
  }
  else
  {
    g_string_prepend(line,"Response.write \"");
    g_string_append (line, "\"\n");
  }
}

void
convert_PHP ( GtkWidget *widget )
{
  GtkWidget *textConvert;

  lastconvert = PHP;

  textConvert = lookup_widget(GTK_WIDGET(widget),"textConvert");

  status_mess( widget, _("Prepare convert to PHP.") );

  /* freeze textConvert redraw */
  gtk_text_freeze ( GTK_TEXT(textConvert));

  /* erase textConvert */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_delete_text ( GTK_EDITABLE(textConvert), 0, -1 );

  include_header( textConvert, "PHP" );

  convertsource( GTK_WIDGET(widget), PHP); 

  include_footer( textConvert, "PHP" );

  status_mess( widget, _("Terminate") );

  /* put cursor on first char of text */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_set_position ( GTK_EDITABLE(textConvert), 0);

  /* unfreeze textConvert redraw */
  gtk_text_thaw ( GTK_TEXT(textConvert));

  erase_statusbar( GTK_WIDGET(widget), NULL );
}

void
build_line_PHP ( GString *line )
{
  /* Escapes all ' " ' */
  str_escape_dquote(line, "\\\"");

  if ( is_end_by( line->str, "\n") )
  {
    g_string_truncate(line,line->len -1 );
    g_string_prepend(line, "echo \"");
    g_string_append (line, "\\n\";\n");
  }
  else
  {
    g_string_prepend(line,"echo \"");
    g_string_append (line, "\\n\";\n");
  }
}

void
convert_Perl ( GtkWidget *widget )
{
  GtkWidget *textConvert;

  lastconvert = PL;

  textConvert = lookup_widget(GTK_WIDGET(widget),"textConvert");

  status_mess( widget, _("Prepare convert to Perl.") );

  /* freeze textConvert redraw */
  gtk_text_freeze ( GTK_TEXT(textConvert));

  /* erase textConvert */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_delete_text ( GTK_EDITABLE(textConvert), 0, -1 );

  include_header( textConvert, "Perl" );
  
  convertsource( GTK_WIDGET(widget), PL); 

  include_footer( textConvert, "Perl" );

  status_mess( widget, ("Terminate") );

  /* put cursor on first char of text */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_set_position ( GTK_EDITABLE(textConvert), 0);

  /* unfreeze textConvert redraw */
  gtk_text_thaw ( GTK_TEXT(textConvert));

  erase_statusbar( GTK_WIDGET(widget), NULL );
}

void
build_line_Perl ( GString *line )
{
  /* Escapes all ' " ' */
  str_escape_dquote(line, "\\\"");

  if ( is_end_by( line->str, "\n") )
  {
    g_string_truncate(line,line->len -1 );
    g_string_prepend(line, "print \"");
    g_string_append (line, "\\n\";\n");
  }
  else
  {
    g_string_prepend(line,"print \"");
    g_string_append (line, "\\n\";\n");
  }
}


void
convert_Shell ( GtkWidget *widget )
{
  GtkWidget *textConvert;

  lastconvert = SH;

  textConvert = lookup_widget(GTK_WIDGET(widget),"textConvert");

  status_mess( widget, _("Prepare convert to Shell.") );

  /* freeze textConvert redraw */
  gtk_text_freeze ( GTK_TEXT(textConvert));

  /* erase textConvert */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_delete_text ( GTK_EDITABLE(textConvert), 0, -1 );

  include_header( textConvert, "Shell" );
  
  convertsource( GTK_WIDGET(widget), SH); 

  include_footer( textConvert, "Shell" );

  status_mess( widget, _("Terminate") );

  /* put cursor on first char of text */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
    gtk_editable_set_position ( GTK_EDITABLE(textConvert), 0);

  /* unfreeze textConvert redraw */
  gtk_text_thaw ( GTK_TEXT(textConvert));

  erase_statusbar( GTK_WIDGET(widget), NULL );
}

void
build_line_Shell ( GString *line )
{
  /* Escapes all ' " ' */
  str_escape_dquote(line, "\\\"");

  if ( is_end_by( line->str, "\n") )
  {
    g_string_truncate(line,line->len -1 );
    g_string_prepend(line, "echo \"");
    g_string_append (line, "\";\n");
  }
  else
  {
    g_string_prepend(line,"echo \"");
    g_string_append (line, "\";\n");
  }
}

void
convertsource ( GtkWidget *widget, 
                TYPEFILE type )
{
  GtkWidget *textHTML;
  GtkWidget *textConvert;
  guint textlen;
  gchar *tmpchr;
  GString *tmpstr;
  GString *strmess; 
  gint x;
  gint nbline = 0;
  gint lineconv = 0;

  strmess = g_string_new("");
  tmpstr = g_string_new("");

  textHTML = lookup_widget(GTK_WIDGET(widget),"textHTML");
  textConvert = lookup_widget(GTK_WIDGET(widget),"textConvert");

  textlen = gtk_text_get_length (GTK_TEXT(textHTML));
  
  for ( x = 0; x < textlen; x++ )
  {
    tmpchr = gtk_editable_get_chars(GTK_EDITABLE(textHTML), x, x+1 ); 
    if ( ( g_strcasecmp( tmpchr,"\n") == 0 ) || ( g_strcasecmp( tmpchr,"\n") != 0  && x == textlen -1 ) )
    {
      nbline++;
    }
    g_free(tmpchr);
  }
      
  for ( x = 0; x < textlen; x++ )
  {
    if ( inConvert ) 
    {
      tmpchr = gtk_editable_get_chars(GTK_EDITABLE(textHTML), x, x+1 ); 
      if ( ( g_strcasecmp( tmpchr,"\n") != 0 ) && ( x != textlen -1) )
      {
        g_string_append(tmpstr,tmpchr);
        g_free(tmpchr);

        while (gtk_events_pending()) gtk_main_iteration();
      }
      else
      {
        g_string_append(tmpstr,tmpchr);
        lineconv++;

        g_string_sprintf(strmess, _("Convert lines ( %d / %d )") ,lineconv, nbline );

        status_mess( widget, strmess->str );
      
        if ( type == JS )
        {
          build_line_JS (tmpstr);
        }
        else if ( type == JSP )
        {
          build_line_JSP (tmpstr);
        }
        else if ( type == ASP )
        {
          build_line_ASP (tmpstr);
        }
        else if ( type == PHP )
        {
          build_line_PHP (tmpstr);
        }
        else if ( type == PL )
        {
          build_line_Perl (tmpstr);
        }
        else if ( type == SH )
        {
          build_line_Shell (tmpstr);
        }

        gtk_text_insert ( GTK_TEXT(textConvert), NULL, NULL, NULL,tmpstr->str, -1);
        g_string_assign (tmpstr, "");
        g_free(tmpchr);

        while (gtk_events_pending()) gtk_main_iteration();
      }
    }
  }

  if ( !inConvert )
  {
    gtk_text_insert ( GTK_TEXT(textConvert), NULL, NULL, NULL, "\n", -1);
    gtk_text_insert ( GTK_TEXT(textConvert), NULL, NULL, NULL, _("*** WARNING: Conversion stopped by user... ***"), -1);
  }

  g_string_free(tmpstr,TRUE);
  g_string_free(strmess,TRUE);
}


void
str_escape_dquote ( GString *line, gchar *escape )
{
  GString *ret;
  gchar *tmpchr = NULL;
  guint x;
  
  ret=g_string_new("");

  /* Escapes all ' " ' */
  for ( x = 0; x < line->len; x++ )
  {
    tmpchr=g_strdup_printf ("%c%s" , line->str[x],"");
    if ( g_strcasecmp( tmpchr ,"\"") == 0 )
    {
      g_string_append( ret, escape);
    }
    else
    {
      g_string_append_c( ret, line->str[x]);
    }
    g_free(tmpchr);
  }

  g_string_assign(line,ret->str);
  g_string_free(ret,TRUE);
}

gboolean
is_end_by ( gchar *line, 
            gchar * chr )
{
  gchar *tmpchr;
  tmpchr=g_strdup_printf ("%c%s" , line[strlen(line)-1],"");
  if ( g_strcasecmp( tmpchr ,chr) == 0 )
  {
    g_free(tmpchr);
    return TRUE;
  }
  g_free(tmpchr);
  return FALSE;
}

