#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <libgnomeui/gnome-window-icon.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "convert.h"
#include "others.h"
#include "setting.h"
#include "icondata.h"


void
on_file_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *notebook;
  GtkWidget *menusave;

  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");
  menusave = lookup_widget(GTK_WIDGET(menuitem),"save");

  /* Set Menuitem Save */
  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 0 )
  {
    if ( g_strcasecmp(path_file_open->str,"") != 0  && sourcechanged ) 
    {
      gtk_widget_set_sensitive ( menusave, TRUE);
    }
    else
    {
      gtk_widget_set_sensitive ( menusave, FALSE);
    }
  }
  else
  {
    gtk_widget_set_sensitive ( menusave, FALSE);
  }
}

void
on_open_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  create_openfile_dialog ( GTK_WIDGET(menuitem), user_data);
}


void
on_save_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if ( possible_write_file(path_file_open->str) )
  {
    g_string_assign ( path_file_save, path_file_open->str );
    save_file( GTK_WIDGET(menuitem), NULL );
  }
}


void
on_save_as_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  create_save_as_dialog ( GTK_WIDGET(menuitem), user_data);
}


void
on_close_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *textHTML;
  GtkWidget *textConvert;
  GtkWidget *notebook;
  GtkWidget *radiobuttonJS;

  status_mess( GTK_WIDGET(menuitem), _("Close all files.") );

  textHTML = lookup_widget(GTK_WIDGET(menuitem),"textHTML");
  textConvert = lookup_widget(GTK_WIDGET(menuitem),"textConvert");
  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");
  radiobuttonJS = lookup_widget(GTK_WIDGET(menuitem),"radiobuttonJS");

  /* freeze textHTML redraw */
  gtk_text_freeze ( GTK_TEXT(textHTML));

  /* erase textHTML */
  if ( gtk_text_get_length( GTK_TEXT(textHTML) ) > 0 )
  {
    gtk_editable_delete_text ( GTK_EDITABLE(textHTML), 0, -1 );
  }

  /* unfreeze textHTML redraw */
  gtk_text_thaw ( GTK_TEXT(textHTML));

  /* freeze textConvert redraw */
  gtk_text_freeze ( GTK_TEXT(textConvert));

  /* erase textConvert */
  if ( gtk_text_get_length( GTK_TEXT(textConvert) ) > 0 )
  {
    gtk_editable_delete_text ( GTK_EDITABLE(textConvert), 0, -1 );
  }

  /* unfreeze textConvert redraw */
  gtk_text_thaw ( GTK_TEXT(textConvert));

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 1 )
  {
    gtk_notebook_set_page((GTK_NOTEBOOK(notebook)), 0 );
  }

  gtk_toggle_button_set_active    ( GTK_TOGGLE_BUTTON(radiobuttonJS), TRUE);

  lastconvert = HTML;

  g_string_assign(path_file_open, "");
  g_string_assign(path_file_save, "");

  sourcechanged = FALSE;

  erase_statusbar( GTK_WIDGET(menuitem), NULL );
}


void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  terminate_app();
  gtk_main_quit();
}


void
on_edit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 0 )
  {
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(menuitem),"cut"), TRUE);
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(menuitem),"paste"), TRUE);
  }
  else
  {
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(menuitem),"cut"), FALSE);
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(menuitem),"paste"), FALSE);
  }
}


void
on_cut_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *text = NULL;
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 0 )
  {
    text = lookup_widget(GTK_WIDGET(menuitem),"textHTML");
  }
  else
  {
    text = lookup_widget(GTK_WIDGET(menuitem),"textConvert");
  }

  gtk_editable_cut_clipboard ( GTK_EDITABLE(text) );
}


void
on_copy_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *text = NULL;
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 0 )
  {
    text = lookup_widget(GTK_WIDGET(menuitem),"textHTML");
  }
  else
  {
    text = lookup_widget(GTK_WIDGET(menuitem),"textConvert");
  }

  gtk_editable_copy_clipboard ( GTK_EDITABLE(text) );
}


void
on_paste_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *text = NULL;
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 0 )
  {
    text = lookup_widget(GTK_WIDGET(menuitem),"textHTML");
  }
  else
  {
    text = lookup_widget(GTK_WIDGET(menuitem),"textConvert");
  }

  gtk_editable_paste_clipboard ( GTK_EDITABLE(text) );
}


void
on_clear_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *text = NULL;
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 0 )
  {
    text = lookup_widget(GTK_WIDGET(menuitem),"textHTML");
  }
  else
  {
    text = lookup_widget(GTK_WIDGET(menuitem),"textConvert");
  }

  gtk_editable_delete_text ( GTK_EDITABLE(text), 0, -1 );
}


void
on_select_all_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *text = NULL;
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 0 )
  {
    text = lookup_widget(GTK_WIDGET(menuitem),"textHTML");
  }
  else
  {
    text = lookup_widget(GTK_WIDGET(menuitem),"textConvert");
  }

  gtk_editable_select_region ( GTK_EDITABLE(text), 0, -1);
}

void
on_view_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) == 0 )
  {
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(menuitem),"view_html"), FALSE);
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(menuitem),"view_convert"), TRUE);
  }
  else
  {
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(menuitem),"view_html"), TRUE);
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(menuitem),"view_convert"), FALSE);
  }
}


void
on_view_html_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) != 0 )
  {
    gtk_notebook_set_page((GTK_NOTEBOOK(notebook)), 0 );
  }
}


void
on_view_convert_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(menuitem),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) != 1 )
  {
    gtk_notebook_set_page((GTK_NOTEBOOK(notebook)), 1 );
  }
}

void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *propBox;
  
  propBox = create_propbox();

  gnome_window_icon_set_from_default ( GTK_WINDOW(propBox) );
  
  init_change_setting( GNOME_PROPERTY_BOX(propBox) );
 
  
  gtk_signal_connect (GTK_OBJECT(propBox), "apply", GTK_SIGNAL_FUNC (dialog_apply_callback), NULL);
  
  gtk_widget_show (propBox);
}

void
on_help_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

void
on_web_site_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gnome_url_show (url_website);
}

void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *aboutDiag;
  GtkWidget *buttonClose;
  GtkWidget *labelAboutTitle;
  GtkWidget *labelLicense;
  GtkWidget *buttonWebSite;
  GString *title;
  
  GtkWidget *pixmaptmp;

  GdkColor greencolor;
  GdkColor redcolor;

  GtkRcStyle *rc_style_green;
  GtkRcStyle *rc_style_red;

  aboutDiag = create_dialogAbout();

  gnome_window_icon_set_from_default ( GTK_WINDOW(aboutDiag) );

  buttonClose = lookup_widget(GTK_WIDGET(aboutDiag),"buttonAboutClose");
  labelAboutTitle = lookup_widget(GTK_WIDGET(aboutDiag),"labelAboutTitle");
  labelLicense = lookup_widget(GTK_WIDGET(aboutDiag),"labelLicense");
  buttonWebSite = lookup_widget(GTK_WIDGET(aboutDiag),"hrefWebSite");
                      
  title = g_string_new("");
  g_string_sprintf (title,"%s %s","Html Code Convert",VERSION);
  gtk_label_set_text ( GTK_LABEL(labelAboutTitle), title->str);
  g_string_free(title,TRUE);

  gtk_signal_connect_object(GTK_OBJECT (buttonClose), "clicked",
                            GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(aboutDiag) );
  
  gnome_href_set_url ( GNOME_HREF(buttonWebSite), url_website);
  gnome_href_set_label ( GNOME_HREF(buttonWebSite), url_website);

  greencolor.red = 0;
  greencolor.green = 20000;
  greencolor.blue = 0;
  rc_style_green = gtk_rc_style_new ();
  rc_style_green->fg[GTK_STATE_NORMAL] = greencolor;
  rc_style_green->color_flags[GTK_STATE_NORMAL] |= GTK_RC_FG ;
  gtk_widget_modify_style (labelAboutTitle, rc_style_green);
  gtk_rc_style_unref (rc_style_green);

  redcolor.red = 20000;
  redcolor.green = 0;
  redcolor.blue = 0;
  rc_style_red = gtk_rc_style_new ();
  rc_style_red->fg[GTK_STATE_NORMAL] = redcolor;
  rc_style_red->color_flags[GTK_STATE_NORMAL] |= GTK_RC_FG ;
  gtk_widget_modify_style (labelLicense, rc_style_red);
  gtk_rc_style_unref (rc_style_red);

  pixmaptmp = lookup_widget(GTK_WIDGET(aboutDiag),"pixmapLeft");
  gnome_pixmap_load_xpm_d ( GNOME_PIXMAP(pixmaptmp), ( gchar **) ti_lapin_bleu_xpm );

  pixmaptmp = lookup_widget(GTK_WIDGET(aboutDiag),"pixmapRight");
  gnome_pixmap_load_xpm_d ( GNOME_PIXMAP(pixmaptmp), ( gchar **) ti_lapin_xpm );

  gtk_widget_show (aboutDiag);
}


void
on_notebookHTMLConvert_switch_page     (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  GtkWidget *textHTML;

  textHTML = lookup_widget(GTK_WIDGET(notebook),"textHTML");

  if ( page_num == 0 )
  {
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(notebook),"buttonHTML"), FALSE);
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(notebook),"buttonConvert"), TRUE);
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(notebook),"view_convert"), TRUE);
  }
  else
  {
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(notebook),"buttonHTML"), TRUE);
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(notebook),"buttonConvert"), FALSE);
    gtk_widget_set_sensitive (lookup_widget(GTK_WIDGET(notebook),"view_html"), TRUE);
  }

  if ( page_num == 1 && gtk_text_get_length( GTK_TEXT(textHTML) ) > 0 && inConvert == FALSE )
  {
  set_state_menu_start_convert ( GTK_WIDGET(notebook) );
  inConvert = TRUE;
    if ( gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(lookup_widget( GTK_WIDGET(notebook),"radiobuttonJS" )) ) )
    {
      convert_JS( GTK_WIDGET(notebook) );
    }
    else if ( gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(lookup_widget( GTK_WIDGET(notebook),"radiobuttonJSP" )) ) )
    {
      convert_JSP( GTK_WIDGET(notebook) );
    }
    else if ( gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(lookup_widget( GTK_WIDGET(notebook),"radiobuttonASP" )) ) )
    {
      convert_ASP( GTK_WIDGET(notebook) );
    }
    else if ( gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(lookup_widget( GTK_WIDGET(notebook),"radiobuttonPHP" )) ) )
    {
      convert_PHP( GTK_WIDGET(notebook) );
    }
    else if ( gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(lookup_widget( GTK_WIDGET(notebook),"radiobuttonPerl" )) ) )
    {
      convert_Perl( GTK_WIDGET(notebook) );
    }
    else if ( gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(lookup_widget( GTK_WIDGET(notebook),"radiobuttonShell" )) ) )
    {
      convert_Shell( GTK_WIDGET(notebook) );
    }
  inConvert = FALSE;
  set_state_menu_terminate_convert ( GTK_WIDGET(notebook) );
  }
}


void
on_buttonOpen_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  create_openfile_dialog ( GTK_WIDGET(button), user_data);
}


void
on_buttonSaveAs_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  create_save_as_dialog ( GTK_WIDGET(button), user_data);
}

void
on_buttonHTML_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(button),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) != 0 )
  {
    gtk_notebook_set_page((GTK_NOTEBOOK(notebook)), 0 );
  }
}

void
on_buttonConvert_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *notebook;

  notebook = lookup_widget(GTK_WIDGET(button),"notebookHTMLConvert");

  if ( gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)) != 1 )
  {
    gtk_notebook_set_page((GTK_NOTEBOOK(notebook)), 1 );
  }
}

void
on_buttonStop_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  inConvert = FALSE;
}

void
on_buttonQuit_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  terminate_app();
  gtk_main_quit();
}



void
on_checkJSHeader_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textJSHeader" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_checkJSFooter_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textJSFooter" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );

  active_apply_prop( GTK_WIDGET(button) );
}


void
on_textJSHeader_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_textJSFooter_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_buttonJSDefault_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  load_default_setting( GTK_WIDGET(button), "JS" );
}


void
on_checkJSPHeader_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textJSPHeader" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_checkJSPFooter_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textJSPFooter" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_textJSPHeader_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_textJSPFooter_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_buttonJSPDefault_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  load_default_setting( GTK_WIDGET(button), "JSP" );
}


void
on_checkASPHeader_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textASPHeader" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_checkASPFooter_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textASPFooter" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_textASPHeader_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_textASPFooter_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_buttonASPDefault_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  load_default_setting( GTK_WIDGET(button), "ASP" );
}


void
on_checkPHPHeader_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textPHPHeader" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_checkPHPFooter_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textPHPFooter" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_textPHPFooter_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_textPHPHeader_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_buttonPHPDefault_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  load_default_setting( GTK_WIDGET(button), "PHP" );
}


void
on_checkPerlHeader_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textPerlHeader" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_checkPerlFooter_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textPerlFooter" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_textPerlHeader_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_textPerlFooter_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_buttonPerlDefault_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  load_default_setting( GTK_WIDGET(button), "Perl" );
}


void
on_checkShellHeader_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textShellHeader" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_checkShellFooter_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *text;
  
  text = lookup_widget( GTK_WIDGET(button), "textShellFooter" );
  gtk_widget_set_sensitive( text, gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(button) ) );
  
  active_apply_prop( GTK_WIDGET(button) );
}


void
on_textShellHeader_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_textShellFooter_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  active_apply_prop( GTK_WIDGET(editable) );
}


void
on_buttonShellDefault_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  load_default_setting( GTK_WIDGET(button), "Shell" );
}

